/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.laboratory;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.entity.TestEntityIdentityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestInvestigationTypeBuilder
extends AbstractTestEntityBuilder<Entity, TestInvestigationTypeBuilder> {
    private final Map<Party, String> accountIds = new HashMap<Party, String>();
    private String typeIdArchetype;
    private ValueStrategy typeId = ValueStrategy.unset();
    private ValueStrategy typeIdName = ValueStrategy.unset();
    private Entity laboratory;
    private Entity[] devices;

    public TestInvestigationTypeBuilder(ArchetypeService service) {
        super("entity.investigationType", Entity.class, service);
        this.name(ValueStrategy.random("zinvestigationtype"));
    }

    public TestInvestigationTypeBuilder typeId(String typeId) {
        return this.typeId("entityIdentity.investigationTypeTest", ValueStrategy.value(typeId), ValueStrategy.value(typeId));
    }

    public TestInvestigationTypeBuilder typeId(String archetype, String typeId) {
        return this.typeId(archetype, ValueStrategy.value(typeId), ValueStrategy.unset());
    }

    public TestInvestigationTypeBuilder typeId(String archetype, ValueStrategy typeId, ValueStrategy typeIdName) {
        this.typeIdArchetype = archetype;
        this.typeId = typeId;
        this.typeIdName = typeIdName;
        return this;
    }

    public TestInvestigationTypeBuilder laboratory(Entity laboratory) {
        this.laboratory = laboratory;
        return this;
    }

    public TestInvestigationTypeBuilder addDevices(Entity ... devices) {
        this.devices = devices;
        return this;
    }

    public TestInvestigationTypeBuilder accountId(String accountId, Party location) {
        this.accountIds.put(location, accountId);
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.typeId.isSet()) {
            EntityIdentity identity = ((TestEntityIdentityBuilder)this.newEntityIdentity(this.typeIdArchetype).identity(this.typeId).name(this.typeIdName)).build();
            object.addIdentity(identity);
        }
        if (this.laboratory != null) {
            bean.setTarget("laboratory", (IMObject)this.laboratory);
        }
        if (this.devices != null) {
            for (Entity device : this.devices) {
                bean.addTarget("devices", (IMObject)device);
            }
        }
        for (Map.Entry entry : this.accountIds.entrySet()) {
            Relationship relationship = bean.addTarget("locations", (IMObject)entry.getKey());
            IMObjectBean relationshipBean = this.getBean((IMObject)relationship);
            relationshipBean.setValue("accountId", entry.getValue());
        }
    }
}

