/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.insurance;

import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestPolicyBuilder
extends AbstractTestActBuilder<Act, TestPolicyBuilder> {
    private Party customer;
    private Party patient;
    private Party insurer;
    private String policyNumberArchetype;
    private ValueStrategy policyNumber = ValueStrategy.unset();

    public TestPolicyBuilder(ArchetypeService service) {
        super("act.patientInsurancePolicy", Act.class, service);
    }

    public TestPolicyBuilder customer(Party customer) {
        this.customer = customer;
        return this;
    }

    public TestPolicyBuilder patient(Party patient) {
        this.patient = patient;
        return this;
    }

    public TestPolicyBuilder insurer(Party insurer) {
        this.insurer = insurer;
        return this;
    }

    public TestPolicyBuilder policyNumber(String policyNumber) {
        return this.policyNumber(ValueStrategy.value(policyNumber));
    }

    public TestPolicyBuilder policyNumber(ValueStrategy policyNumber) {
        return this.policyNumber(this.policyNumberArchetype, policyNumber);
    }

    public TestPolicyBuilder policyNumber(String archetype, String policyNumber) {
        return this.policyNumber(archetype, ValueStrategy.value(policyNumber));
    }

    public TestPolicyBuilder policyNumber(String archetype, ValueStrategy policyNumber) {
        this.policyNumberArchetype = archetype;
        this.policyNumber = policyNumber;
        return this;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        bean.setTarget("customer", (IMObject)this.customer);
        bean.setTarget("patient", (IMObject)this.patient);
        bean.setTarget("insurer", (IMObject)this.insurer);
        if (this.policyNumber.isSet()) {
            object.addIdentity(this.createActIdentity("actIdentity.insurancePolicy", this.policyNumber));
        }
    }
}

