/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestDocumentVerifier<B extends TestDocumentVerifier<B>> {
    protected final DocumentHandlers handlers;
    protected final ArchetypeService service;
    private String archetype;
    private String name;
    private String mimeType;
    private long size;
    private long checksum;
    private byte[] content;

    public TestDocumentVerifier(DocumentHandlers handlers, ArchetypeService service) {
        this.handlers = handlers;
        this.service = service;
    }

    public B initialise(Document document) {
        this.archetype(document.getArchetype());
        this.name(document.getName());
        this.mimeType(document.getMimeType());
        this.size(document.getSize());
        this.checksum(document.getChecksum());
        this.content(document);
        return this.getThis();
    }

    public B archetype(String archetype) {
        this.archetype = archetype;
        return this.getThis();
    }

    public B name(String name) {
        this.name = name;
        return this.getThis();
    }

    public B mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this.getThis();
    }

    public B size(long size) {
        this.size = size;
        return this.getThis();
    }

    public B checksum(long checksum) {
        this.checksum = checksum;
        return this.getThis();
    }

    public B content(InputStream stream) throws IOException {
        return this.content(this.getContent(stream));
    }

    public B content(Document document) {
        return this.content(this.getContent(document));
    }

    public B content(byte[] content) {
        this.content = content;
        return this.getThis();
    }

    public void verify(Document document) {
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)this.archetype, (Object)document.getArchetype());
        Assert.assertEquals((Object)this.name, (Object)document.getName());
        Assert.assertEquals((Object)this.mimeType, (Object)document.getMimeType());
        Assert.assertEquals((long)this.size, (long)document.getSize());
        Assert.assertEquals((long)this.checksum, (long)document.getChecksum());
        Assert.assertArrayEquals((byte[])this.content, (byte[])this.getContent(document));
    }

    protected B getThis() {
        return (B)this;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    private byte[] getContent(Document document) {
        byte[] content;
        try (InputStream input = this.handlers.get(document).getContent(document);){
            content = this.getContent(input);
        }
        catch (IOException exception) {
            throw new DocumentException(DocumentException.ErrorCode.ReadError, new Object[]{document.getName()});
        }
        return content;
    }

    private byte[] getContent(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)output);
        byte[] content = output.toByteArray();
        return content;
    }
}

