/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import java.util.Set;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestDocumentTemplatePrinterBuilder
extends AbstractTestIMObjectBuilder<EntityRelationship, TestDocumentTemplatePrinterBuilder> {
    private final TestDocumentTemplateBuilder parent;
    private Party location;
    private PrinterReference printer;
    private String paperTray;
    private Boolean interactive;

    public TestDocumentTemplatePrinterBuilder(ArchetypeService service) {
        this((TestDocumentTemplateBuilder)null, service);
    }

    public TestDocumentTemplatePrinterBuilder(TestDocumentTemplateBuilder parent, ArchetypeService service) {
        super("entityRelationship.documentTemplatePrinter", EntityRelationship.class, service);
        this.parent = parent;
    }

    public TestDocumentTemplatePrinterBuilder location(Party location) {
        this.location = location;
        return this;
    }

    public TestDocumentTemplatePrinterBuilder printer(String printer) {
        return this.printer(PrinterReference.fromString((String)printer));
    }

    public TestDocumentTemplatePrinterBuilder printer(PrinterReference printer) {
        this.printer = printer;
        return this;
    }

    public TestDocumentTemplatePrinterBuilder paperTray(String paperTray) {
        this.paperTray = paperTray;
        return this;
    }

    public TestDocumentTemplatePrinterBuilder interactive(boolean interactive) {
        this.interactive = interactive;
        return this;
    }

    @Override
    public EntityRelationship build() {
        return (EntityRelationship)this.build(false);
    }

    public TestDocumentTemplateBuilder add() {
        EntityRelationship relationship = this.build();
        this.parent.addPrinter(relationship, this.location);
        return this.parent;
    }

    @Override
    protected void build(EntityRelationship object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.location != null) {
            object.setTarget(this.location.getObjectReference());
        }
        if (this.printer != null) {
            bean.setValue("printer", (Object)this.printer.toString());
        }
        if (this.paperTray != null) {
            bean.setValue("paperTray", (Object)this.paperTray);
        }
        if (this.interactive != null) {
            bean.setValue("interactive", (Object)this.interactive);
        }
    }
}

