/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestDocumentBuilder
extends AbstractTestIMObjectBuilder<org.openvpms.component.model.document.Document, TestDocumentBuilder> {
    private final DocumentHandlers handlers;
    private InputStream content;
    private String mimeType;

    public TestDocumentBuilder(DocumentHandlers handlers, ArchetypeService service) {
        super(null, org.openvpms.component.model.document.Document.class, service);
        this.handlers = handlers;
    }

    public TestDocumentBuilder mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public TestDocumentBuilder content(InputStream content) {
        this.content = content;
        return this;
    }

    public TestDocumentBuilder content(String content) {
        return this.content(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
    }

    public TestDocumentBuilder content(byte[] content) {
        this.content = new ByteArrayInputStream(content);
        return this;
    }

    @Override
    public org.openvpms.component.model.document.Document build(Set<IMObject> objects, Set<Reference> remove) {
        String name = this.getName().toString();
        DocumentHandler handler = this.handlers.get(name, this.mimeType);
        Document document = handler.create(name, this.content, this.mimeType, -1);
        objects.add((IMObject)document);
        return document;
    }
}

