/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.SupportedImageDocumentHandler;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestImageDocumentVerifier;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class SupportedImageDocumentHandlerTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testCanHandleFileAndMimeType() {
        SupportedImageDocumentHandler handler = new SupportedImageDocumentHandler((ArchetypeService)this.getArchetypeService());
        Assert.assertTrue((boolean)handler.canHandle("foo.bmp", "image/bmp"));
        Assert.assertTrue((boolean)handler.canHandle("foo.gif", "image/gif"));
        Assert.assertTrue((boolean)handler.canHandle("foo.png", "image/png"));
        Assert.assertTrue((boolean)handler.canHandle("foo.png", "image/x-png"));
        Assert.assertTrue((boolean)handler.canHandle("foo.jpg", "image/jpg"));
        Assert.assertFalse((boolean)handler.canHandle("foo.pdf", "application/pdf"));
        Assert.assertFalse((boolean)handler.canHandle("foo.txt", "text/plain"));
    }

    @Test
    public void testCanHandleFileDocumentAndMimeType() {
        SupportedImageDocumentHandler handler = new SupportedImageDocumentHandler((ArchetypeService)this.getArchetypeService());
        Assert.assertTrue((boolean)handler.canHandle("foo.bmp", "document.image", "image/bmp"));
        Assert.assertTrue((boolean)handler.canHandle("foo.gif", "document.image", "image/gif"));
        Assert.assertTrue((boolean)handler.canHandle("foo.png", "document.image", "image/png"));
        Assert.assertTrue((boolean)handler.canHandle("foo.png", "document.image", "image/x-png"));
        Assert.assertTrue((boolean)handler.canHandle("foo.jpg", "document.image", "image/jpg"));
        Assert.assertFalse((boolean)handler.canHandle("foo.bmp", "document.other", "image/bmp"));
    }

    @Test
    public void testCanHandleDocument() {
        SupportedImageDocumentHandler handler = new SupportedImageDocumentHandler((ArchetypeService)this.getArchetypeService());
        org.openvpms.component.model.document.Document doc1 = this.create("document.image", org.openvpms.component.model.document.Document.class);
        org.openvpms.component.model.document.Document doc2 = this.create("document.other", org.openvpms.component.model.document.Document.class);
        Assert.assertTrue((boolean)handler.canHandle(doc1));
        Assert.assertFalse((boolean)handler.canHandle(doc2));
    }

    @Test
    public void testCreateFromStream() throws Exception {
        SupportedImageDocumentHandler handler = new SupportedImageDocumentHandler((ArchetypeService)this.getArchetypeService());
        byte[] bytes = this.getImage("/documents/image.png");
        String name = "image.png";
        String mimeType = "image/png";
        Document document = handler.create(name, (InputStream)new ByteArrayInputStream(bytes), mimeType, -1);
        ((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)this.documentFactory.newImageVerifier().name(name)).mimeType(mimeType)).size(7547L)).checksum(84220208L)).width(26).height(27).content(bytes)).verify((org.openvpms.component.model.document.Document)document);
    }

    @Test
    public void testReadLargePNG() throws Exception {
        SupportedImageDocumentHandler handler = new SupportedImageDocumentHandler((ArchetypeService)this.getArchetypeService());
        byte[] bytes = this.getImage("/documents/largeimage.png");
        String name = "largeimage.png";
        String mimeType = "image/png";
        Document document = handler.create(name, (InputStream)new ByteArrayInputStream(bytes), mimeType, -1);
        ((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)this.documentFactory.newImageVerifier().name(name)).mimeType(mimeType)).size(74865L)).checksum(2122638163L)).width(1000).height(1000).content(bytes)).verify((org.openvpms.component.model.document.Document)document);
    }

    @Test
    public void testReadLargeJPG() throws Exception {
        SupportedImageDocumentHandler handler = new SupportedImageDocumentHandler((ArchetypeService)this.getArchetypeService());
        byte[] bytes = this.getImage("/documents/largeimage.jpg");
        String name = "largeimage.jpg";
        String mimeType = "image/jpg";
        Document document = handler.create(name, (InputStream)new ByteArrayInputStream(bytes), mimeType, -1);
        ((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)this.documentFactory.newImageVerifier().name(name)).mimeType(mimeType)).size(122842L)).checksum(4280779L)).width(1000).height(1000).content(bytes)).verify((org.openvpms.component.model.document.Document)document);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreateFromArray() {
        SupportedImageDocumentHandler handler = new SupportedImageDocumentHandler((ArchetypeService)this.getArchetypeService());
        handler.create("image.png", new byte[0], "image/png", -1);
    }

    @Test
    public void testUpdate() throws Exception {
        SupportedImageDocumentHandler handler = new SupportedImageDocumentHandler((ArchetypeService)this.getArchetypeService());
        String name = "image.png";
        String mimeType = "image/png";
        Document document = handler.create(name, (InputStream)new ByteArrayInputStream(this.getImage("/documents/image.png")), mimeType, -1);
        byte[] bytes = this.getImage("/documents/image2.png");
        handler.update(document, (InputStream)new ByteArrayInputStream(bytes), mimeType, bytes.length);
        ((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)((TestImageDocumentVerifier)this.documentFactory.newImageVerifier().name(name)).mimeType(mimeType)).size(189L)).checksum(3336140538L)).width(16).height(16).content(bytes)).verify((org.openvpms.component.model.document.Document)document);
    }

    private byte[] getImage(String path) throws Exception {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        Assert.assertNotNull((Object)stream);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)stream, (OutputStream)byteStream);
        return byteStream.toByteArray();
    }

    private byte[] generateImage(String format) throws Exception {
        int size = 1000;
        int square = 10;
        BufferedImage image = new BufferedImage(size, size, 1);
        Graphics2D graphics = image.createGraphics();
        int r = 0;
        for (int row = 0; row < size / square; ++row) {
            for (int col = 0; col < size / square; ++col) {
                graphics.setColor(new Color(r, row, col));
                if ((r += 25) > 255) {
                    r = 0;
                }
                graphics.fillRect(col * square, row * square, square, square);
            }
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
        ImageIO.write((RenderedImage)image, format, output);
        return output.toByteArray();
    }
}

