/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.test.builder.customer.account.AbstractTestCustomerAccountActBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerChargeItemBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestCustomerChargeBuilder<B extends TestCustomerChargeBuilder<B, I>, I extends TestCustomerChargeItemBuilder<B, I>>
extends AbstractTestCustomerAccountActBuilder<B> {
    private final List<FinancialAct> items = new ArrayList<FinancialAct>();
    private List<FinancialAct> builtItems = new ArrayList<FinancialAct>();
    private User clinician;
    private ValueStrategy sendReminder = ValueStrategy.unset();

    public TestCustomerChargeBuilder(String archetype, ArchetypeService service) {
        super(archetype, service);
    }

    public B clinician(User clinician) {
        this.clinician = clinician;
        return (B)((TestCustomerChargeBuilder)this.getThis());
    }

    public B add(FinancialAct ... items) {
        return this.add(Arrays.asList(items));
    }

    public B add(List<FinancialAct> items) {
        this.items.addAll(items);
        return (B)((TestCustomerChargeBuilder)this.getThis());
    }

    public abstract I item();

    public List<FinancialAct> getItems() {
        return this.builtItems;
    }

    public FinancialAct getItem(Product product) {
        FinancialAct act = FinancialTestHelper.find(this.builtItems, product);
        Assert.assertNotNull((Object)act);
        return act;
    }

    public B sendReminder(boolean sendReminder) {
        this.sendReminder = ValueStrategy.value(sendReminder);
        return (B)((TestCustomerChargeBuilder)this.getThis());
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.clinician != null) {
            bean.setTarget("clinician", (IMObject)this.clinician);
        }
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        int sequence = this.getNextSequence(bean, "items");
        for (FinancialAct item : this.items) {
            ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
            relationship.setSequence(sequence++);
            item.addActRelationship(relationship);
            toSave.add((IMObject)item);
            IMObjectBean itemBean = bean.getBean((IMObject)item);
            tax = tax.add(itemBean.getBigDecimal("tax", BigDecimal.ZERO));
            amount = amount.add(itemBean.getBigDecimal("total", BigDecimal.ZERO));
        }
        bean.setValue("amount", (Object)amount);
        bean.setValue("tax", (Object)tax);
        this.sendReminder.setValue(bean, "sendReminder");
        this.builtItems = new ArrayList<FinancialAct>(this.items);
        this.items.clear();
    }
}

