/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer;

import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.alert.TestCustomerAlertBuilder;
import org.openvpms.archetype.test.builder.customer.communication.TestEmailCommunicationBuilder;
import org.openvpms.archetype.test.builder.customer.communication.TestMailCommunicationBuilder;
import org.openvpms.archetype.test.builder.customer.communication.TestNoteCommunicationBuilder;
import org.openvpms.archetype.test.builder.customer.communication.TestPhoneCommunicationBuilder;
import org.openvpms.archetype.test.builder.customer.document.TestCustomerAttachmentBuilder;
import org.openvpms.archetype.test.builder.customer.document.TestCustomerFormBuilder;
import org.openvpms.archetype.test.builder.customer.document.TestCustomerLetterBuilder;
import org.openvpms.archetype.test.builder.customer.order.TestPharmacyOrderBuilder;
import org.openvpms.archetype.test.builder.customer.order.TestPharmacyReturnBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.lookup.TestCustomerAccountTypeBuilder;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestCustomerFactory {
    private final ArchetypeService service;
    private final TestDocumentFactory documentFactory;

    public TestCustomerFactory(ArchetypeService service, TestDocumentFactory documentFactory) {
        this.service = service;
        this.documentFactory = documentFactory;
    }

    public Party createCustomer() {
        return (Party)this.newCustomer().build();
    }

    public Party createCustomer(String firstName, String lastName) {
        return (Party)this.newCustomer().name(firstName, lastName).build();
    }

    public Party createCustomer(String title, String firstName, String lastName) {
        return (Party)this.newCustomer(title, firstName, lastName).build();
    }

    public TestCustomerBuilder newCustomer(String title, String firstName, String lastName) {
        return this.newCustomer().title(title).name(firstName, lastName);
    }

    public TestCustomerBuilder newCustomer() {
        return new TestCustomerBuilder(this.service);
    }

    public TestCustomerBuilder updateCustomer(Party customer) {
        return new TestCustomerBuilder(customer, this.service);
    }

    public TestCustomerAccountTypeBuilder newAccountType() {
        return new TestCustomerAccountTypeBuilder(this.service);
    }

    public TestCustomerAlertBuilder newAlert() {
        return new TestCustomerAlertBuilder(this.service);
    }

    public TestEmailCommunicationBuilder newEmailCommunication() {
        return new TestEmailCommunicationBuilder(this.service);
    }

    public TestMailCommunicationBuilder newMailCommunication() {
        return new TestMailCommunicationBuilder(this.service);
    }

    public TestNoteCommunicationBuilder newNoteCommunication() {
        return new TestNoteCommunicationBuilder(this.service);
    }

    public TestPhoneCommunicationBuilder newPhoneCommunication() {
        return new TestPhoneCommunicationBuilder(this.service);
    }

    public TestCustomerAttachmentBuilder newAttachment() {
        return new TestCustomerAttachmentBuilder(this.service);
    }

    public TestCustomerAttachmentBuilder updateAttachment(DocumentAct attachment) {
        return new TestCustomerAttachmentBuilder(attachment, this.service);
    }

    public TestCustomerFormBuilder newForm() {
        return new TestCustomerFormBuilder(this.service, this.documentFactory);
    }

    public TestCustomerLetterBuilder newLetter() {
        return new TestCustomerLetterBuilder(this.service);
    }

    public TestCustomerLetterBuilder updateLetter(DocumentAct letter) {
        return new TestCustomerLetterBuilder(letter, this.service);
    }

    public TestPharmacyOrderBuilder newPharmacyOrder() {
        return new TestPharmacyOrderBuilder(this.service);
    }

    public TestPharmacyReturnBuilder newPharmacyReturn() {
        return new TestPharmacyReturnBuilder(this.service);
    }
}

