/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.AbstractTestPartyBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestCustomerBuilder
extends AbstractTestPartyBuilder<Party, TestCustomerBuilder> {
    private final List<Party> patients = new ArrayList<Party>();
    private ValueStrategy titleCode = ValueStrategy.unset();
    private ValueStrategy firstName = ValueStrategy.unset();
    private ValueStrategy lastName = ValueStrategy.unset();
    private ValueStrategy companyName = ValueStrategy.unset();
    private ValueStrategy referredBy = ValueStrategy.unset();
    private ValueStrategy referredByCustomer = ValueStrategy.unset();
    private Entity[] discounts;
    private String[] taxExemptionCodes;
    private Party practice;

    public TestCustomerBuilder(ArchetypeService service) {
        super("party.customerperson", Party.class, service);
        this.firstName("J");
        this.lastName(ValueStrategy.random("Smith"));
    }

    public TestCustomerBuilder(Party object, ArchetypeService service) {
        super(object, service);
    }

    public TestCustomerBuilder title(String titleCode) {
        this.titleCode = ValueStrategy.value(titleCode);
        return this;
    }

    public TestCustomerBuilder firstName(String firstName) {
        return this.firstName(ValueStrategy.value(firstName));
    }

    public TestCustomerBuilder firstName(ValueStrategy firstName) {
        this.firstName = firstName;
        return this;
    }

    public TestCustomerBuilder lastName(String lastName) {
        return this.lastName(ValueStrategy.value(lastName));
    }

    public TestCustomerBuilder lastName(ValueStrategy lastName) {
        this.lastName = lastName;
        return this;
    }

    public TestCustomerBuilder name(String firstName, String lastName) {
        this.firstName(firstName);
        return this.lastName(lastName);
    }

    public TestCustomerBuilder name(String titleCode, String firstName, String lastName) {
        this.name(firstName, lastName);
        return this.title(titleCode);
    }

    public TestCustomerBuilder companyName(String companyName) {
        this.companyName = ValueStrategy.value(companyName);
        return this;
    }

    public TestCustomerBuilder referredBy(String referredBy) {
        this.referredBy = ValueStrategy.value(referredBy);
        return this;
    }

    public TestCustomerBuilder referredByCustomer(Party customer) {
        this.referredByCustomer = ValueStrategy.value(customer);
        return this;
    }

    public TestCustomerBuilder addHomePhone(String phone) {
        this.addPhone(phone, "HOME");
        return this;
    }

    public TestCustomerBuilder addWorkPhone(String phone) {
        this.addPhone(phone, "WORK");
        return this;
    }

    public TestCustomerBuilder addDiscounts(Entity ... discounts) {
        this.discounts = discounts;
        return this;
    }

    public TestCustomerBuilder addTaxExemptions(String ... taxCodes) {
        this.taxExemptionCodes = taxCodes;
        return this;
    }

    public TestCustomerBuilder practice(Party practice) {
        this.practice = practice;
        return this;
    }

    public TestCustomerBuilder addCodeIdentity(String code) {
        this.addIdentities(this.createEntityIdentity("entityIdentity.code", ValueStrategy.value(code)));
        return this;
    }

    public TestCustomerBuilder addPatient(Party patient) {
        this.patients.add(patient);
        return this;
    }

    @Override
    protected void build(Party object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.titleCode.isSet()) {
            if (this.titleCode.getValue() != null) {
                ((TestLookupBuilder)new TestLookupBuilder("lookup.personTitle", this.getService()).code(this.titleCode.toString())).build();
            }
            this.titleCode.setValue(bean, "title");
        }
        this.firstName.setValue(bean, "firstName");
        this.lastName.setValue(bean, "lastName");
        this.companyName.setValue(bean, "companyName");
        if (this.referredBy.isSet()) {
            ((TestLookupBuilder)new TestLookupBuilder("lookup.customerReferral", this.getService()).code(this.referredBy.toString())).build();
            this.referredBy.setValue(bean, "referral");
        }
        if (this.referredByCustomer.isSet()) {
            bean.setTarget("referredByCustomer", (IMObject)((Party)this.referredByCustomer.getValue()));
        }
        if (this.discounts != null) {
            for (Entity discount : this.discounts) {
                bean.addTarget("discounts", (IMObject)discount);
            }
        }
        if (this.taxExemptionCodes != null) {
            for (String code : this.taxExemptionCodes) {
                Lookup taxType = (Lookup)((TestLookupBuilder)new TestLookupBuilder("lookup.taxType", this.getService()).code(code)).build();
                object.addClassification(taxType);
            }
        }
        if (this.practice != null) {
            bean.setTarget("practice", (IMObject)this.practice);
        }
        if (!this.patients.isEmpty()) {
            for (Party patient : this.patients) {
                bean.addTarget("patients", "entityRelationship.patientOwner", (IMObject)patient);
            }
            this.patients.clear();
        }
    }
}

