/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.act;

import java.util.Set;
import org.junit.Assert;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class LongTextBuilder {
    private final String node;
    private final String longNode;
    private final ArchetypeService service;

    public LongTextBuilder(String node, String longNode, ArchetypeService service) {
        this.node = node;
        this.longNode = longNode;
        this.service = service;
    }

    public void build(ValueStrategy value, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        if (value.isSet()) {
            Document content;
            String text = value.toString();
            DocumentAct related = (DocumentAct)bean.getTarget(this.longNode, DocumentAct.class);
            Document document = content = related != null && related.getDocument() != null ? (Document)bean.getObject(related.getDocument(), Document.class) : null;
            if (text == null || text.length() <= bean.getMaxLength(this.node)) {
                bean.setValue(this.node, (Object)text);
                if (related != null) {
                    toRemove.add(related.getObjectReference());
                }
                if (content != null) {
                    toRemove.add((Reference)content.getObjectReference());
                }
            } else {
                bean.setValue(this.node, null);
                TextDocumentHandler handler = new TextDocumentHandler(this.service);
                if (related == null) {
                    String[] relationshipArchetypes = bean.getArchetypeRange(this.longNode);
                    Assert.assertEquals((long)1L, (long)relationshipArchetypes.length);
                    String[] targets = DescriptorHelper.getNodeShortNames((String[])relationshipArchetypes, (String)"target", (ArchetypeService)this.service);
                    Assert.assertEquals((long)1L, (long)targets.length);
                    related = (DocumentAct)this.service.create(targets[0], DocumentAct.class);
                    ActRelationship relationship = (ActRelationship)bean.addTarget(this.longNode, (IMObject)related);
                    related.addActRelationship(relationship);
                }
                if (content == null) {
                    content = handler.create("document", text);
                    toSave.add((IMObject)content);
                    related.setDocument((Reference)content.getObjectReference());
                } else {
                    handler.update(content, text);
                }
                toSave.add((IMObject)related);
            }
        }
    }
}

