/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.business.service.archetype.helper.LookupHelper;
import org.openvpms.component.business.service.lookup.LookupServiceHelper;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeConstraint;

public class TestHelper {
    private static final Random random = new SecureRandom();

    public static org.openvpms.component.model.object.IMObject create(String shortName) {
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        IMObject object = service.create(shortName);
        Assert.assertNotNull((Object)object);
        return object;
    }

    public static <T extends org.openvpms.component.model.object.IMObject> T create(String archetype, Class<T> type) {
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        return (T)service.create(archetype, type);
    }

    public static void save(org.openvpms.component.model.object.IMObject object) {
        ArchetypeServiceHelper.getArchetypeService().save(object);
    }

    public static void save(org.openvpms.component.model.object.IMObject ... objects) {
        TestHelper.save(Arrays.asList(objects));
    }

    public static void save(Collection<? extends org.openvpms.component.model.object.IMObject> objects) {
        ArchetypeServiceHelper.getArchetypeService().save(objects);
    }

    public static Party createCustomer(String firstName, String lastName, boolean save) {
        return TestHelper.createCustomer(firstName, lastName, true, save);
    }

    public static Party createCustomer(String firstName, String lastName, boolean defaultContacts, boolean save) {
        Party customer = TestHelper.create("party.customerperson", Party.class);
        if (defaultContacts) {
            PartyRules rules = new PartyRules(ArchetypeServiceHelper.getArchetypeService(), (LookupService)LookupServiceHelper.getLookupService());
            for (Contact contact : rules.getDefaultContacts()) {
                customer.addContact(contact);
            }
        }
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)customer);
        bean.setValue("firstName", (Object)firstName);
        bean.setValue("lastName", (Object)lastName);
        if (save) {
            bean.save();
        }
        return customer;
    }

    public static Party createCustomer() {
        return TestHelper.createCustomer(true);
    }

    public static Party createCustomer(Contact ... contacts) {
        return TestHelper.createCustomer("MR", "J", TestHelper.randomName("Zoo-"), contacts);
    }

    public static Party createCustomer(String titleCode, String firstName, String lastName, Contact ... contacts) {
        Party customer = TestHelper.createCustomer(firstName, lastName, false, false);
        if (titleCode != null) {
            IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)customer);
            bean.setValue("title", (Object)TestHelper.getLookup("lookup.personTitle", titleCode).getCode());
        }
        for (Contact contact : contacts) {
            customer.addContact(contact);
        }
        TestHelper.save((org.openvpms.component.model.object.IMObject)customer);
        return customer;
    }

    public static Party createCustomer(String titleCode, String firstName, String lastName, String address, String suburbCode, String stateCode, String postCode, String homePhone, String workPhone, String mobilePhone, String email) {
        Party customer = TestHelper.createCustomer(firstName, lastName, false, false);
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)customer);
        if (titleCode != null) {
            bean.setValue("title", (Object)TestHelper.getLookup("lookup.personTitle", titleCode).getCode());
        }
        customer.addContact(TestHelper.createLocationContact(address, suburbCode, stateCode, postCode));
        if (homePhone != null) {
            customer.addContact(TestHelper.createPhoneContact(null, homePhone, false, false, "HOME"));
        }
        if (workPhone != null) {
            customer.addContact(TestHelper.createPhoneContact(null, workPhone, false, false, "WORK"));
        }
        if (mobilePhone != null) {
            customer.addContact(TestHelper.createPhoneContact(null, mobilePhone, true));
        }
        if (email != null) {
            customer.addContact(TestHelper.createEmailContact(email));
        }
        TestHelper.save((org.openvpms.component.model.object.IMObject)customer);
        return customer;
    }

    public static Party createCustomer(boolean save) {
        return TestHelper.createCustomer("J", TestHelper.randomName("Zoo-"), save);
    }

    public static Party createCustomer(Party location) {
        Party customer = TestHelper.createCustomer();
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)customer);
        bean.setTarget("practice", (org.openvpms.component.model.object.IMObject)location);
        bean.save();
        return customer;
    }

    public static Contact createLocationContact(String address, String suburbCode, String suburbName, String stateCode, String stateName, String postCode) {
        Lookup state = TestHelper.getLookup("lookup.state", stateCode, stateName, true);
        Lookup suburb = TestHelper.getLookup("lookup.suburb", suburbCode, suburbName, state, "lookupRelationship.stateSuburb");
        Contact contact = TestHelper.create("contact.location", Contact.class);
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)contact);
        bean.setValue("address", (Object)address);
        bean.setValue("suburb", (Object)suburb.getCode());
        bean.setValue("state", (Object)state.getCode());
        bean.setValue("postcode", (Object)postCode);
        return contact;
    }

    public static Contact createPhoneContact(String areaCode, String number) {
        return TestHelper.createPhoneContact(areaCode, number, false);
    }

    public static Contact createPhoneContact(String areaCode, String number, boolean sms) {
        return TestHelper.createPhoneContact(areaCode, number, sms, true, null);
    }

    public static Contact createPhoneContact(String areaCode, String number, boolean sms, boolean preferred, String purpose) {
        Contact contact = TestHelper.create("contact.phoneNumber", Contact.class);
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)contact);
        bean.setValue("areaCode", (Object)areaCode);
        bean.setValue("telephoneNumber", (Object)number);
        bean.setValue("sms", (Object)sms);
        bean.setValue("preferred", (Object)preferred);
        if (purpose != null) {
            contact.addClassification(TestHelper.getLookup("lookup.contactPurpose", purpose));
        }
        return contact;
    }

    public static Contact createEmailContact(String address) {
        return TestHelper.createEmailContact(address, true, null);
    }

    public static Contact createEmailContact(String address, boolean preferred, String purpose) {
        Contact contact = TestHelper.create("contact.email", Contact.class);
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)contact);
        bean.setValue("emailAddress", (Object)address);
        bean.setValue("preferred", (Object)preferred);
        if (purpose != null) {
            contact.addClassification(TestHelper.getLookup("lookup.contactPurpose", purpose));
        }
        return contact;
    }

    public static Contact createLocationContact(String address, String suburbCode, String stateCode, String postCode) {
        return TestHelper.createLocationContact(address, suburbCode, null, stateCode, null, postCode);
    }

    public static Party createPatient() {
        return TestHelper.createPatient(true);
    }

    public static Party createPatient(boolean save) {
        return TestHelper.createPatient(TestHelper.randomName("XPatient-"), save);
    }

    public static Party createPatient(String name, boolean save) {
        Party patient = TestHelper.create("party.patientpet", Party.class);
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)patient);
        bean.setValue("name", (Object)name);
        bean.setValue("species", (Object)"CANINE");
        bean.setValue("deceased", (Object)false);
        if (save) {
            bean.save();
        }
        return patient;
    }

    public static Party createPatient(Party owner) {
        return TestHelper.createPatient(owner, true);
    }

    public static Party createPatient(Party owner, boolean save) {
        return TestHelper.createPatient(TestHelper.randomName("XPatient-"), owner, save);
    }

    public static Party createPatient(String name, Party owner, boolean save) {
        Party patient = TestHelper.createPatient(name, save);
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        PatientRules rules = new PatientRules(null, null, service, null, null);
        rules.addPatientOwnerRelationship(owner, patient);
        if (save) {
            TestHelper.save(new org.openvpms.component.model.object.IMObject[]{owner, patient});
        }
        return patient;
    }

    public static User createUser() {
        return TestHelper.createUser(true);
    }

    public static User createUser(boolean save) {
        return TestHelper.createUser(TestHelper.randomName("zuser"), save);
    }

    public static User createUser(String username, boolean save) {
        return TestHelper.createUser(username, null, null, save);
    }

    public static User createUser(String firstName, String lastName) {
        return TestHelper.createUser(TestHelper.randomName("user"), firstName, lastName, true);
    }

    public static User createUser(String username, String firstName, String lastName, boolean save) {
        User user = TestHelper.create("security.user", User.class);
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)user);
        bean.setValue("name", (Object)username);
        bean.setValue("username", (Object)username);
        bean.setValue("firstName", (Object)firstName);
        bean.setValue("lastName", (Object)lastName);
        if (!StringUtils.isEmpty((CharSequence)firstName) && !StringUtils.isEmpty((CharSequence)lastName)) {
            bean.setValue("name", (Object)(firstName + " " + lastName));
        }
        bean.setValue("password", (Object)username);
        if (save) {
            bean.save();
        }
        return user;
    }

    public static User createClinician() {
        return TestHelper.createClinician(true);
    }

    public static User createClinician(boolean save) {
        String username = TestHelper.randomName("zuser");
        User user = TestHelper.createUser(username, false);
        user.addClassification(TestHelper.getLookup("lookup.userType", "CLINICIAN"));
        if (save) {
            TestHelper.save((org.openvpms.component.model.object.IMObject)user);
        }
        return user;
    }

    public static User createAdministrator(boolean save) {
        String username = TestHelper.randomName("zuser");
        User user = TestHelper.createUser(username, false);
        user.addClassification(TestHelper.getLookup("lookup.userType", "ADMINISTRATOR"));
        if (save) {
            TestHelper.save((org.openvpms.component.model.object.IMObject)user);
        }
        return user;
    }

    public static Product createProduct() {
        return TestHelper.createProduct(null);
    }

    public static Product createProduct(String species) {
        return TestHelper.createProduct("product.medication", species);
    }

    public static Product createProduct(String shortName, String species) {
        return TestHelper.createProduct(shortName, species, true);
    }

    public static Product createProduct(String shortName, String species, boolean save) {
        Product product = TestHelper.create(shortName, Product.class);
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)product);
        String name = TestHelper.randomName("XProduct-" + (species != null ? species : ""));
        bean.setValue("name", (Object)name);
        if (species != null) {
            Lookup classification = TestHelper.getLookup("lookup.species", species);
            bean.addValue("species", (org.openvpms.component.model.object.IMObject)classification);
        }
        if (save) {
            bean.save();
        }
        return product;
    }

    public static Party createSupplier() {
        return TestHelper.createSupplier(true);
    }

    public static Party createSupplier(boolean save) {
        Party party = TestHelper.create("party.supplierorganisation", Party.class);
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)party);
        bean.setValue("name", (Object)"XSupplier");
        if (save) {
            bean.save();
        }
        return party;
    }

    public static Party createSupplierVet() {
        Party party = TestHelper.create("party.supplierVeterinarian", Party.class);
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)party);
        bean.setValue("firstName", (Object)"J");
        bean.setValue("lastName", (Object)"XSupplierVet");
        bean.setValue("title", (Object)"MR");
        bean.save();
        return party;
    }

    public static Party createSupplierVetPractice() {
        Party party = TestHelper.create("party.supplierVeterinaryPractice", Party.class);
        party.setName("XVetPractice");
        TestHelper.save((org.openvpms.component.model.object.IMObject)party);
        return party;
    }

    public static Party getPractice() {
        Party party;
        ArchetypeQuery query = new ArchetypeQuery("party.organisationPractice", true, true);
        query.setMaxResults(1);
        IMObjectQueryIterator iter = new IMObjectQueryIterator((IArchetypeQuery)query);
        if (iter.hasNext()) {
            party = (Party)iter.next();
            IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)party);
            List taxes = bean.getValues("taxes", Lookup.class);
            if (!taxes.isEmpty()) {
                Iterator iterator = taxes.iterator();
                while (iterator.hasNext()) {
                    Lookup tax = (Lookup)iterator.next();
                    bean.removeValue("taxes", (org.openvpms.component.model.object.IMObject)tax);
                }
            }
        } else {
            party = TestHelper.create("party.organisationPractice", Party.class);
            party.setName("XPractice");
        }
        PartyRules rules = new PartyRules(ArchetypeServiceHelper.getArchetypeService(), (LookupService)LookupServiceHelper.getLookupService());
        for (Contact contact : rules.getDefaultContacts()) {
            party.addContact(contact);
        }
        Lookup currency = TestHelper.getCurrency("AUD");
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)party);
        bean.setValue("currency", (Object)currency.getCode());
        bean.setValue("useLocationProducts", (Object)false);
        bean.setValue("useLoggedInClinician", (Object)true);
        bean.save();
        return party;
    }

    public static Party getPractice(BigDecimal rate) {
        Party practice = TestHelper.getPractice();
        Lookup tax = TestHelper.create("lookup.taxType", Lookup.class);
        IMObjectBean taxBean = new IMObjectBean((org.openvpms.component.model.object.IMObject)tax);
        taxBean.setValue("code", (Object)("XTAXTYPE" + Math.abs(new Random().nextInt())));
        taxBean.setValue("rate", (Object)rate);
        taxBean.save();
        practice.addClassification(tax);
        TestHelper.save((org.openvpms.component.model.object.IMObject)practice);
        return practice;
    }

    public static Lookup getCurrency(String code) {
        Lookup currency = TestHelper.getLookup("lookup.currency", code, false);
        IMObjectBean ccyBean = new IMObjectBean((org.openvpms.component.model.object.IMObject)currency);
        ccyBean.setValue("minDenomination", (Object)new BigDecimal("0.05"));
        ccyBean.setValue("minPrice", null);
        ccyBean.save();
        return currency;
    }

    public static Party createLocation() {
        return TestHelper.createLocation(false);
    }

    public static Party createLocation(boolean stockControl) {
        return TestHelper.createLocation(null, null, stockControl);
    }

    public static Party createLocation(String phone, String email, boolean stockControl) {
        Party location = TestHelper.create("party.organisationLocation", Party.class);
        location.setName("XLocation");
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)location);
        bean.setValue("stockControl", (Object)stockControl);
        if (phone != null) {
            location.addContact(TestHelper.createPhoneContact(null, phone, false));
        }
        if (email != null) {
            location.addContact(TestHelper.createEmailContact(email));
        }
        TestHelper.save((org.openvpms.component.model.object.IMObject)location);
        return location;
    }

    public static Entity createTill() {
        Entity till = TestHelper.create("party.organisationTill", Entity.class);
        till.setName("TillRulesTestCase-Till" + till.hashCode());
        TestHelper.save((org.openvpms.component.model.object.IMObject)till);
        return till;
    }

    public static Entity createTill(Party location) {
        Entity till = TestHelper.createTill();
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)location);
        bean.addTarget("tills", (org.openvpms.component.model.object.IMObject)till, "locations");
        bean.save(new org.openvpms.component.model.object.IMObject[]{till});
        return till;
    }

    public static Lookup getLookup(String shortName, String code) {
        return TestHelper.getLookup(shortName, code, true);
    }

    public static Lookup getLookup(String shortName, String code, boolean save) {
        ArchetypeQuery query = new ArchetypeQuery(shortName, false, false);
        query.add((IConstraint)new NodeConstraint("code", (Object)code));
        query.setMaxResults(1);
        IMObjectQueryIterator iter = new IMObjectQueryIterator((IArchetypeQuery)query);
        if (iter.hasNext()) {
            return (Lookup)iter.next();
        }
        Lookup lookup = TestHelper.create(shortName, Lookup.class);
        lookup.setCode(code);
        if (save) {
            TestHelper.save((org.openvpms.component.model.object.IMObject)lookup);
        }
        return lookup;
    }

    public static Lookup getLookup(String shortName, String code, String name, boolean save) {
        Lookup lookup;
        ArchetypeQuery query = new ArchetypeQuery(shortName, false, false);
        query.add((IConstraint)new NodeConstraint("code", (Object)code));
        query.setMaxResults(1);
        IMObjectQueryIterator iter = new IMObjectQueryIterator((IArchetypeQuery)query);
        if (iter.hasNext()) {
            lookup = (Lookup)iter.next();
            if (!StringUtils.equals((CharSequence)name, (CharSequence)lookup.getName()) || !lookup.isActive()) {
                lookup.setName(name);
                lookup.setActive(true);
            } else {
                save = false;
            }
        } else {
            lookup = TestHelper.create(shortName, Lookup.class);
            lookup.setCode(code);
            lookup.setName(name);
        }
        if (save) {
            TestHelper.save((org.openvpms.component.model.object.IMObject)lookup);
        }
        return lookup;
    }

    public static Lookup getLookup(String shortName, String code, Lookup source, String relationshipShortName) {
        return TestHelper.getLookup(shortName, code, code, source, relationshipShortName);
    }

    public static Lookup getLookup(String shortName, String code, String name, Lookup source, String relationshipShortName) {
        Lookup target = TestHelper.getLookup(shortName, code, name, true);
        for (Relationship relationship : source.getLookupRelationships()) {
            if (!relationship.getTarget().equals((Object)target.getObjectReference())) continue;
            return target;
        }
        LookupRelationship relationship = TestHelper.create(relationshipShortName, LookupRelationship.class);
        relationship.setSource(source.getObjectReference());
        relationship.setTarget(target.getObjectReference());
        source.addLookupRelationship(relationship);
        target.addLookupRelationship(relationship);
        TestHelper.save(new org.openvpms.component.model.object.IMObject[]{source, target});
        return target;
    }

    public static String getLookupName(org.openvpms.component.model.object.IMObject object, String node) {
        IMObjectBean bean = new IMObjectBean(object);
        return LookupHelper.getName((ArchetypeService)ArchetypeServiceHelper.getArchetypeService(), (LookupService)LookupServiceHelper.getLookupService(), (NodeDescriptor)bean.getDescriptor(node), (org.openvpms.component.model.object.IMObject)object);
    }

    public static Lookup createTaxType(BigDecimal rate) {
        Lookup tax = TestHelper.create("lookup.taxType", Lookup.class);
        IMObjectBean bean = new IMObjectBean((org.openvpms.component.model.object.IMObject)tax);
        bean.setValue("code", (Object)("XTAXTYPE" + System.nanoTime()));
        bean.setValue("rate", (Object)rate);
        TestHelper.save((org.openvpms.component.model.object.IMObject)tax);
        return tax;
    }

    public static ActIdentity createActIdentity(String archetype, String id) {
        ActIdentity identity = TestHelper.create(archetype, ActIdentity.class);
        identity.setIdentity(id);
        return identity;
    }

    public static EntityIdentity createEntityIdentity(String archetype, String id) {
        EntityIdentity identity = TestHelper.create(archetype, EntityIdentity.class);
        identity.setIdentity(id);
        return identity;
    }

    public static Date getDatetime(String value) {
        return TestHelper.getDatetime(value, false);
    }

    public static Date getDatetime(String value, boolean useTimestamp) {
        if (value != null) {
            if (StringUtils.countMatches((CharSequence)value, (CharSequence)":") != 2) {
                value = value + ":00";
            }
            Timestamp timestamp = Timestamp.valueOf(value);
            return useTimestamp ? timestamp : new Date(timestamp.getTime());
        }
        return null;
    }

    public static Date getDate(String value) {
        return value != null ? TestHelper.getDatetime(value + " 0:0:0") : null;
    }

    public static Date parseDate(String value) {
        if (value != null) {
            return value.contains(":") ? TestHelper.getDatetime(value) : TestHelper.getDate(value);
        }
        return null;
    }

    public static void checkEquals(BigDecimal expected, BigDecimal actual) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
        } else if (actual == null || expected.compareTo(actual) != 0) {
            Assert.fail((String)("Expected " + expected + ", but got " + actual));
        }
    }

    public static String randomName(String prefix) {
        return prefix + Math.abs(random.nextInt());
    }

    @SafeVarargs
    public static <T, R> List<R> assertIncluded(Iterable<R> list, T ... included) {
        return TestHelper.assertIncluded(IterableUtils.toList(list), included);
    }

    @SafeVarargs
    public static <T, R> List<R> assertIncluded(List<R> list, T ... included) {
        ArrayList<R> result = new ArrayList<R>(list);
        List<T> expected = Arrays.asList(included);
        result.retainAll(expected);
        Assert.assertEquals((long)expected.size(), (long)result.size());
        return result;
    }

    @SafeVarargs
    public static <T, R> void assertExcluded(Iterable<T> list, R ... excluded) {
        TestHelper.assertExcluded(IterableUtils.toList(list), excluded);
    }

    @SafeVarargs
    public static <T, R> void assertExcluded(List<T> list, R ... excluded) {
        for (R exclude : excluded) {
            Assert.assertFalse((boolean)list.contains(exclude));
        }
    }

    public static void setId(org.openvpms.component.model.object.IMObject object, long id) {
        ((IMObject)object).setId(id);
    }
}

