/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AbstractScheduleServiceTest;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.ScheduleService;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.rules.workflow.TaskService;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.cache.BasicEhcacheManager;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertySet;

public class TaskServiceTestCase
extends AbstractScheduleServiceTest {
    private Party workList;

    @Before
    public void setUp() {
        this.workList = ScheduleTestHelper.createWorkList();
    }

    @Override
    @Test
    public void testAddEvent() {
        Date date1 = TestHelper.getDate("2008-01-01");
        Date date2 = TestHelper.getDate("2008-01-02");
        Date date3 = TestHelper.getDate("2008-01-03");
        ScheduleService service = this.initScheduleService(30);
        long hash1 = this.checkEvents((Entity)this.workList, date1, 0);
        long hash2 = this.checkEvents((Entity)this.workList, date2, 0);
        Assert.assertNotEquals((long)hash1, (long)hash2);
        Act task = this.createTask(date1);
        ScheduleEvents events1 = service.getScheduleEvents((Entity)this.workList, date1);
        Assert.assertEquals((long)1L, (long)events1.size());
        PropertySet set1 = (PropertySet)events1.getEvents().get(0);
        this.checkTask(task, set1);
        Assert.assertNotEquals((long)hash1, (long)events1.getModHash());
        ScheduleEvents events2 = service.getScheduleEvents((Entity)this.workList, date2);
        Assert.assertEquals((long)1L, (long)events2.size());
        PropertySet set2 = (PropertySet)events2.getEvents().get(0);
        this.checkTask(task, set2);
        Assert.assertNotEquals((long)hash2, (long)events2.getModHash());
        ScheduleEvents events3 = service.getScheduleEvents((Entity)this.workList, date3);
        Assert.assertEquals((long)1L, (long)events3.size());
        PropertySet set3 = (PropertySet)events3.getEvents().get(0);
        this.checkTask(task, set3);
    }

    @Override
    @Test
    public void testRemoveEvent() {
        Date date1 = TestHelper.getDate("2008-01-01");
        Date date2 = TestHelper.getDate("2008-01-02");
        Date date3 = TestHelper.getDate("2008-01-03");
        this.initScheduleService(30);
        long hash1 = this.checkEvents((Entity)this.workList, date1, 0);
        long hash2 = this.checkEvents((Entity)this.workList, date2, 0);
        Act task = this.createTask(date1);
        long hash3 = this.checkEvents((Entity)this.workList, date1, 1);
        Assert.assertNotEquals((long)hash1, (long)hash3);
        long hash4 = this.checkEvents((Entity)this.workList, date2, 1);
        Assert.assertNotEquals((long)hash2, (long)hash4);
        this.remove((IMObject)task);
        long hash5 = this.checkEvents((Entity)this.workList, date1, 0);
        Assert.assertNotEquals((long)hash3, (long)hash5);
        long hash6 = this.checkEvents((Entity)this.workList, date2, 0);
        Assert.assertNotEquals((long)hash4, (long)hash6);
        this.checkEvents((Entity)this.workList, date3, 0);
    }

    @Override
    @Test
    public void testChangeEventDate() {
        Date date1 = TestHelper.getDate("2008-01-01");
        Date date2 = TestHelper.getDate("2008-03-01");
        this.initScheduleService(30);
        long hash1 = this.checkEvents((Entity)this.workList, date1, 0);
        this.checkEvents((Entity)this.workList, date1, 0, hash1);
        long hash2 = this.checkEvents((Entity)this.workList, date2, 0);
        this.checkEvents((Entity)this.workList, date2, 0, hash2);
        Act task = this.createTask(date1);
        long hash3 = this.checkEvents((Entity)this.workList, date1, 1);
        long hash4 = this.checkEvents((Entity)this.workList, date2, 1);
        Assert.assertNotEquals((long)hash1, (long)hash3);
        Assert.assertNotEquals((long)hash2, (long)hash4);
        task.setActivityStartTime(date2);
        this.save((IMObject)task);
        long hash5 = this.checkEvents((Entity)this.workList, date1, 0);
        Assert.assertNotEquals((long)hash3, (long)hash5);
        long hash6 = this.checkEvents((Entity)this.workList, date2, 1);
        Assert.assertNotEquals((long)hash4, (long)hash6);
    }

    @Test
    public void testGetEvents() {
        int count = 10;
        ScheduleService service = this.initScheduleService(30);
        Party patient = TestHelper.createPatient();
        Act[] tasks = new Act[10];
        Date date = TestHelper.getDate("2007-01-01");
        for (int i = 0; i < 10; ++i) {
            Date startTime = DateRules.getDate((Date)date, (int)150, (DateUnits)DateUnits.MINUTES);
            Date endTime = DateRules.getDate((Date)startTime, (int)15, (DateUnits)DateUnits.MINUTES);
            Date consultStartTime = i % 2 == 0 ? new Date() : null;
            tasks[i] = this.createTask(startTime, endTime, this.workList, patient, consultStartTime);
        }
        List results = service.getEvents((Entity)this.workList, date);
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < results.size(); ++i) {
            this.checkTask(tasks[i], (PropertySet)results.get(i));
        }
    }

    @Test
    public void testConcurrentReadWrite() throws Exception {
        for (int i = 0; i < 100; ++i) {
            System.out.println("Concurrent read/write run: " + i + " ");
            TaskService service = this.createScheduleService(30);
            try {
                this.checkConcurrentReadWrite(service);
                System.out.println("OK");
                continue;
            }
            finally {
                service.destroy();
            }
        }
    }

    @Test
    public void testConcurrentReadWrite2() throws Exception {
        for (int i = 0; i < 100; ++i) {
            System.out.println("Concurrent read/write run: " + i + " ");
            TaskService service = this.createScheduleService(30);
            try {
                this.checkConcurrentReadWrite2(service);
                System.out.println("OK");
                continue;
            }
            finally {
                service.destroy();
            }
        }
    }

    @Test
    public void testRepeatedSequentialRead() {
        Date start = TestHelper.getDate("2008-01-01");
        HashSet<Long> tasks = new HashSet<Long>();
        for (int i = 0; i < 100; ++i) {
            Act task = this.createTask(start);
            tasks.add(task.getId());
        }
        ScheduleService service = this.initScheduleService(6);
        for (int j = 0; j < 10; ++j) {
            for (int k = 0; k < 10; ++k) {
                Date date = DateRules.getDate((Date)start, (int)k, (DateUnits)DateUnits.DAYS);
                Set<Long> ids = this.getIds(date, (Entity)this.workList, service);
                Assert.assertEquals(tasks, ids);
            }
        }
    }

    protected TaskService createScheduleService(int scheduleCacheSize) {
        return new TaskService(this.getArchetypeService(), (LookupService)this.applicationContext.getBean(LookupService.class), (EhcacheManager)new BasicEhcacheManager((long)scheduleCacheSize));
    }

    @Override
    protected Entity createSchedule() {
        return ScheduleTestHelper.createWorkList();
    }

    @Override
    protected Act createEvent(Entity schedule, Date date, Party patient) {
        return this.createTask(date, (Party)schedule, patient);
    }

    private void checkConcurrentReadWrite(TaskService taskService) throws Exception {
        Date startTime = TestHelper.getDate("2007-01-01");
        Date endTime = DateRules.getDate((Date)startTime, (int)15, (DateUnits)DateUnits.MINUTES);
        Party schedule = ScheduleTestHelper.createWorkList();
        Party patient = TestHelper.createPatient();
        Act task = this.createTask(startTime, schedule, patient);
        Callable<PropertySet> read = () -> {
            System.err.println("read");
            List events = taskService.getEvents((Entity)schedule, startTime);
            Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
            return events.isEmpty() ? null : (PropertySet)events.get(0);
        };
        Callable<PropertySet> write = () -> {
            System.err.println("write");
            task.setActivityEndTime(endTime);
            this.save((IMObject)task);
            return null;
        };
        this.runConcurrent(read, write);
        List events = taskService.getEvents((Entity)schedule, startTime);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)endTime, (Object)((PropertySet)events.get(0)).getDate("act.endTime"));
    }

    private void checkConcurrentReadWrite2(TaskService taskService) throws Exception {
        Date startTime = TestHelper.getDate("2007-01-01");
        Date endTime = DateRules.getDate((Date)startTime, (int)15, (DateUnits)DateUnits.MINUTES);
        Date date2 = TestHelper.getDate("2007-01-02");
        Party schedule = ScheduleTestHelper.createWorkList();
        Party patient = TestHelper.createPatient();
        Act task = this.createTask(startTime, schedule, patient);
        Callable<PropertySet> readDate1 = () -> {
            System.err.println("Read date1 thread=" + Thread.currentThread().getName());
            List events = taskService.getEvents((Entity)schedule, startTime);
            Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
            return events.isEmpty() ? null : (PropertySet)events.get(0);
        };
        Callable<PropertySet> readDate2 = () -> {
            System.err.println("Read date2 thread=" + Thread.currentThread().getName());
            List events = taskService.getEvents((Entity)schedule, date2);
            Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
            return events.isEmpty() ? null : (PropertySet)events.get(0);
        };
        Callable<PropertySet> write = () -> {
            System.err.println("Writer thread=" + Thread.currentThread().getName());
            task.setActivityEndTime(endTime);
            this.save((IMObject)task);
            return null;
        };
        this.runConcurrent(readDate1, readDate2, write);
        List events = taskService.getEvents((Entity)schedule, startTime);
        Assert.assertEquals((long)1L, (long)events.size());
        events = taskService.getEvents((Entity)schedule, date2);
        Assert.assertEquals((long)0L, (long)events.size());
    }

    private Act createTask(Date date) {
        return this.createTask(date, this.workList, TestHelper.createPatient());
    }

    private Act createTask(Date date, Party workList, Party patient) {
        Date startTime = DateRules.getDate((Date)date, (int)15, (DateUnits)DateUnits.MINUTES);
        return this.createTask(startTime, null, workList, patient, null);
    }

    private Act createTask(Date startTime, Date endTime, Party workList, Party patient, Date consultStartTime) {
        Party customer = TestHelper.createCustomer();
        User clinician = TestHelper.createClinician();
        Act task = ScheduleTestHelper.createTask(startTime, endTime, (Entity)workList, customer, patient, clinician);
        IMObjectBean bean = this.getBean((IMObject)task);
        bean.setValue("consultStartTime", (Object)consultStartTime);
        bean.setValue("notes", (Object)"some notes");
        this.save((IMObject)task);
        return task;
    }

    private void checkTask(Act task, PropertySet set) {
        IMObjectBean bean = this.getBean((IMObject)task);
        Assert.assertEquals((Object)task.getObjectReference(), (Object)set.get("act.objectReference"));
        Assert.assertEquals((Object)task.getActivityStartTime(), (Object)set.get("act.startTime"));
        Assert.assertEquals((Object)task.getActivityEndTime(), (Object)set.get("act.endTime"));
        Assert.assertEquals((Object)task.getStatus(), (Object)set.get("act.status"));
        Assert.assertEquals((Object)task.getReason(), (Object)set.get("act.reason"));
        Assert.assertEquals((Object)bean.getString("notes"), (Object)set.get("notes"));
        Assert.assertEquals((Object)bean.getTargetRef("customer"), (Object)set.get("customer.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("customer").getName(), (Object)set.get("customer.name"));
        Assert.assertEquals((Object)bean.getTargetRef("patient"), (Object)set.get("patient.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("patient").getName(), (Object)set.get("patient.name"));
        Assert.assertEquals((Object)bean.getTargetRef("clinician"), (Object)set.get("clinician.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("clinician").getName(), (Object)set.get("clinician.name"));
        Assert.assertEquals((Object)bean.getTargetRef("worklist"), (Object)set.get("schedule.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("worklist").getName(), (Object)set.get("schedule.name"));
        Assert.assertEquals((Object)bean.getTargetRef("taskType"), (Object)set.get("scheduleType.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("taskType").getName(), (Object)set.get("scheduleType.name"));
        Assert.assertEquals((Object)bean.getDate("consultStartTime"), (Object)set.get("consultStartTime"));
    }
}

