/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleArchetypes;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;

public class ScheduleTestHelper
extends TestHelper {
    public static void addScheduleView(Party location, Entity view, boolean defaultView) {
        IMObjectBean bean = new IMObjectBean((IMObject)location);
        EntityRelationship relationship = (EntityRelationship)bean.addTarget("scheduleViews", (IMObject)view);
        view.addEntityRelationship(relationship);
        IMObjectBean relBean = new IMObjectBean((IMObject)relationship);
        relBean.setValue("default", (Object)defaultView);
        ScheduleTestHelper.save(new IMObject[]{location, view});
    }

    public static void addWorkListView(Party location, Entity view, boolean defaultView) {
        IMObjectBean bean = new IMObjectBean((IMObject)location);
        EntityRelationship relationship = (EntityRelationship)bean.addTarget("workListViews", (IMObject)view);
        view.addEntityRelationship(relationship);
        IMObjectBean relBean = new IMObjectBean((IMObject)relationship);
        relBean.setValue("default", (Object)defaultView);
        ScheduleTestHelper.save(new IMObject[]{location, view});
    }

    public static Entity createScheduleView(Entity ... schedules) {
        Entity view = ScheduleTestHelper.create("entity.organisationScheduleView", Entity.class);
        view.setName("XScheduleView");
        ScheduleTestHelper.addSchedules(view, schedules);
        return view;
    }

    public static void addSchedules(Entity view, Entity ... schedules) {
        IMObjectBean bean = new IMObjectBean((IMObject)view);
        for (Entity schedule : schedules) {
            EntityRelationship relationship = (EntityRelationship)bean.addTarget("schedules", (IMObject)schedule);
            schedule.addEntityRelationship(relationship);
        }
        ArrayList<Entity> list = new ArrayList<Entity>();
        list.add(view);
        list.addAll(Arrays.asList(schedules));
        ScheduleTestHelper.save(list);
    }

    public static Entity createAppointmentType() {
        return ScheduleTestHelper.createAppointmentType("XAppointmentType", true);
    }

    public static Entity createAppointmentType(String name, boolean save) {
        Entity appointmentType = ScheduleTestHelper.create("entity.appointmentType", Entity.class);
        appointmentType.setName(name);
        if (save) {
            ScheduleTestHelper.save((IMObject)appointmentType);
        }
        return appointmentType;
    }

    public static Party createSchedule(Party location) {
        return ScheduleTestHelper.createSchedule(15, "MINUTES", 2, ScheduleTestHelper.createAppointmentType(), location);
    }

    public static Party createSchedule(int slotSize, String slotUnits, int noSlots, Entity appointmentType, Party location) {
        Party schedule = ScheduleTestHelper.create("party.organisationSchedule", Party.class);
        IMObjectBean bean = new IMObjectBean((IMObject)schedule);
        bean.setValue("name", (Object)"XSchedule");
        bean.setValue("slotSize", (Object)slotSize);
        bean.setValue("slotUnits", (Object)slotUnits);
        bean.setValue("startTime", (Object)Time.valueOf("09:00:00"));
        bean.setValue("endTime", (Object)Time.valueOf("18:00:00"));
        if (appointmentType != null) {
            ScheduleTestHelper.addAppointmentType((Entity)schedule, appointmentType, noSlots, true);
        }
        bean.setTarget("location", (IMObject)location);
        bean.save();
        return schedule;
    }

    public static Party createSchedule(Party location, Entity cageType) {
        Party schedule = ScheduleTestHelper.create("party.organisationSchedule", Party.class);
        IMObjectBean bean = new IMObjectBean((IMObject)schedule);
        bean.setValue("name", (Object)"XSchedule");
        bean.setTarget("location", (IMObject)location);
        bean.setTarget("cageType", (IMObject)cageType);
        bean.save();
        return schedule;
    }

    public static EntityRelationship addAppointmentType(Entity schedule, Entity appointmentType, int noSlots, boolean isDefault) {
        IMObjectBean bean = new IMObjectBean((IMObject)schedule);
        EntityRelationship relationship = (EntityRelationship)bean.addTarget("appointmentTypes", (IMObject)appointmentType);
        appointmentType.addEntityRelationship(relationship);
        IMObjectBean relBean = new IMObjectBean((IMObject)relationship);
        relBean.setValue("noSlots", (Object)noSlots);
        if (isDefault) {
            relBean.setValue("default", (Object)true);
        }
        return relationship;
    }

    public static void addWorkLists(Entity schedule, Entity ... worklists) {
        IMObjectBean bean = new IMObjectBean((IMObject)schedule);
        bean.setValue("useAllWorkLists", (Object)false);
        for (Entity worklist : worklists) {
            EntityRelationship relationship = (EntityRelationship)bean.addTarget("workLists", (IMObject)worklist);
            worklist.addEntityRelationship(relationship);
        }
        bean.save((IMObject[])worklists);
    }

    public static Act createAppointment(Date startTime, Date endTime, Entity schedule) {
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient();
        return ScheduleTestHelper.createAppointment(startTime, endTime, schedule, customer, patient);
    }

    public static Act createAppointment(Date startTime, Date endTime, Entity schedule, Party customer, Party patient) {
        Entity appointmentType = ScheduleTestHelper.createAppointmentType();
        appointmentType.setName("XAppointmentType");
        ScheduleTestHelper.save((IMObject)appointmentType);
        return ScheduleTestHelper.createAppointment(startTime, endTime, schedule, appointmentType, customer, patient, null);
    }

    public static Act createAppointment(Date startTime, Entity schedule, Party customer, Party patient, String status) {
        Date endTime = DateRules.getDate((Date)startTime, (int)15, (DateUnits)DateUnits.MINUTES);
        Act appointment = ScheduleTestHelper.createAppointment(startTime, endTime, schedule, customer, patient);
        appointment.setStatus(status);
        return appointment;
    }

    public static Act createAppointment(Date startTime, Date endTime, Entity schedule, Entity appointmentType, Party customer, Party patient, User clinician) {
        Act act = ScheduleTestHelper.create("act.customerAppointment", Act.class);
        Lookup reason = TestHelper.getLookup(ScheduleArchetypes.VISIT_REASON, "XREASON", "Reason X", true);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setValue("startTime", (Object)startTime);
        bean.setValue("endTime", (Object)endTime);
        bean.setValue("reason", (Object)reason.getCode());
        bean.setValue("status", (Object)"IN_PROGRESS");
        bean.setTarget("customer", (IMObject)customer);
        if (patient != null) {
            bean.setTarget("patient", (IMObject)patient);
        }
        bean.setTarget("schedule", (IMObject)schedule);
        bean.setTarget("appointmentType", (IMObject)appointmentType);
        if (clinician != null) {
            bean.setTarget("clinician", (IMObject)clinician);
        }
        return act;
    }

    public static Entity createWorkListView(Entity ... workLists) {
        Entity view = ScheduleTestHelper.create("entity.organisationWorkListView", Entity.class);
        view.setName("XWorkListView");
        IMObjectBean bean = new IMObjectBean((IMObject)view);
        for (Entity workList : workLists) {
            EntityRelationship relationship = (EntityRelationship)bean.addTarget("workLists", (IMObject)workList);
            workList.addEntityRelationship(relationship);
        }
        bean.save((IMObject[])workLists);
        return view;
    }

    public static Entity createTaskType() {
        return ScheduleTestHelper.createTaskType("XTaskType", true);
    }

    public static Entity createTaskType(String name, boolean save) {
        Entity taskType = ScheduleTestHelper.create("entity.taskType", Entity.class);
        taskType.setName(name);
        if (save) {
            ScheduleTestHelper.save((IMObject)taskType);
        }
        return taskType;
    }

    public static Party createWorkList() {
        return ScheduleTestHelper.createWorkList(2, null);
    }

    public static Party createWorkList(int noSlots, Entity taskType) {
        Party workList = ScheduleTestHelper.create("party.organisationWorkList", Party.class);
        workList.setName("XWorkList");
        if (taskType != null) {
            ScheduleTestHelper.addTaskType(workList, taskType, noSlots, true);
            ScheduleTestHelper.save(new IMObject[]{workList, taskType});
        } else {
            ScheduleTestHelper.save((IMObject)workList);
        }
        return workList;
    }

    public static EntityRelationship addTaskType(Party workList, Entity taskType, int noSlots, boolean isDefault) {
        IMObjectBean bean = new IMObjectBean((IMObject)workList);
        EntityRelationship relationship = (EntityRelationship)bean.addTarget("taskTypes", (IMObject)taskType);
        taskType.addEntityRelationship(relationship);
        IMObjectBean relBean = new IMObjectBean((IMObject)relationship);
        relBean.setValue("noSlots", (Object)noSlots);
        if (isDefault) {
            relBean.setValue("default", (Object)true);
        }
        return relationship;
    }

    public static Act createTask(Date startTime, Date endTime, Entity workList) {
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient();
        return ScheduleTestHelper.createTask(startTime, endTime, workList, customer, patient);
    }

    public static Act createTask(Date startTime, Date endTime, Entity workList, Party customer, Party patient) {
        return ScheduleTestHelper.createTask(startTime, endTime, workList, customer, patient, null);
    }

    public static Act createTask(Date startTime, Date endTime, Entity worklist, Party customer, Party patient, User clinician) {
        return ScheduleTestHelper.createTask(startTime, endTime, worklist, customer, patient, ScheduleTestHelper.createTaskType(), clinician);
    }

    public static Act createTask(Date startTime, Date endTime, Entity worklist, Party customer, Party patient, Entity taskType, User clinician) {
        Act act = ScheduleTestHelper.create("act.customerTask", Act.class);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setValue("startTime", (Object)startTime);
        bean.setValue("endTime", (Object)endTime);
        bean.setValue("status", (Object)"IN_PROGRESS");
        bean.setTarget("customer", (IMObject)customer);
        if (patient != null) {
            bean.setTarget("patient", (IMObject)patient);
        }
        bean.setTarget("worklist", (IMObject)worklist);
        bean.setTarget("taskType", (IMObject)taskType);
        if (clinician != null) {
            bean.setTarget("clinician", (IMObject)clinician);
        }
        return act;
    }

    public static Entity createCageType(String name) {
        Product product = TestHelper.createProduct("product.service", null);
        return ScheduleTestHelper.createCageType(name, product, null, null, null);
    }

    public static Entity createCageType(String name, Product firstPetProductDay, Product firstPetProductNight, Product secondPetProductDay, Product secondPetProductNight) {
        return ScheduleTestHelper.createCageType(name, firstPetProductDay, firstPetProductNight, secondPetProductDay, secondPetProductNight, null, null);
    }

    public static Entity createCageType(String name, Product firstPetProductDay, Product firstPetProductNight, Product secondPetProductDay, Product secondPetProductNight, Time lateCheckoutTime, Product lateCheckoutProduct) {
        Entity entity = ScheduleTestHelper.create("entity.cageType", Entity.class);
        entity.setName(name);
        IMObjectBean bean = new IMObjectBean((IMObject)entity);
        bean.setTarget("firstPetProductDay", (IMObject)firstPetProductDay);
        if (firstPetProductNight != null) {
            bean.setTarget("firstPetProductNight", (IMObject)firstPetProductNight);
        }
        if (secondPetProductDay != null) {
            bean.setTarget("secondPetProductDay", (IMObject)secondPetProductDay);
        }
        if (secondPetProductNight != null) {
            bean.setTarget("secondPetProductNight", (IMObject)secondPetProductNight);
        }
        if (lateCheckoutTime != null) {
            bean.setValue("lateCheckoutTime", (Object)lateCheckoutTime);
        }
        if (lateCheckoutProduct != null) {
            bean.setTarget("lateCheckoutProduct", (IMObject)lateCheckoutProduct);
        }
        ScheduleTestHelper.save((IMObject)entity);
        return entity;
    }

    public static Entity createCalendarBlockType() {
        return ScheduleTestHelper.createCalendarBlockType("XCalendarBlockType");
    }

    public static Entity createCalendarBlockType(String name) {
        Entity blockType = ScheduleTestHelper.create("entity.calendarBlockType", Entity.class);
        blockType.setName(name);
        ScheduleTestHelper.save((IMObject)blockType);
        return blockType;
    }

    public static Act createCalendarBlock(Date startTime, Date endTime, Entity schedule, Entity blockType) {
        Act act = ScheduleTestHelper.create("act.calendarBlock", Act.class);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setValue("startTime", (Object)startTime);
        bean.setValue("endTime", (Object)endTime);
        bean.setTarget("schedule", (IMObject)schedule);
        bean.setTarget("type", (IMObject)blockType);
        return act;
    }

    public static Act createCalendarEvent(Date startTime, Date endTime, Entity schedule, Party location) {
        Act act = ScheduleTestHelper.create("act.calendarEvent", Act.class);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setValue("startTime", (Object)startTime);
        bean.setValue("endTime", (Object)endTime);
        bean.setTarget("schedule", (IMObject)schedule);
        if (location != null) {
            bean.setTarget("location", (IMObject)location);
        }
        return act;
    }

    public static Entity createRosterArea(Party location, Entity ... schedules) {
        Entity area = ScheduleTestHelper.create("entity.rosterArea", Entity.class);
        IMObjectBean bean = new IMObjectBean((IMObject)area);
        bean.setValue("name", (Object)"XArea");
        bean.setTarget("location", (IMObject)location);
        for (Entity schedule : schedules) {
            bean.addTarget("schedules", (IMObject)schedule);
        }
        bean.save();
        return area;
    }

    public static Act createRosterEvent(Date startTime, Date endTime, User user, Entity area, Party location) {
        Act act = ScheduleTestHelper.create("act.rosterEvent", Act.class);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setValue("startTime", (Object)startTime);
        bean.setValue("endTime", (Object)endTime);
        bean.setTarget("user", (IMObject)user);
        bean.setTarget("schedule", (IMObject)area);
        bean.setTarget("location", (IMObject)location);
        return act;
    }
}

