/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.ScheduleService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.util.PropertySet;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbstractScheduleServiceTest
extends ArchetypeServiceTest {
    private ScheduleService service;

    @After
    public void tearDown() throws Exception {
        this.destroyService(this.service);
    }

    @Test
    public abstract void testAddEvent();

    @Test
    public abstract void testRemoveEvent();

    @Test
    public abstract void testChangeEventDate();

    @Test
    public void testChangeEventSchedule() {
        Date date = TestHelper.getDate("2008-01-01");
        Entity schedule1 = this.createSchedule();
        Entity schedule2 = this.createSchedule();
        Party patient = TestHelper.createPatient();
        this.initScheduleService(30);
        Assert.assertEquals((long)-1L, (long)this.service.getModHash(schedule1, date));
        long hash1 = this.checkEvents(schedule1, date, 0);
        Assert.assertNotEquals((long)-1L, (long)hash1);
        this.checkEvents(schedule1, date, 0, hash1);
        Assert.assertEquals((long)hash1, (long)this.service.getModHash(schedule1, date));
        Act act = this.createEvent(schedule1, date, patient);
        long hash2 = this.checkEvents(schedule1, date, 1);
        Assert.assertNotEquals((long)hash2, (long)hash1);
        Assert.assertEquals((long)hash2, (long)this.service.getModHash(schedule1, date));
        this.setSchedule(act, schedule2);
        this.save((IMObject)act);
        long hash3 = this.checkEvents(schedule1, date, 0);
        Assert.assertNotEquals((long)hash2, (long)hash3);
        Assert.assertEquals((long)hash3, (long)this.service.getModHash(schedule1, date));
        long hash4 = this.checkEvents(schedule2, date, 1);
        Assert.assertNotEquals((long)-1L, (long)hash4);
        Assert.assertEquals((long)hash4, (long)this.service.getModHash(schedule2, date));
    }

    @Test
    public void testChangePatient() {
        Date date = TestHelper.getDate("2013-11-01");
        Entity schedule = this.createSchedule();
        Party patient1 = TestHelper.createPatient();
        this.initScheduleService(30);
        long hash1 = this.checkEvents(schedule, date, 0);
        this.checkEvents(schedule, date, 0, hash1);
        Act event = this.createEvent(schedule, date, null);
        ScheduleEvents events1 = this.service.getScheduleEvents(schedule, date);
        Assert.assertEquals((long)1L, (long)events1.size());
        Assert.assertNull((Object)((PropertySet)events1.getEvents().get(0)).getReference("patient.objectReference"));
        Assert.assertNotEquals((long)hash1, (long)events1.getModHash());
        IMObjectBean bean = this.getBean((IMObject)event);
        bean.setTarget("patient", (IMObject)patient1);
        bean.save();
        ScheduleEvents events2 = this.service.getScheduleEvents(schedule, date);
        Assert.assertEquals((long)1L, (long)events2.size());
        Assert.assertEquals((Object)patient1.getObjectReference(), (Object)((PropertySet)events2.getEvents().get(0)).getReference("patient.objectReference"));
        Assert.assertNotEquals((long)events1.getModHash(), (long)events2.getModHash());
        bean.removeTarget("patient", (IMObject)patient1);
        bean.save();
        ScheduleEvents events3 = this.service.getScheduleEvents(schedule, date);
        Assert.assertEquals((long)1L, (long)events3.size());
        Assert.assertNull((Object)((PropertySet)events3.getEvents().get(0)).getReference("patient.objectReference"));
        Assert.assertNotEquals((long)events2.getModHash(), (long)events3.getModHash());
        Party patient2 = TestHelper.createPatient();
        bean.setTarget("patient", (IMObject)patient2);
        bean.save();
        ScheduleEvents events4 = this.service.getScheduleEvents(schedule, date);
        Assert.assertEquals((long)1L, (long)events4.size());
        Assert.assertEquals((Object)patient2.getObjectReference(), (Object)((PropertySet)events4.getEvents().get(0)).getReference("patient.objectReference"));
        Assert.assertNotEquals((long)events3.getModHash(), (long)events2.getModHash());
    }

    @Test
    public void testChangeCustomer() {
        Date date = TestHelper.getDate("2013-11-01");
        Entity schedule = this.createSchedule();
        Party patient = TestHelper.createPatient();
        this.initScheduleService(30);
        long hash1 = this.checkEvents(schedule, date, 0);
        this.checkEvents(schedule, date, 0, hash1);
        Act task = this.createEvent(schedule, date, patient);
        IMObjectBean bean = this.getBean((IMObject)task);
        Reference customer1 = bean.getTargetRef("customer");
        Assert.assertNotNull((Object)customer1);
        ScheduleEvents events1 = this.service.getScheduleEvents(schedule, date);
        Assert.assertEquals((long)1L, (long)events1.size());
        Assert.assertEquals((Object)customer1, (Object)((PropertySet)events1.getEvents().get(0)).getReference("customer.objectReference"));
        Assert.assertNotEquals((long)hash1, (long)events1.getModHash());
        Party customer2 = TestHelper.createCustomer();
        bean.setTarget("customer", (IMObject)customer2);
        bean.save();
        ScheduleEvents events2 = this.service.getScheduleEvents(schedule, date);
        Assert.assertEquals((long)1L, (long)events2.size());
        Assert.assertEquals((Object)customer2.getObjectReference(), (Object)((PropertySet)events2.getEvents().get(0)).getReference("customer.objectReference"));
        Assert.assertNotEquals((long)events1.getModHash(), (long)events2.getModHash());
    }

    @Test
    public void testChangeClinician() {
        Date date = TestHelper.getDate("2013-11-01");
        Entity schedule = this.createSchedule();
        Party patient = TestHelper.createPatient();
        this.initScheduleService(30);
        long hash1 = this.checkEvents(schedule, date, 0);
        this.checkEvents(schedule, date, 0, hash1);
        Act task = this.createEvent(schedule, date, patient);
        IMObjectBean bean = this.getBean((IMObject)task);
        Reference clinician = bean.getTargetRef("clinician");
        Assert.assertNotNull((Object)clinician);
        ScheduleEvents events1 = this.service.getScheduleEvents(schedule, date);
        Assert.assertEquals((long)1L, (long)events1.size());
        Assert.assertEquals((Object)clinician, (Object)((PropertySet)events1.getEvents().get(0)).getReference("clinician.objectReference"));
        User clinician2 = TestHelper.createClinician();
        bean.setTarget("clinician", (IMObject)clinician2);
        bean.save();
        ScheduleEvents events2 = this.service.getScheduleEvents(schedule, date);
        Assert.assertEquals((long)1L, (long)events2.size());
        Assert.assertEquals((Object)clinician2.getObjectReference(), (Object)((PropertySet)events2.getEvents().get(0)).getReference("clinician.objectReference"));
        Assert.assertNotEquals((long)events1.getModHash(), (long)events2.getModHash());
    }

    @Test
    public void testConcurrentChangeSchedule() throws Exception {
        for (int i = 0; i < 100; ++i) {
            System.out.println("Concurrent read/write run: " + i + " ");
            ScheduleService service = this.createScheduleService(30);
            try {
                this.checkConcurrentChangeSchedule(service);
                System.out.println("OK");
                continue;
            }
            finally {
                this.destroyService(service);
            }
        }
    }

    @Test
    public void testConcurrentChangePatient() throws Exception {
        for (int i = 0; i < 100; ++i) {
            System.out.println("Concurrent read/write run: " + i + " ");
            ScheduleService service = this.createScheduleService(30);
            try {
                this.checkConcurrentChangePatient(service);
                System.out.println("OK");
                continue;
            }
            finally {
                this.destroyService(service);
            }
        }
    }

    protected abstract ScheduleService createScheduleService(int var1);

    protected abstract Entity createSchedule();

    protected abstract Act createEvent(Entity var1, Date var2, Party var3);

    protected void setSchedule(Act act, Entity schedule) {
        IMObjectBean bean = this.getBean((IMObject)act);
        if (bean.isA(new String[]{"act.customerAppointment"})) {
            bean.setTarget("schedule", (IMObject)schedule);
        } else {
            bean.setTarget("worklist", (IMObject)schedule);
        }
    }

    protected Set<Long> getIds(Date date, Entity schedule, ScheduleService service) {
        HashSet<Long> result = new HashSet<Long>();
        List events = service.getEvents(schedule, date);
        for (PropertySet event : events) {
            result.add(event.getReference("act.objectReference").getId());
        }
        return result;
    }

    protected void destroyService(ScheduleService service) throws Exception {
        if (service instanceof DisposableBean) {
            ((DisposableBean)service).destroy();
        }
    }

    protected void checkEvents(Entity schedule, Date date, int size, long modHash) {
        long actualETag = this.checkEvents(schedule, date, size);
        Assert.assertEquals((long)modHash, (long)actualETag);
    }

    protected long checkEvents(Entity schedule, Date date, int size) {
        ScheduleEvents events = this.service.getScheduleEvents(schedule, date);
        Assert.assertEquals((long)size, (long)events.size());
        return events.getModHash();
    }

    @SafeVarargs
    final <T> void runConcurrent(Callable<T> ... tasks) throws Exception {
        this.runConcurrent(Arrays.asList(tasks));
    }

    void runConcurrent(Runnable ... tasks) throws Exception {
        ArrayList list = new ArrayList();
        for (Runnable task : tasks) {
            list.add(() -> {
                task.run();
                return null;
            });
        }
        this.runConcurrent(list);
    }

    ScheduleService initScheduleService(int scheduleCacheSize) {
        this.service = this.createScheduleService(scheduleCacheSize);
        return this.service;
    }

    void setScheduleService(ScheduleService service) {
        this.service = service;
    }

    ScheduleService getScheduleService() {
        return this.service;
    }

    private <T> void runConcurrent(List<Callable<T>> tasks) throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(tasks.size());
        List<Future<T>> futures = executorService.invokeAll(tasks);
        Assert.assertEquals((long)tasks.size(), (long)futures.size());
        for (Future<T> future : futures) {
            future.get();
        }
    }

    private void checkConcurrentChangeSchedule(ScheduleService service) throws Exception {
        Entity schedule1 = this.createSchedule();
        Entity schedule2 = this.createSchedule();
        Party patient = TestHelper.createPatient();
        Date date = TestHelper.getDate("2007-01-01");
        Act event = this.createEvent(schedule1, date, patient);
        Callable<PropertySet> readSchedule1 = () -> {
            System.err.println("Read date1 thread=" + Thread.currentThread().getName());
            List events = service.getEvents(schedule1, date);
            Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
            return events.isEmpty() ? null : (PropertySet)events.get(0);
        };
        Callable<PropertySet> readSchedule2 = () -> {
            System.err.println("Read date2 thread=" + Thread.currentThread().getName());
            List events = service.getEvents(schedule2, date);
            Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
            return events.isEmpty() ? null : (PropertySet)events.get(0);
        };
        Callable<PropertySet> write = () -> {
            System.err.println("Writer thread=" + Thread.currentThread().getName());
            this.setSchedule(event, schedule2);
            this.save((IMObject)event);
            return null;
        };
        this.runConcurrent(readSchedule1, readSchedule2, write);
        List events = service.getEvents(schedule1, date);
        Assert.assertEquals((long)0L, (long)events.size());
        events = service.getEvents(schedule2, date);
        Assert.assertEquals((long)1L, (long)events.size());
    }

    private void checkConcurrentChangePatient(ScheduleService service) throws Exception {
        Entity schedule = this.createSchedule();
        Date date = TestHelper.getDate("2007-01-01");
        Party patient = TestHelper.createPatient();
        Act event = this.createEvent(schedule, date, patient);
        Party patient2 = TestHelper.createPatient();
        Callable<PropertySet> read1 = () -> {
            System.err.println("Read 1 thread=" + Thread.currentThread().getName());
            List events = service.getEvents(schedule, date);
            Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
            return events.isEmpty() ? null : (PropertySet)events.get(0);
        };
        Callable<PropertySet> read2 = () -> {
            System.err.println("Read 2 thread=" + Thread.currentThread().getName());
            List events = service.getEvents(schedule, date);
            Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
            return events.isEmpty() ? null : (PropertySet)events.get(0);
        };
        Callable<PropertySet> write = () -> {
            System.err.println("Writer thread=" + Thread.currentThread().getName());
            IMObjectBean bean = this.getBean((IMObject)event);
            bean.setTarget("patient", (IMObject)patient2);
            this.save((IMObject)event);
            return null;
        };
        List events = service.getEvents(schedule, date);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertNotEquals((Object)patient2.getObjectReference(), (Object)((PropertySet)events.get(0)).getReference("patient.objectReference"));
        this.runConcurrent(read1, read2, write);
        events = service.getEvents(schedule, date);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)patient2.getObjectReference(), (Object)((PropertySet)events.get(0)).getReference("patient.objectReference"));
    }
}

