/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.util;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.EntityRelationshipHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class EntityRelationshipHelperTestCase
extends ArchetypeServiceTest {
    @Test
    public void testGetDefaultTarget() {
        IArchetypeService service = this.getArchetypeService();
        Party practice = this.create("party.organisationPractice", Party.class);
        Party location1 = TestHelper.createLocation();
        Party location2 = TestHelper.createLocation();
        IMObjectBean bean = this.getBean((IMObject)practice);
        EntityRelationship rel1 = (EntityRelationship)bean.addTarget("locations", (IMObject)location1, "practice");
        EntityRelationship rel2 = (EntityRelationship)bean.addTarget("locations", (IMObject)location2, "practice");
        Entity entity1 = EntityRelationshipHelper.getDefaultTarget((Entity)practice, (String)"locations", (ArchetypeService)service);
        Assert.assertNotNull((Object)entity1);
        Assert.assertTrue((entity1.equals(location1) || entity1.equals(location2) ? 1 : 0) != 0);
        EntityRelationshipHelper.setDefault((Entity)practice, (String)"locations", (Relationship)rel1, (ArchetypeService)service);
        Assert.assertEquals((Object)location1, (Object)EntityRelationshipHelper.getDefaultTarget((Entity)practice, (String)"locations", (ArchetypeService)service));
        EntityRelationshipHelper.setDefault((Entity)practice, (String)"locations", (Relationship)rel2, (ArchetypeService)service);
        Assert.assertEquals((Object)location2, (Object)EntityRelationshipHelper.getDefaultTarget((Entity)practice, (String)"locations", (ArchetypeService)service));
        location2.setActive(false);
        location2.removeEntityRelationship(rel2);
        this.save((IMObject)location2);
        Assert.assertEquals((Object)location1, (Object)EntityRelationshipHelper.getDefaultTarget((Entity)practice, (String)"locations", (ArchetypeService)service));
    }
}

