/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.supplier.account.SupplierAccountRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class SupplierAccountRulesTestCase
extends ArchetypeServiceTest {
    private Party supplier;
    private SupplierAccountRules rules;

    @Before
    public void setUp() {
        this.supplier = TestHelper.createSupplier();
        this.rules = new SupplierAccountRules(this.getArchetypeService());
    }

    @Test
    public void testGetBalance() {
        BigDecimal hundred = new BigDecimal(100);
        BigDecimal sixty = new BigDecimal(60);
        BigDecimal forty = new BigDecimal(40);
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.supplier));
        List<FinancialAct> invoice = this.createChargesInvoice(hundred);
        invoice.get(0).setStatus("IN_PROGRESS");
        this.save(invoice);
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.supplier));
        invoice.get(0).setStatus("POSTED");
        this.save(invoice);
        this.checkEquals(hundred, this.rules.getBalance(this.supplier));
        List<FinancialAct> payment1 = this.createPaymentCash(sixty);
        this.save(payment1);
        this.checkEquals(forty, this.rules.getBalance(this.supplier));
        List<FinancialAct> payment2 = this.createPaymentCredit(forty);
        this.save(payment2);
        this.checkEquals(BigDecimal.ZERO, this.rules.getBalance(this.supplier));
    }

    @Test
    public void testGetBalanceForChargesInvoiceAndPayment() {
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        List<FinancialAct> payment = this.createPaymentCash(amount);
        this.checkCalculateBalanceForSameAmount(invoice, payment);
    }

    @Test
    public void testGetBalanceForChargesInvoiceAndCredit() {
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        List<FinancialAct> credit = this.createChargesCredit(amount);
        this.checkCalculateBalanceForSameAmount(invoice, credit);
    }

    @Test
    public void testGetBalanceForRefundAndPayment() {
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> refund = this.createRefundCash(amount);
        List<FinancialAct> payment = this.createPaymentCash(amount);
        this.checkCalculateBalanceForSameAmount(refund, payment);
    }

    @Test
    public void testReverse() {
        this.checkReverse(this.createChargesInvoice(new BigDecimal(100)), "act.supplierAccountChargesCredit", "act.supplierAccountCreditItem");
        this.checkReverse(this.createChargesCredit(new BigDecimal(50)), "act.supplierAccountChargesInvoice", "act.supplierAccountInvoiceItem");
        this.checkReverse(this.createPaymentCash(new BigDecimal(75)), "act.supplierAccountRefund", "act.supplierAccountRefundCash");
        this.checkReverse(this.createPaymentCheque(new BigDecimal(23)), "act.supplierAccountRefund", "act.supplierAccountRefundCheque");
        this.checkReverse(this.createPaymentCredit(new BigDecimal(24)), "act.supplierAccountRefund", "act.supplierAccountRefundCredit");
        this.checkReverse(this.createPaymentEFT(new BigDecimal(26)), "act.supplierAccountRefund", "act.supplierAccountRefundEFT");
        this.checkReverse(this.createRefundCash(new BigDecimal(10)), "act.supplierAccountPayment", "act.supplierAccountPaymentCash");
        this.checkReverse(this.createRefundCheque(new BigDecimal(11)), "act.supplierAccountPayment", "act.supplierAccountPaymentCheque");
        this.checkReverse(this.createRefundCredit(new BigDecimal(12)), "act.supplierAccountPayment", "act.supplierAccountPaymentCredit");
        this.checkReverse(this.createRefundEFT(new BigDecimal(15)), "act.supplierAccountPayment", "act.supplierAccountPaymentEFT");
    }

    private void checkCalculateBalanceForSameAmount(List<FinancialAct> debits, List<FinancialAct> credits) {
        FinancialAct debit = debits.get(0);
        FinancialAct credit = credits.get(0);
        BigDecimal amount = credit.getTotal();
        this.checkEquals(amount, debit.getTotal());
        Assert.assertTrue((boolean)credit.isCredit());
        Assert.assertFalse((boolean)debit.isCredit());
        this.save(debits);
        this.checkBalance(amount);
        this.save(credits);
        credit = this.get(credit);
        debit = this.get(debit);
        this.checkEquals(amount, credit.getTotal());
        this.checkEquals(amount, debit.getTotal());
        this.checkBalance(BigDecimal.ZERO);
    }

    private List<FinancialAct> createChargesInvoice(BigDecimal amount) {
        return this.createChargeActs("act.supplierAccountChargesInvoice", "act.supplierAccountInvoiceItem", amount, TestHelper.createProduct());
    }

    private List<FinancialAct> createChargesCredit(BigDecimal amount) {
        return this.createChargeActs("act.supplierAccountChargesCredit", "act.supplierAccountCreditItem", amount, TestHelper.createProduct());
    }

    private List<FinancialAct> createPaymentCash(BigDecimal amount) {
        return this.createPaymentRefund("act.supplierAccountPayment", "act.supplierAccountPaymentCash", amount);
    }

    private List<FinancialAct> createPaymentCheque(BigDecimal amount) {
        return this.createPaymentRefund("act.supplierAccountPayment", "act.supplierAccountPaymentCheque", amount);
    }

    private List<FinancialAct> createPaymentCredit(BigDecimal amount) {
        return this.createPaymentRefund("act.supplierAccountPayment", "act.supplierAccountPaymentCredit", amount);
    }

    private List<FinancialAct> createPaymentEFT(BigDecimal amount) {
        return this.createPaymentRefund("act.supplierAccountPayment", "act.supplierAccountPaymentEFT", amount);
    }

    private List<FinancialAct> createRefundCash(BigDecimal amount) {
        return this.createPaymentRefund("act.supplierAccountRefund", "act.supplierAccountRefundCash", amount);
    }

    private List<FinancialAct> createRefundCheque(BigDecimal amount) {
        return this.createPaymentRefund("act.supplierAccountRefund", "act.supplierAccountRefundCheque", amount);
    }

    private List<FinancialAct> createRefundCredit(BigDecimal amount) {
        return this.createPaymentRefund("act.supplierAccountRefund", "act.supplierAccountRefundCredit", amount);
    }

    private List<FinancialAct> createRefundEFT(BigDecimal amount) {
        return this.createPaymentRefund("act.supplierAccountRefund", "act.supplierAccountRefundEFT", amount);
    }

    private List<FinancialAct> createChargeActs(String shortName, String itemShortName, BigDecimal amount, Product product) {
        FinancialAct act = this.create(shortName, FinancialAct.class);
        FinancialAct item = this.create(itemShortName, FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        bean.setValue("amount", (Object)amount);
        bean.setValue("status", (Object)"POSTED");
        bean.setTarget("supplier", (IMObject)this.supplier);
        itemBean.setTarget("product", (IMObject)product);
        itemBean.setValue("unitPrice", (Object)amount);
        itemBean.setValue("quantity", (Object)1);
        Relationship relationship = bean.addTarget("items", (IMObject)item);
        item.addActRelationship((ActRelationship)relationship);
        return Arrays.asList(act, item);
    }

    private List<FinancialAct> createPaymentRefund(String shortName, String itemShortName, BigDecimal amount) {
        FinancialAct act = this.create(shortName, FinancialAct.class);
        FinancialAct item = this.create(itemShortName, FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        bean.setValue("amount", (Object)amount);
        bean.setValue("status", (Object)"POSTED");
        if (itemBean.isA(new String[]{"act.supplierAccountPaymentCash", "act.supplierAccountRefundCash"})) {
            itemBean.setValue("roundedAmount", (Object)amount);
            if (itemBean.isA(new String[]{"act.supplierAccountPaymentCash"})) {
                itemBean.setValue("tendered", (Object)amount);
            }
        } else if (itemBean.isA(new String[]{"act.supplierAccountPaymentCheque", "act.supplierAccountRefundCheque"})) {
            itemBean.setValue("bank", (Object)TestHelper.getLookup("lookup.bank", "CBA").getCode());
        } else if (itemBean.isA(new String[]{"act.supplierAccountPaymentCredit", "act.supplierAccountRefundCredit"})) {
            itemBean.setValue("creditCard", (Object)TestHelper.getLookup("lookup.creditcard", "VISA").getCode());
        }
        bean.setTarget("supplier", (IMObject)this.supplier);
        itemBean.setValue("amount", (Object)amount);
        Relationship relationship = bean.addTarget("items", (IMObject)item);
        item.addActRelationship((ActRelationship)relationship);
        return Arrays.asList(act, item);
    }

    private void checkReverse(List<FinancialAct> acts, String shortName, String itemShortName) {
        FinancialAct act = acts.get(0);
        act.setStatus("POSTED");
        this.save(acts);
        BigDecimal amount = act.getTotal();
        BigDecimal balance = act.isCredit() ? amount.negate() : amount;
        this.checkBalance(balance);
        Date now = new Date();
        FinancialAct reversal = this.rules.reverse(act, now);
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)reversal, (String)shortName));
        IMObjectBean bean = this.getBean((IMObject)reversal);
        if (itemShortName != null) {
            List items = bean.getTargets("items", Act.class);
            Assert.assertEquals((long)1L, (long)items.size());
            Act item = (Act)items.get(0);
            Assert.assertTrue((boolean)TypeHelper.isA((IMObject)item, (String)itemShortName));
            if (TypeHelper.isA((IMObject)item, (String[])new String[]{"act.supplierAccountPaymentCash", "act.supplierAccountRefundCash"})) {
                IMObjectBean itemBean = this.getBean((IMObject)item);
                BigDecimal roundedAmount = itemBean.getBigDecimal("roundedAmount");
                this.checkEquals(amount, roundedAmount);
            }
            this.checkEquals(amount, ((FinancialAct)item).getTotal());
        } else if (bean.hasNode("items")) {
            List items = bean.getTargets("items", Act.class);
            Assert.assertEquals((long)0L, (long)items.size());
        }
        this.checkBalance(BigDecimal.ZERO);
    }

    private void checkBalance(BigDecimal amount) {
        this.checkEquals(amount, this.rules.getBalance(this.supplier));
    }
}

