/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;

public class SupplerFinancialActItemTestCase
extends ArchetypeServiceTest {
    @Test
    public void testCalculateInvoiceItemTotal() {
        this.checkCalculate("act.supplierAccountInvoiceItem");
    }

    @Test
    public void testCalculateCreditItemTotal() {
        this.checkCalculate("act.supplierAccountCreditItem");
    }

    @Test
    public void testCalculateOrderItemTotal() {
        this.checkCalculate("act.supplierOrderItem");
    }

    @Test
    public void testCalculateDeliveryItemTotal() {
        this.checkCalculate("act.supplierDeliveryItem");
    }

    @Test
    public void testCalculateReturnItemTotal() {
        this.checkCalculate("act.supplierReturnItem");
    }

    private void checkCalculate(String itemShortName) {
        Act item = this.create(itemShortName, Act.class);
        IMObjectBean bean = this.getBean((IMObject)item);
        this.checkEquals(BigDecimal.ZERO, bean.getBigDecimal("total"));
        bean.setValue("quantity", (Object)10);
        bean.setValue("unitPrice", (Object)new BigDecimal("0.50"));
        bean.setValue("tax", (Object)new BigDecimal("0.50"));
        BigDecimal expected1 = new BigDecimal("5.50");
        this.checkEquals(expected1, bean.getBigDecimal("total"));
        bean.setValue("unitPrice", (Object)new BigDecimal("0.514"));
        BigDecimal expected2 = new BigDecimal("5.64");
        this.checkEquals(expected2, bean.getBigDecimal("total"));
        bean.setValue("quantity", null);
        bean.setValue("unitPrice", null);
        bean.setValue("tax", null);
        this.checkEquals(BigDecimal.ZERO, bean.getBigDecimal("total"));
    }
}

