/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.i18n.ArchetypeMessages;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.ProductPriceTestHelper;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.supplier.AbstractSupplierTest;
import org.openvpms.archetype.rules.supplier.DeliveryStatus;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestUnitPriceBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.springframework.beans.factory.annotation.Autowired;

public class DeliveryProcessorTestCase
extends AbstractSupplierTest {
    @Autowired
    private ProductRules rules;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.setIgnoreListPriceDecreases(false);
    }

    @Test
    public void testPostDelivery() {
        Party supplier = this.getSupplier();
        Product product = this.getProduct();
        BigDecimal quantity = new BigDecimal(5);
        FinancialAct delivery = this.createDelivery(supplier, product, quantity, 1, null);
        this.checkProductStockLocationRelationship(product, null);
        delivery.setStatus("POSTED");
        this.save((IMObject)delivery);
        this.checkProductStockLocationRelationship(product, quantity);
        this.save((IMObject)delivery);
        this.checkProductStockLocationRelationship(product, quantity);
        FinancialAct orderReturn = this.createReturn(supplier, product, quantity, 1, BigDecimal.ONE);
        this.checkProductStockLocationRelationship(product, quantity);
        orderReturn.setStatus("POSTED");
        this.save((IMObject)orderReturn);
        this.checkProductStockLocationRelationship(product, BigDecimal.ZERO);
    }

    @Test
    public void testPostDeliveryUpdatesOrder() {
        Party supplier = this.getSupplier();
        Product product = this.getProduct();
        BigDecimal quantity = new BigDecimal(5);
        BigDecimal delivery1Quantity = new BigDecimal(3);
        BigDecimal delivery2Quantity = new BigDecimal(7);
        FinancialAct orderItem = this.createOrderItem(product, quantity, 1, BigDecimal.ONE);
        FinancialAct order = this.createOrder(supplier, orderItem);
        order.setStatus("POSTED");
        this.save((IMObject)order);
        this.checkOrder((Act)order, orderItem, DeliveryStatus.PENDING, BigDecimal.ZERO);
        FinancialAct delivery1 = this.createDelivery(supplier, product, delivery1Quantity, 1, BigDecimal.ONE, orderItem);
        this.checkProductStockLocationRelationship(product, null);
        this.checkOrder((Act)order, orderItem, DeliveryStatus.PENDING, BigDecimal.ZERO);
        delivery1.setStatus("POSTED");
        this.save((IMObject)delivery1);
        this.checkOrder((Act)order, orderItem, DeliveryStatus.PART, delivery1Quantity);
        this.checkProductStockLocationRelationship(product, delivery1Quantity);
        this.save((IMObject)delivery1);
        this.checkOrder((Act)order, orderItem, DeliveryStatus.PART, delivery1Quantity);
        this.checkProductStockLocationRelationship(product, delivery1Quantity);
        orderItem = this.get(orderItem);
        FinancialAct return1 = this.createReturn(supplier, product, delivery1Quantity, 1, BigDecimal.ONE, orderItem);
        return1.setStatus("POSTED");
        this.save((IMObject)return1);
        this.checkOrder((Act)order, orderItem, DeliveryStatus.PENDING, BigDecimal.ZERO);
        this.checkProductStockLocationRelationship(product, BigDecimal.ZERO);
        orderItem = this.get(orderItem);
        FinancialAct delivery2 = this.createDelivery(supplier, product, delivery2Quantity, 1, BigDecimal.ONE, orderItem);
        delivery2.setStatus("POSTED");
        this.save((IMObject)delivery2);
        this.checkOrder((Act)order, orderItem, DeliveryStatus.FULL, delivery2Quantity);
        this.checkProductStockLocationRelationship(product, delivery2Quantity);
    }

    @Test
    public void testOrderWithMultipleDeliveries() {
        Party supplier = this.getSupplier();
        Product product = this.getProduct();
        BigDecimal quantity = new BigDecimal(5);
        BigDecimal unitPrice = BigDecimal.ONE;
        FinancialAct orderItem1 = this.createOrderItem(product, BigDecimal.TEN, 1, unitPrice);
        FinancialAct orderItem2 = this.createOrderItem(product, BigDecimal.TEN, 1, unitPrice);
        FinancialAct order = this.createOrder(supplier, orderItem1, orderItem2);
        order.setStatus("POSTED");
        this.save((IMObject)order);
        this.checkDeliveryStatus((Act)order, DeliveryStatus.PENDING);
        FinancialAct delivery1Item = this.createDeliveryItem(product, quantity, 1, unitPrice, orderItem1);
        FinancialAct delivery1 = this.createDelivery(supplier, delivery1Item);
        this.checkProductStockLocationRelationship(product, null);
        this.checkDeliveryStatus((Act)order, DeliveryStatus.PENDING);
        this.checkReceivedQuantity(orderItem1, BigDecimal.ZERO);
        this.checkReceivedQuantity(orderItem2, BigDecimal.ZERO);
        delivery1.setStatus("POSTED");
        this.save((IMObject)delivery1);
        this.checkDeliveryStatus((Act)order, DeliveryStatus.PART);
        this.checkReceivedQuantity(orderItem1, quantity);
        this.checkReceivedQuantity(orderItem2, BigDecimal.ZERO);
        this.checkProductStockLocationRelationship(product, quantity);
        orderItem1 = this.get(orderItem1);
        FinancialAct delivery2Item = this.createDeliveryItem(product, quantity, 1, unitPrice, orderItem1);
        FinancialAct delivery2 = this.createDelivery(supplier, delivery2Item);
        delivery2.setStatus("POSTED");
        this.save((IMObject)delivery2);
        this.checkDeliveryStatus((Act)order, DeliveryStatus.PART);
        FinancialAct delivery3Item = this.createDeliveryItem(product, BigDecimal.TEN, 1, unitPrice, orderItem2);
        FinancialAct delivery3 = this.createDelivery(supplier, delivery3Item);
        delivery3.setStatus("POSTED");
        this.save((IMObject)delivery3);
        this.checkDeliveryStatus((Act)order, DeliveryStatus.FULL);
    }

    @Test
    public void testQuantityConversion() {
        Party supplier = this.getSupplier();
        Product product = this.getProduct();
        BigDecimal quantity = BigDecimal.ONE;
        int packageSize = 20;
        BigDecimal unitPrice = BigDecimal.ONE;
        FinancialAct orderItem = this.createOrderItem(product, quantity, packageSize, unitPrice);
        FinancialAct order = this.createOrder(supplier, orderItem);
        order.setStatus("POSTED");
        this.save((IMObject)order);
        FinancialAct delivery1 = this.createDelivery(supplier, product, new BigDecimal(2), 5, unitPrice, orderItem);
        delivery1.setStatus("POSTED");
        this.save((IMObject)delivery1);
        this.checkOrder((Act)order, orderItem, DeliveryStatus.PART, new BigDecimal("0.5"));
        orderItem = this.get(orderItem);
        FinancialAct return1 = this.createReturn(supplier, product, new BigDecimal(1), 10, unitPrice, orderItem);
        return1.setStatus("POSTED");
        this.save((IMObject)return1);
        this.checkOrder((Act)order, orderItem, DeliveryStatus.PENDING, BigDecimal.ZERO);
        orderItem = this.get(orderItem);
        FinancialAct delivery2 = this.createDelivery(supplier, product, new BigDecimal(10), 2, unitPrice, orderItem);
        delivery2.setStatus("POSTED");
        this.save((IMObject)delivery2);
        this.checkOrder((Act)order, orderItem, DeliveryStatus.FULL, quantity);
    }

    @Test
    public void testProductSupplierUpdate() {
        BigDecimal quantity = BigDecimal.ONE;
        int packageSize = 20;
        BigDecimal unitPrice1 = new BigDecimal("10.00");
        BigDecimal unitPrice2 = new BigDecimal("12.50");
        Party supplier1 = this.getSupplier();
        Party supplier2 = TestHelper.createSupplier();
        Product product = this.getProduct();
        FinancialAct delivery1 = this.createDelivery(supplier1, product, quantity, packageSize, unitPrice1);
        this.checkProductSupplier(product, supplier1, -1, null, false);
        delivery1.setStatus("POSTED");
        this.save((IMObject)delivery1);
        this.checkProductSupplier(product, supplier1, packageSize, unitPrice1, true);
        FinancialAct delivery2 = this.createDelivery(supplier1, product, quantity, packageSize, unitPrice2);
        delivery2.setStatus("POSTED");
        this.save((IMObject)delivery2);
        this.checkProductSupplier(product, supplier1, packageSize, unitPrice2, true);
        FinancialAct return1 = this.createReturn(supplier1, product, quantity, packageSize, unitPrice1);
        return1.setStatus("POSTED");
        this.save((IMObject)return1);
        this.checkProductSupplier(product, supplier1, packageSize, unitPrice2, true);
        FinancialAct delivery3 = this.createDelivery(supplier2, product, quantity, packageSize, unitPrice1);
        delivery3.setStatus("POSTED");
        this.save((IMObject)delivery3);
        this.checkProductSupplier(product, supplier1, packageSize, unitPrice2, true);
        this.checkProductSupplier(product, supplier2, packageSize, unitPrice1, false);
    }

    @Test
    public void testUnitPriceUpdate() {
        Product product = this.getProduct();
        Party supplier = this.getSupplier();
        int cost1 = 1;
        int price1 = 2;
        int cost2 = 2;
        int price2 = 4;
        BigDecimal cost3 = new BigDecimal("0.80");
        BigDecimal price3 = new BigDecimal("1.60");
        int packageSize = 20;
        ((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.updateMedication(product).newUnitPrice().fromDate(TestHelper.getDate("2017-05-07"))).costAndPrice(cost1, price1)).add()).newProductSupplier().supplier(supplier).packageSize(packageSize).add()).build();
        ProductSupplier ps = this.getProductSupplier(product, supplier, packageSize);
        Assert.assertNotNull((Object)ps);
        Assert.assertFalse((boolean)ps.isAutoPriceUpdate());
        BigDecimal quantity = BigDecimal.ONE;
        BigDecimal unitPrice1 = new BigDecimal("20.00");
        BigDecimal listPrice1 = new BigDecimal("40.00");
        this.postDelivery(supplier, product, quantity, packageSize, unitPrice1, listPrice1);
        product = this.get(product);
        this.checkPrice(product, cost1, price1, true, true, null);
        ps = this.getProductSupplier(product, supplier, packageSize);
        Assert.assertNotNull((Object)ps);
        ps.setAutoPriceUpdate(true);
        ps.save();
        FinancialAct delivery2 = this.postDelivery(supplier, product, quantity, packageSize, unitPrice1, listPrice1);
        String notes2 = ArchetypeMessages.priceCreatedByDelivery((Act)delivery2, (Party)supplier).getMessage();
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, cost1, price1, true, false, null);
        this.checkPrice(product, cost2, price2, false, true, notes2);
        BigDecimal unitPrice2 = new BigDecimal("8.00");
        BigDecimal listPrice2 = new BigDecimal("15.00");
        this.postReturn(supplier, product, quantity, packageSize, unitPrice2, listPrice2);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, cost1, price1, true, false, null);
        this.checkPrice(product, cost2, price2, false, true, notes2);
        BigDecimal unitPrice3 = new BigDecimal("8.00");
        BigDecimal listPrice3 = new BigDecimal("16.00");
        FinancialAct delivery3 = this.postDelivery(supplier, product, quantity, packageSize, unitPrice3, listPrice3);
        String notes3 = ArchetypeMessages.priceCreatedByDelivery((Act)delivery3, (Party)supplier).getMessage();
        product = this.get(product);
        Assert.assertEquals((long)3L, (long)product.getProductPrices().size());
        this.checkPrice(product, cost1, price1, true, false, null);
        this.checkPrice(product, cost2, price2, false, false, notes2);
        this.checkPrice(product, cost3, price3, false, true, notes3);
        supplier = this.get(this.getSupplier());
        supplier.setActive(false);
        this.save((IMObject)supplier);
        BigDecimal unitPrice4 = new BigDecimal("10.00");
        BigDecimal listPrice4 = new BigDecimal("20.00");
        this.postDelivery(supplier, product, quantity, packageSize, unitPrice4, listPrice4);
        product = this.get(product);
        Assert.assertEquals((long)3L, (long)product.getProductPrices().size());
        this.checkPrice(product, cost1, price1, true, false, null);
        this.checkPrice(product, cost2, price2, false, false, notes2);
        this.checkPrice(product, cost3, price3, false, true, notes3);
    }

    @Test
    public void testUnitPriceUpdateWithPricingGroups() {
        Product product = this.getProduct();
        Party supplier = this.getSupplier();
        BigDecimal cost1 = BigDecimal.ONE;
        BigDecimal cost2 = BigDecimal.valueOf(2L);
        int packageSize = 20;
        ((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestMedicationProductBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.updateMedication(product).newUnitPrice().fromDate(TestHelper.getDate("2021-10-01"))).costAndMarkup(1, 50)).pricingGroups("GROUP1")).add()).newUnitPrice().fromDate(TestHelper.getDate("2021-10-01"))).costAndMarkup(2, 100)).pricingGroups("GROUP2")).add()).newProductSupplier().supplier(supplier).packageSize(packageSize).autoPriceUpdate(true).add()).build();
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, cost1, new BigDecimal("1.5"), true, true, "GROUP1", null);
        this.checkPrice(product, cost2, BigDecimal.valueOf(4L), true, true, "GROUP2", null);
        FinancialAct delivery = this.postDelivery(supplier, product, BigDecimal.ONE, packageSize, new BigDecimal("25"), new BigDecimal("50"));
        String notes = ArchetypeMessages.priceCreatedByDelivery((Act)delivery, (Party)supplier).getMessage();
        product = this.get(product);
        Assert.assertEquals((long)4L, (long)product.getProductPrices().size());
        this.checkPrice(product, cost1, new BigDecimal("1.5"), true, false, "GROUP1", null);
        this.checkPrice(product, cost2, BigDecimal.valueOf(4L), true, false, "GROUP2", null);
        this.checkPrice(product, new BigDecimal("2.5"), new BigDecimal("3.75"), false, true, "GROUP1", notes);
        this.checkPrice(product, new BigDecimal("2.5"), BigDecimal.valueOf(5L), false, true, "GROUP2", notes);
    }

    @Test
    public void testUnitPriceUpdateWith2ExistingUnitPrices() {
        Product product = this.getProduct();
        Party supplier = this.getSupplier();
        Date fromDate = DateRules.getYesterday();
        Date toDate = DateRules.getTomorrow();
        int cost1 = 1;
        int price1 = 2;
        int cost2 = 2;
        int price2 = 3;
        int packageSize = 20;
        ((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestMedicationProductBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.updateMedication(product).newUnitPrice().costAndPrice(cost1, price1)).dateRange(fromDate, toDate)).add()).newUnitPrice().costAndPrice(cost2, price2)).dateRange(toDate, null)).add()).newProductSupplier().packageSize(packageSize).autoPriceUpdate(true).supplier(supplier).add()).build();
        this.postDelivery(supplier, product, BigDecimal.ONE, packageSize, BigDecimal.valueOf(30L), BigDecimal.valueOf(60L));
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, cost1, price1, true, false, null);
        this.checkPrice(product, cost2, price2, false, true, null);
    }

    @Test
    public void testUnitPriceUpdateForExistingPriceWithFutureEndDate() {
        Product product = this.getProduct();
        Party supplier = this.getSupplier();
        int cost1 = 0;
        int price1 = 1;
        Date fromDate = DateRules.getYesterday();
        Date toDate = DateRules.getTomorrow();
        int packageSize = 20;
        ((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.updateMedication(product).newUnitPrice().dateRange(fromDate, toDate)).costAndPrice(cost1, price1)).add()).newProductSupplier().packageSize(packageSize).autoPriceUpdate(true).supplier(supplier).add()).build();
        BigDecimal unitPriceA = new BigDecimal("20.00");
        BigDecimal listPriceA = new BigDecimal("40.00");
        BigDecimal quantity = BigDecimal.ONE;
        int cost2 = 2;
        int price2 = 2;
        FinancialAct delivery1 = this.postDelivery(supplier, product, quantity, packageSize, unitPriceA, listPriceA);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, cost1, price1, true, false, null);
        String notes = ArchetypeMessages.priceCreatedByDelivery((Act)delivery1, (Party)supplier).getMessage();
        ProductPrice productPrice2 = this.checkPrice(product, cost2, price2, false, true, notes);
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)productPrice2.getFromDate(), (Date)toDate));
        Assert.assertNull((Object)productPrice2.getToDate());
        this.postDelivery(supplier, product, quantity, packageSize, unitPriceA, listPriceA);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, cost1, price1, true, false, null);
        ProductPrice productPrice3 = this.checkPrice(product, cost2, price2, false, true, notes);
        Assert.assertEquals((Object)productPrice2, (Object)productPrice3);
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)productPrice3.getFromDate(), (Date)toDate));
        Assert.assertNull((Object)productPrice3.getToDate());
        this.postDelivery(supplier, product, quantity, packageSize, new BigDecimal("25.0"), new BigDecimal("50.00"));
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, cost1, price1, true, false, null);
        ProductPrice productPrice4 = this.checkPrice(product, cost2, price2, false, true, notes);
        Assert.assertEquals((Object)productPrice2, (Object)productPrice4);
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)productPrice4.getFromDate(), (Date)toDate));
        Assert.assertNull((Object)productPrice4.getToDate());
    }

    @Test
    public void testIgnoreListPriceDecreases() {
        Product product = this.getProduct();
        Party supplier = this.getSupplier();
        int packageSize = 20;
        ((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.updateMedication(product).newUnitPrice().cost(0)).markup(100)).price(1)).add()).newProductSupplier().supplier(supplier).packageSize(packageSize).autoPriceUpdate(true).add()).build();
        BigDecimal unitPrice1 = new BigDecimal("10.00");
        BigDecimal quantity = BigDecimal.ONE;
        BigDecimal listPrice1 = new BigDecimal("20.00");
        FinancialAct delivery1 = this.postDelivery(supplier, product, quantity, packageSize, unitPrice1, listPrice1);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, BigDecimal.ZERO, BigDecimal.ONE, true, false, null);
        String notes1 = ArchetypeMessages.priceCreatedByDelivery((Act)delivery1, (Party)supplier).getMessage();
        this.checkPrice(product, BigDecimal.ONE, new BigDecimal("2.00"), false, true, notes1);
        this.setIgnoreListPriceDecreases(true);
        BigDecimal listPrice2 = new BigDecimal("15.00");
        this.postDelivery(supplier, product, quantity, packageSize, BigDecimal.TEN, listPrice2);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, BigDecimal.ZERO, BigDecimal.ONE, true, false, null);
        this.checkPrice(product, BigDecimal.ONE, new BigDecimal("2.00"), false, true, notes1);
        BigDecimal listPrice3 = new BigDecimal("30.00");
        FinancialAct delivery3 = this.postDelivery(supplier, product, quantity, packageSize, BigDecimal.TEN, listPrice3);
        this.save((IMObject)delivery3);
        product = this.get(product);
        String notes3 = ArchetypeMessages.priceCreatedByDelivery((Act)delivery3, (Party)supplier).getMessage();
        Assert.assertEquals((long)3L, (long)product.getProductPrices().size());
        this.checkPrice(product, BigDecimal.ZERO, BigDecimal.ONE, true, false, null);
        this.checkPrice(product, BigDecimal.ONE, new BigDecimal("2.00"), false, false, notes1);
        this.checkPrice(product, new BigDecimal("1.50"), new BigDecimal("3.00"), false, true, notes3);
        this.setIgnoreListPriceDecreases(false);
        BigDecimal listPrice4 = new BigDecimal("20.00");
        FinancialAct delivery4 = this.postDelivery(supplier, product, quantity, packageSize, BigDecimal.TEN, listPrice4);
        product = this.get(product);
        String notes4 = ArchetypeMessages.priceCreatedByDelivery((Act)delivery4, (Party)supplier).getMessage();
        Assert.assertEquals((long)4L, (long)product.getProductPrices().size());
        this.checkPrice(product, BigDecimal.ZERO, BigDecimal.ONE, true, false, null);
        this.checkPrice(product, BigDecimal.ONE, new BigDecimal("2.00"), false, false, notes1);
        this.checkPrice(product, new BigDecimal("1.50"), new BigDecimal("3.00"), false, false, notes3);
        this.checkPrice(product, BigDecimal.ONE, new BigDecimal("2.00"), false, true, notes4);
    }

    @Test
    public void testIgnoreListPriceDecreasesIgnoresLowerCostPrice() {
        Product product = this.getProduct();
        Party supplier = this.getSupplier();
        int packageSize = 20;
        ((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestUnitPriceBuilder)this.productFactory.updateMedication(product).newUnitPrice().costAndPrice(1, 2)).add()).newProductSupplier().supplier(supplier).packageSize(packageSize).autoPriceUpdate(true).add()).build();
        BigDecimal unitPrice1 = new BigDecimal("10.00");
        BigDecimal quantity = BigDecimal.ONE;
        BigDecimal listPrice1 = new BigDecimal("15.00");
        FinancialAct delivery1 = this.createDelivery(supplier, product, quantity, packageSize, unitPrice1, listPrice1);
        delivery1.setStatus("POSTED");
        this.save((IMObject)delivery1);
        String notes1 = ArchetypeMessages.priceCreatedByDelivery((Act)delivery1, (Party)supplier).getMessage();
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, BigDecimal.ONE, BigDecimal.valueOf(2L), true, false, null);
        this.checkPrice(product, new BigDecimal("0.75"), new BigDecimal("1.50"), false, true, notes1);
        this.setIgnoreListPriceDecreases(true);
        BigDecimal listPrice2 = new BigDecimal("20.00");
        FinancialAct delivery2 = this.createDelivery(supplier, product, quantity, 50, BigDecimal.TEN, listPrice2);
        delivery2.setStatus("POSTED");
        this.save((IMObject)delivery2);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, BigDecimal.ONE, BigDecimal.valueOf(2L), true, false, null);
        this.checkPrice(product, new BigDecimal("0.75"), new BigDecimal("1.50"), false, true, notes1);
        BigDecimal listPrice3 = new BigDecimal("30.00");
        FinancialAct delivery3 = this.createDelivery(supplier, product, quantity, packageSize, BigDecimal.TEN, listPrice3);
        delivery3.setStatus("POSTED");
        this.save((IMObject)delivery3);
        String notes3 = ArchetypeMessages.priceCreatedByDelivery((Act)delivery3, (Party)supplier).getMessage();
        product = this.get(product);
        Assert.assertEquals((long)3L, (long)product.getProductPrices().size());
        this.checkPrice(product, BigDecimal.ONE, BigDecimal.valueOf(2L), true, false, null);
        this.checkPrice(product, new BigDecimal("0.75"), new BigDecimal("1.50"), false, false, notes1);
        this.checkPrice(product, new BigDecimal("1.50"), new BigDecimal("3.00"), false, true, notes3);
    }

    @Test
    public void testBatchCreation() {
        Party supplier = this.getSupplier();
        Product product = this.getProduct();
        Party manufacturer = this.create("party.supplierManufacturer", Party.class);
        manufacturer.setName("Z Manufacturer");
        this.save((IMObject)manufacturer);
        FinancialAct item1 = this.createDeliveryItem(product, "batch1", null, null);
        Date expiry2 = TestHelper.getDate("2015-01-01");
        Date expiry3 = TestHelper.getDate("2015-06-01");
        Date expiry4 = TestHelper.getDate("2016-01-01");
        FinancialAct item2 = this.createDeliveryItem(product, null, expiry2, null);
        FinancialAct item3 = this.createDeliveryItem(product, "batch3", expiry3, manufacturer);
        FinancialAct item4 = this.createDeliveryItem(product, "batch4", expiry4, manufacturer);
        Entity batch4 = this.rules.createBatch(this.getProduct(), "batch4", expiry4, manufacturer);
        this.save((IMObject)batch4);
        FinancialAct delivery1 = this.createDelivery(supplier, item1, item2, item3, item4);
        delivery1.setStatus("POSTED");
        this.save((IMObject)delivery1);
        this.checkBatch("batch1", null, null);
        this.checkBatch(null, expiry2, null);
        this.checkBatch("batch3", expiry3, manufacturer);
        Entity actual = this.checkBatch("batch4", expiry4, manufacturer);
        Assert.assertEquals((Object)batch4, (Object)actual);
    }

    protected FinancialAct createDeliveryItem(Product product, String batchNumber, Date expiryDate, Party manufacturer) {
        FinancialAct item = this.createDeliveryItem(product, BigDecimal.ONE, 1, BigDecimal.TEN, null);
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.setValue("batchNumber", (Object)batchNumber);
        bean.setValue("expiryDate", (Object)expiryDate);
        if (manufacturer != null) {
            bean.setTarget("manufacturer", (IMObject)manufacturer);
        }
        return item;
    }

    private Entity checkBatch(String batchNumber, Date expiryDate, Party manufacturer) {
        List batches = this.rules.getBatches(this.getProduct(), batchNumber, expiryDate, manufacturer);
        Assert.assertEquals((long)1L, (long)batches.size());
        Entity batch = (Entity)batches.get(0);
        IMObjectBean bean = this.getBean((IMObject)batch);
        if (batchNumber != null) {
            Assert.assertEquals((Object)batchNumber, (Object)bean.getString("name"));
        } else {
            Assert.assertEquals((Object)this.getProduct().getName(), (Object)bean.getString("name"));
        }
        Assert.assertEquals((Object)manufacturer, (Object)bean.getTarget("manufacturer"));
        List product = bean.getValues("product", EntityLink.class);
        Assert.assertEquals((long)1L, (long)product.size());
        IMObjectBean productBean = this.getBean((IMObject)product.get(0));
        Assert.assertEquals((Object)expiryDate, (Object)productBean.getDate("activeEndTime"));
        Assert.assertTrue((boolean)bean.getTargetRefs("stockLocations").contains(this.getStockLocation().getObjectReference()));
        return batch;
    }

    private ProductPrice checkPrice(Product product, int cost, int price, boolean first, boolean last, String notes) {
        return this.checkPrice(product, BigDecimal.valueOf(cost), BigDecimal.valueOf(price), first, last, notes);
    }

    private ProductPrice checkPrice(Product product, BigDecimal cost, BigDecimal price, boolean first, boolean last, String notes) {
        return this.checkPrice(product, cost, price, first, last, null, notes);
    }

    private ProductPrice checkPrice(Product product, BigDecimal cost, BigDecimal price, boolean first, boolean last, String pricingGroup, String notes) {
        List<ProductPrice> prices = this.getUnitPrices(product, pricingGroup);
        int index = 0;
        int matchIndex = 0;
        ProductPrice match = null;
        for (ProductPrice p : prices) {
            IMObjectBean bean = this.getBean((IMObject)p);
            if (MathRules.equals((BigDecimal)bean.getBigDecimal("cost"), (BigDecimal)cost) && MathRules.equals((BigDecimal)price, (BigDecimal)p.getPrice())) {
                match = p;
                matchIndex = index;
                if (first && matchIndex == 0 || !first && !last && matchIndex < prices.size()) break;
            }
            ++index;
        }
        Assert.assertNotNull(match);
        if (first) {
            Assert.assertEquals((long)0L, (long)matchIndex);
        } else {
            Assert.assertNotEquals((long)0L, (long)matchIndex);
            Assert.assertEquals((Object)prices.get(matchIndex - 1).getToDate(), (Object)match.getFromDate());
        }
        if (last) {
            Assert.assertNull((Object)match.getToDate());
        } else {
            Assert.assertNotNull((Object)match.getToDate());
        }
        IMObjectBean bean = this.getBean((IMObject)match);
        Assert.assertEquals((Object)notes, (Object)bean.getString("notes"));
        return match;
    }

    private List<ProductPrice> getUnitPrices(Product product, String pricingGroup) {
        ArrayList<ProductPrice> result = new ArrayList<ProductPrice>();
        List<ProductPrice> prices = ProductPriceTestHelper.getPrices(product, "productPrice.unitPrice");
        for (ProductPrice price : prices) {
            if (!this.hasPricingGroup(price, pricingGroup)) continue;
            result.add(price);
        }
        return result;
    }

    private boolean hasPricingGroup(ProductPrice price, String pricingGroup) {
        boolean result = false;
        IMObjectBean bean = this.getBean((IMObject)price);
        List groups = bean.getValues("pricingGroups", Lookup.class);
        if (pricingGroup == null) {
            result = groups.isEmpty();
        } else {
            for (Lookup lookup : groups) {
                if (!pricingGroup.equals(lookup.getCode())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void checkOrder(Act order, FinancialAct orderItem, DeliveryStatus status, BigDecimal quantity) {
        this.checkDeliveryStatus(order, status);
        this.checkReceivedQuantity(orderItem, quantity);
    }

    private void checkReceivedQuantity(FinancialAct orderItem, BigDecimal receivedQuantity) {
        orderItem = this.get(orderItem);
        IMObjectBean itemBean = this.getBean((IMObject)orderItem);
        this.checkEquals(receivedQuantity, itemBean.getBigDecimal("receivedQuantity"));
    }

    private void checkDeliveryStatus(Act order, DeliveryStatus status) {
        order = this.get(order);
        Assert.assertEquals((Object)status.toString(), (Object)order.getStatus2());
    }

    private void checkProductSupplier(Product product, Party supplier, int packageSize, BigDecimal nettPrice, boolean preferred) {
        if (packageSize < 0) {
            Assert.assertNull((Object)this.getProductSupplier(product, supplier, packageSize));
        } else {
            ProductSupplier ps = this.getProductSupplier(product, supplier, packageSize);
            Assert.assertNotNull((Object)ps);
            this.checkEquals(nettPrice, ps.getNettPrice());
            Assert.assertEquals((Object)preferred, (Object)ps.isPreferred());
        }
    }

    private ProductSupplier getProductSupplier(Product product, Party supplier, int packageSize) {
        ProductRules rules = new ProductRules(this.getArchetypeService(), this.getLookupService());
        product = this.get(product);
        return rules.getProductSupplier(product, supplier, null, packageSize, "BOX");
    }

    private void setIgnoreListPriceDecreases(boolean ignore) {
        IMObjectBean bean = this.getBean((IMObject)this.getPractice());
        bean.setValue("ignoreListPriceDecreases", (Object)ignore);
        bean.save();
    }

    protected FinancialAct postDelivery(Party supplier, Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice, BigDecimal listPrice) {
        FinancialAct delivery = this.createDelivery(supplier, product, quantity, packageSize, unitPrice, listPrice);
        delivery.setStatus("POSTED");
        this.save((IMObject)delivery);
        return delivery;
    }

    private void postReturn(Party supplier, Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice, BigDecimal listPrice) {
        FinancialAct result = this.createReturn(supplier, product, quantity, packageSize, unitPrice, listPrice);
        result.setStatus("POSTED");
        this.save((IMObject)result);
    }
}

