/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.stock.AbstractStockTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ChargeStockUpdaterTestCase
extends AbstractStockTest {
    private Product product;
    private Party customer;
    private Party patient;
    private Party stockLocation;
    private PlatformTransactionManager txnManager;

    @Before
    public void setUp() {
        this.product = TestHelper.createProduct();
        this.customer = TestHelper.createCustomer();
        this.patient = TestHelper.createPatient();
        this.stockLocation = this.createStockLocation();
        this.txnManager = (PlatformTransactionManager)this.applicationContext.getBean(PlatformTransactionManager.class);
    }

    @Test
    public void testInvoiceStockUpdate() {
        this.checkStockUpdate(this.createInvoice());
    }

    @Test
    public void testInvoiceRemoval() {
        this.checkChargeRemoval(this.createInvoice());
    }

    @Test
    public void testInvoiceItemRemoval() {
        this.checkItemRemoval(this.createInvoice());
    }

    @Test
    public void testCounterChargeStockUpdate() {
        this.checkStockUpdate(this.createCounterCharge());
    }

    @Test
    public void testCounterChargeRemoval() {
        this.checkChargeRemoval(this.createCounterCharge());
    }

    @Test
    public void testCounterChargeItemRemoval() {
        this.checkItemRemoval(this.createCounterCharge());
    }

    @Test
    public void testCreditChargeStockUpdate() {
        this.checkStockUpdate(this.createCreditCharge());
    }

    @Test
    public void testCreditChargeRemoval() {
        this.checkChargeRemoval(this.createCreditCharge());
    }

    @Test
    public void testCreditChargeItemRemoval() {
        this.checkItemRemoval(this.createCreditCharge());
    }

    @Test
    public void testMultipleSaveInTxn() {
        final List<FinancialAct> acts = this.createInvoice();
        FinancialAct item = acts.get(1);
        BigDecimal initialQuantity = BigDecimal.ZERO;
        BigDecimal quantity = BigDecimal.valueOf(5L);
        item.setQuantity(quantity);
        this.checkEquals(initialQuantity, this.getStock(this.stockLocation, this.product));
        BigDecimal expected = this.getQuantity(initialQuantity, quantity, false);
        TransactionTemplate template = new TransactionTemplate(this.txnManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ChargeStockUpdaterTestCase.this.save(acts);
                ChargeStockUpdaterTestCase.this.save(acts);
            }
        });
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
        this.save(acts);
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
    }

    @Test
    public void testMultipleStockUpdatesInTxn() {
        final ArrayList<FinancialAct> acts = new ArrayList<FinancialAct>(this.createInvoice());
        final FinancialAct item1 = (FinancialAct)acts.get(1);
        final FinancialAct item2 = FinancialTestHelper.createChargeItem("act.customerAccountInvoiceItem", this.patient, this.product, BigDecimal.ONE);
        this.addStockLocation(item2);
        acts.add(item2);
        BigDecimal initialQuantity = BigDecimal.ZERO;
        BigDecimal quantity = BigDecimal.valueOf(5L);
        item1.setQuantity(quantity);
        item2.setQuantity(quantity);
        this.checkEquals(initialQuantity, this.getStock(this.stockLocation, this.product));
        BigDecimal expected = this.getQuantity(initialQuantity, quantity.add(quantity), false);
        TransactionTemplate template = new TransactionTemplate(this.txnManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ChargeStockUpdaterTestCase.this.save(acts);
            }
        });
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                item1.setQuantity(BigDecimal.ONE);
                ChargeStockUpdaterTestCase.this.save((IMObject)item1);
                ChargeStockUpdaterTestCase.this.remove((IMObject)item2);
            }
        });
        expected = this.getQuantity(initialQuantity, BigDecimal.ONE, false);
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
    }

    @Test
    public void testPartialSaveInTxn() {
        List<FinancialAct> acts = this.createInvoice();
        final FinancialAct invoice = acts.get(0);
        final FinancialAct item = acts.get(1);
        BigDecimal initialQuantity = BigDecimal.ZERO;
        BigDecimal quantity = BigDecimal.valueOf(5L);
        item.setQuantity(quantity);
        this.checkEquals(initialQuantity, this.getStock(this.stockLocation, this.product));
        BigDecimal expected = this.getQuantity(initialQuantity, quantity, false);
        TransactionTemplate template = new TransactionTemplate(this.txnManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ChargeStockUpdaterTestCase.this.save((IMObject)item);
                ChargeStockUpdaterTestCase.this.save((IMObject)item);
                ChargeStockUpdaterTestCase.this.save((IMObject)invoice);
            }
        });
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
        this.save(acts);
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
    }

    @Test
    public void testInitialSaveWithZeroQuantity() {
        List<FinancialAct> acts = FinancialTestHelper.createChargesInvoice(this.customer, this.patient, this.product, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, "IN_PROGRESS");
        FinancialAct invoice = acts.get(0);
        FinancialAct item = acts.get(1);
        this.addStockLocation(item);
        this.checkEquals(BigDecimal.ZERO, this.getStock(this.stockLocation, this.product));
        this.save((IMObject[])new FinancialAct[]{invoice, item});
        this.checkEquals(BigDecimal.ZERO, this.getStock(this.stockLocation, this.product));
        item.setQuantity(BigDecimal.TEN);
        this.save((IMObject)item);
        this.checkEquals(BigDecimal.TEN.negate(), this.getStock(this.stockLocation, this.product));
        item.setQuantity(BigDecimal.ZERO);
        this.save((IMObject)item);
        this.checkEquals(BigDecimal.ZERO, this.getStock(this.stockLocation, this.product));
        item.setQuantity(BigDecimal.ONE);
        this.save((IMObject)item);
        this.checkEquals(BigDecimal.ONE.negate(), this.getStock(this.stockLocation, this.product));
    }

    private void checkStockUpdate(List<FinancialAct> acts) {
        FinancialAct item = acts.get(1);
        BigDecimal initialQuantity = BigDecimal.ZERO;
        BigDecimal quantity = BigDecimal.valueOf(5L);
        Product product2 = TestHelper.createProduct();
        boolean credit = TypeHelper.isA((IMObject)item, (String)"act.customerAccountCreditItem");
        BigDecimal expected = this.getQuantity(initialQuantity, quantity, credit);
        item.setQuantity(quantity);
        this.checkEquals(initialQuantity, this.getStock(this.stockLocation, this.product));
        this.save(acts);
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
        this.save(acts);
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
        item = this.get(item);
        BigDecimal updatedQty = new BigDecimal(10);
        item.setQuantity(updatedQty);
        expected = this.getQuantity(initialQuantity, updatedQty, credit);
        this.save((IMObject)item);
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
        item = this.get(item);
        this.save((IMObject)item);
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
        IMObjectBean itemBean = this.getBean((IMObject)item);
        itemBean.setTarget("product", (IMObject)product2);
        this.save((IMObject)item);
        this.checkEquals(BigDecimal.ZERO, this.getStock(this.stockLocation, this.product));
        this.checkEquals(expected, this.getStock(this.stockLocation, product2));
    }

    private void checkChargeRemoval(List<FinancialAct> acts) {
        BigDecimal quantity = new BigDecimal(10);
        FinancialAct act = acts.get(0);
        FinancialAct item = acts.get(1);
        item.setQuantity(quantity);
        this.save(acts);
        BigDecimal expected = this.getQuantity(BigDecimal.ZERO, quantity, act.isCredit());
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
        this.remove((IMObject)act);
        this.checkEquals(BigDecimal.ZERO, this.getStock(this.stockLocation, this.product));
    }

    private void checkItemRemoval(List<FinancialAct> acts) {
        BigDecimal quantity = new BigDecimal(10);
        FinancialAct item = acts.get(1);
        item.setQuantity(quantity);
        this.save(acts);
        boolean credit = TypeHelper.isA((IMObject)item, (String)"act.customerAccountCreditItem");
        BigDecimal expected = this.getQuantity(BigDecimal.ZERO, quantity, credit);
        this.checkEquals(expected, this.getStock(this.stockLocation, this.product));
        this.remove((IMObject)item);
        this.checkEquals(BigDecimal.ZERO, this.getStock(this.stockLocation, this.product));
    }

    private List<FinancialAct> createInvoice() {
        List<FinancialAct> acts = FinancialTestHelper.createChargesInvoice((BigDecimal)new Money(100), this.customer, this.patient, this.product, "IN_PROGRESS");
        this.addStockLocation(acts.get(1));
        return acts;
    }

    private List<FinancialAct> createCreditCharge() {
        List<FinancialAct> acts = FinancialTestHelper.createChargesCredit((BigDecimal)new Money(100), this.customer, this.patient, this.product, "IN_PROGRESS");
        this.addStockLocation(acts.get(1));
        return acts;
    }

    private List<FinancialAct> createCounterCharge() {
        List<FinancialAct> acts = FinancialTestHelper.createChargesCounter((BigDecimal)new Money(100), this.customer, this.product, "IN_PROGRESS");
        this.addStockLocation(acts.get(1));
        return acts;
    }

    private void addStockLocation(FinancialAct item) {
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.setTarget("stockLocation", (IMObject)this.stockLocation);
    }

    private BigDecimal getQuantity(BigDecimal current, BigDecimal change, boolean credit) {
        return credit ? current.add(change) : current.subtract(change);
    }
}

