/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.AbstractProductIOTest;
import org.openvpms.archetype.rules.product.io.PriceData;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.rules.product.io.ProductIOException;
import org.openvpms.archetype.rules.product.io.ProductUpdater;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.product.TestFixedPriceBuilder;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestPriceTemplateProductBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ProductUpdaterTestCase
extends AbstractProductIOTest {
    private ProductUpdater updater;

    @Before
    public void setUp() {
        ProductPriceRules rules = new ProductPriceRules((ArchetypeService)this.getArchetypeService());
        this.updater = new ProductUpdater(rules, (ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testAddPriceForOpenPriorPrice() {
        ProductPrice fixed1 = this.createFixedPrice("1.0", "0.5", "100", "10", "2013-01-01", null, true);
        ProductPrice unit1 = this.createUnitPrice("1.92", "1.2", "60", "10", "2013-02-02", null);
        Product product = this.createProduct("P1", "Product 1", fixed1, unit1);
        ProductData data = this.createProduct(product, BigDecimal.ZERO, false);
        data.addPrice(this.createFixedPriceData(-1L, "1.08", "0.6", "20", "2013-04-01", null, true));
        data.addPrice(this.createUnitPriceData(-1L, "2.55", "1.5", "17.5", "2013-04-03", null));
        this.updater.update(product, data);
        Assert.assertEquals((long)4L, (long)product.getProductPrices().size());
        Assert.assertEquals((Object)TestHelper.getDate("2013-04-01"), (Object)fixed1.getToDate());
        this.checkPrice(product, this.createFixedPrice("1.0", "0.5", "100", "10", "2013-01-01", "2013-04-01", true));
        this.checkPrice(product, this.createFixedPrice("1.08", "0.6", "80", "20", "2013-04-01", null, true));
        this.checkPrice(product, this.createUnitPrice("1.92", "1.2", "60", "10", "2013-02-02", "2013-04-03"));
        this.checkPrice(product, this.createUnitPrice("2.55", "1.5", "70", "17.5", "2013-04-03", null));
    }

    @Test
    public void testUpdateUnitPrices() {
        ProductPrice unit1 = this.createUnitPrice("1.0", "0.5", "100", "10", "2013-01-01", "2013-03-31");
        Product product = this.createProduct("P1", "Product 1", unit1);
        ProductData data1 = this.createProduct(product, BigDecimal.ZERO, false);
        PriceData price = this.createUnitPriceData(unit1.getId(), "1.08", "0.6", "17.5", "2013-04-01", null);
        data1.addPrice(price);
        this.updater.update(product, data1);
        Assert.assertEquals((long)1L, (long)product.getProductPrices().size());
        this.checkPrice(product, this.createUnitPrice("1.08", "0.6", "80", "17.5", "2013-04-01", null));
    }

    @Test
    public void testAddHistoricalUnitPrice() {
        ProductPrice unit1 = this.createUnitPrice("1.08", "0.6", "60", "10", "2013-04-01", null);
        Product product = this.createProduct("P1", "Product 1", unit1);
        ProductData data1 = this.createProduct(product, BigDecimal.ZERO, false);
        data1.addPrice(this.createUnitPriceData(-1L, "1.0", "0.5", "20", "2013-01-01", "2013-03-31"));
        this.updater.update(product, data1);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, this.createUnitPrice("1.0", "0.5", "100", "20", "2013-01-01", "2013-03-31"));
        this.checkPrice(product, this.createUnitPrice("1.08", "0.6", "60", "10", "2013-04-01", null));
        this.save((IMObject)product);
        ProductData data2 = this.createProduct(product, BigDecimal.ZERO, false);
        data2.addPrice(this.createUnitPriceData(-1L, "1.92", "1.2", "10", "2013-01-02", null));
        try {
            this.updater.update(product, data2);
            Assert.fail((String)"Expected ProductIOException");
        }
        catch (ProductIOException expected) {
            Assert.assertEquals((Object)"Unit price dates overlap an existing unit price", (Object)expected.getMessage());
        }
        ProductData data3 = this.createProduct(product, BigDecimal.ZERO, false);
        data3.addPrice(this.createUnitPriceData(-1L, "1.92", "1.2", "10", "2012-12-31", "2013-01-02"));
        try {
            this.updater.update(product, data3);
            Assert.fail((String)"Expected ProductIOException");
        }
        catch (ProductIOException expected) {
            Assert.assertEquals((Object)"Unit price dates overlap an existing unit price", (Object)expected.getMessage());
        }
    }

    @Test
    public void testAddHistoricalFixedPrice() {
        ProductPrice fixed1 = this.createFixedPrice("1.08", "0.6", "60", "10", "2013-04-01", null, true);
        Product product = this.createProduct("P1", "Product 1", fixed1);
        ProductData data1 = this.createProduct(product, BigDecimal.ZERO, false);
        data1.addPrice(this.createFixedPriceData(-1L, "1.0", "0.5", "20", "2013-01-01", "2013-03-31", true));
        this.updater.update(product, data1);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, this.createFixedPrice("1.0", "0.5", "100", "20", "2013-01-01", "2013-03-31", true));
        this.checkPrice(product, this.createFixedPrice("1.08", "0.6", "60", "10", "2013-04-01", null, true));
        this.save((IMObject)product);
        ProductData data2 = this.createProduct(product, BigDecimal.ZERO, false);
        data2.addPrice(this.createFixedPriceData(-1L, "1.92", "1.2", "15", "2013-01-02", null, true));
        this.updater.update(product, data2);
        this.checkPrice(product, this.createFixedPrice("1.0", "0.5", "100", "20", "2013-01-01", "2013-03-31", true));
        this.checkPrice(product, this.createFixedPrice("1.08", "0.6", "60", "10", "2013-04-01", null, true));
        this.checkPrice(product, this.createFixedPrice("1.92", "1.2", "60", "15", "2013-01-02", null, true));
    }

    @Test
    public void testDuplicatePrice() {
        ProductPrice fixed1 = this.createFixedPrice("1.0", "0.5", "100", "10", "2013-01-01", null, true);
        ProductPrice unit1 = this.createUnitPrice("1.92", "1.2", "60", "10", "2013-02-02", null);
        Product product = this.createProduct("P1", "Product 1", fixed1, unit1);
        ProductData data = this.createProduct(product, BigDecimal.ZERO, false);
        PriceData fixed2 = this.createFixedPriceData(-1L, "1.08", "0.6", "10", "2013-04-02", null, true);
        data.addPrice(fixed2);
        data.addPrice(fixed2);
        PriceData unit2 = this.createUnitPriceData(-1L, "2.55", "1.5", "10", "2013-04-01", null);
        data.addPrice(unit2);
        data.addPrice(unit2);
        this.updater.update(product, data);
        Assert.assertEquals((long)4L, (long)product.getProductPrices().size());
    }

    @Test
    public void testPriceNotFound() {
        Product product = this.createProduct("P1", "Product 1", new ProductPrice[0]);
        ProductData data = this.createProduct(product);
        data.addPrice(this.createFixedPriceData(23L, "1.0", "0.5", "10", "2013-01-01", null, true));
        try {
            this.updater.update(product, data);
            Assert.fail((String)"Expected ProductIOException to be thrown");
        }
        catch (ProductIOException expected) {
            Assert.assertEquals((Object)"Price with identifier 23 not found", (Object)expected.getMessage());
        }
    }

    @Test
    public void testLinkedPrice() {
        ProductPrice fixedPrice = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2013-01-01", null)).defaultPrice(true).build();
        Product template = (Product)((TestPriceTemplateProductBuilder)this.productFactory.newPriceTemplate().addPrice(fixedPrice)).build();
        Product product = (Product)((TestMedicationProductBuilder)this.newProduct("P1", "Product 1", new ProductPrice[0]).addPriceTemplate(template, "2013-01-01", null)).build();
        Assert.assertEquals((long)0L, (long)product.getProductPrices().size());
        ProductData data = this.createProduct(product);
        Assert.assertEquals((long)1L, (long)data.getFixedPrices().size());
        this.updater.update(product, data);
        Assert.assertEquals((long)0L, (long)product.getProductPrices().size());
        ((PriceData)data.getFixedPrices().get(0)).setPrice(BigDecimal.TEN);
        try {
            this.updater.update(product, data);
            Assert.fail((String)"Expected ProductIOException to be thrown");
        }
        catch (ProductIOException expected) {
            Assert.assertEquals((Object)"Cannot update linked price", (Object)expected.getMessage());
        }
    }

    @Test
    public void testUpdatePrintedName() {
        Product product = this.createProduct("P1", "Product 1", new ProductPrice[0]);
        ProductData data = this.createProduct(product);
        data.setPrintedName("New Product 1");
        this.updater.update(product, data);
        IMObjectBean bean = this.getBean((IMObject)product);
        Assert.assertEquals((Object)"New Product 1", (Object)bean.getString("printedName"));
    }

    @Test
    public void testDuplicateExistingUnitPrice() {
        ProductPrice unit1 = this.createUnitPrice("1.08", "0.6", "60", "10", "2013-02-02", "2013-04-01");
        ProductPrice unit2 = this.createUnitPrice("1.92", "1.2", "60", "10", "2013-04-02", null);
        Product product = this.createProduct("P1", "Product 1", unit1, unit2);
        ProductData data = this.createProduct(product, BigDecimal.ZERO, true);
        PriceData unit3 = this.createUnitPriceData(-1L, "1.92", "1.2", "10", "2013-04-02", null);
        data.addPrice(unit3);
        this.updater.update(product, data);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, this.createUnitPrice("1.08", "0.6", "60", "10", "2013-02-02", "2013-04-01"));
        this.checkPrice(product, this.createUnitPrice("1.92", "1.2", "60", "10", "2013-04-02", null));
    }

    @Test
    public void testDuplicateExistingFixedPrice() {
        ProductPrice fixed1 = this.createFixedPrice("1.08", "0.6", "60", "10", "2013-02-02", "2013-04-01", true);
        ProductPrice fixed2 = this.createFixedPrice("1.92", "1.2", "60", "10", "2013-04-02", null, true);
        Product product = this.createProduct("P1", "Product 1", fixed1, fixed2);
        ProductData data = this.createProduct(product, BigDecimal.ZERO, true);
        PriceData fixed3 = this.createFixedPriceData(-1L, "1.92", "1.2", "10", "2013-04-02", null, true);
        data.addPrice(fixed3);
        this.updater.update(product, data);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, this.createFixedPrice("1.08", "0.6", "60", "10", "2013-02-02", "2013-04-01", true));
        this.checkPrice(product, this.createFixedPrice("1.92", "1.2", "60", "10", "2013-04-02", null, true));
    }

    @Test
    public void testUpdateDefaultFixedPrice() {
        ProductPrice fixed1 = this.createFixedPrice("1.08", "0.6", "80", "10", "2013-02-02", "2013-04-01", true);
        ProductPrice fixed2 = this.createFixedPrice("1.92", "1.2", "60", "10", "2013-04-02", null, true);
        Product product = this.createProduct("P1", "Product 1", fixed1, fixed2);
        ProductData data = this.createProduct(product, BigDecimal.ZERO, true);
        ((PriceData)data.getFixedPrices().get(0)).setDefault(false);
        ((PriceData)data.getFixedPrices().get(1)).setDefault(false);
        this.updater.update(product, data);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, this.createFixedPrice("1.08", "0.6", "80", "10", "2013-02-02", "2013-04-01", false));
        this.checkPrice(product, this.createFixedPrice("1.92", "1.2", "60", "10", "2013-04-02", null, false));
    }

    private PriceData createFixedPriceData(long id, String price, String cost, String maxDiscount, String from, String to, boolean isDefault) {
        return this.createPriceData(id, "productPrice.fixedPrice", price, cost, maxDiscount, from, to, isDefault);
    }

    private PriceData createUnitPriceData(long id, String price, String cost, String maxDiscount, String from, String to) {
        return this.createPriceData(id, "productPrice.unitPrice", price, cost, maxDiscount, from, to, false);
    }

    private PriceData createPriceData(long id, String shortName, String price, String cost, String maxDiscount, String from, String to, boolean isDefault) {
        Set groups = Collections.emptySet();
        return new PriceData(id, shortName, new BigDecimal(price), new BigDecimal(cost), new BigDecimal(maxDiscount), TestHelper.getDate(from), TestHelper.getDate(to), isDefault, groups, 1);
    }
}

