/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.product.ProductPriceTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;

public class ProductTestHelper {
    public static Product createMedication() {
        return TestHelper.createProduct();
    }

    public static Product createMedication(boolean restricted) {
        Product product = ProductTestHelper.createMedication();
        IMObjectBean bean = new IMObjectBean((IMObject)product);
        String code = restricted ? "S3" : "S4";
        Lookup schedule = TestHelper.getLookup("lookup.productDrugSchedule", code, code, restricted);
        IMObjectBean scheduleBean = new IMObjectBean((IMObject)schedule);
        scheduleBean.setValue("restricted", (Object)restricted);
        scheduleBean.save();
        bean.setValue("drugSchedule", (Object)code);
        bean.save();
        return product;
    }

    public static Product createMedication(Entity productType) {
        Product product = TestHelper.createProduct();
        ProductTestHelper.addProductType(product, productType);
        return product;
    }

    public static Product createMerchandise() {
        return TestHelper.createProduct("product.merchandise", null);
    }

    public static Product createService() {
        return TestHelper.createProduct("product.service", null);
    }

    public static Product createService(BigDecimal fixedPrice, BigDecimal unitPrice) {
        Product service = ProductTestHelper.createService();
        ProductPrice fixed = ProductPriceTestHelper.createFixedPrice(fixedPrice, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, (Date)null, null, true);
        ProductPrice unit = ProductPriceTestHelper.createUnitPrice(unitPrice, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, (Date)null, null);
        service.addProductPrice(fixed);
        service.addProductPrice(unit);
        TestHelper.save((IMObject)service);
        return service;
    }

    public static Product createPriceTemplate() {
        return TestHelper.createProduct("product.priceTemplate", null);
    }

    public static void addProductType(Product product, Entity productType) {
        IMObjectBean bean = new IMObjectBean((IMObject)product);
        bean.setTarget("type", (IMObject)productType);
        bean.save();
    }

    public static Entity createDose(Lookup species, BigDecimal minWeight, BigDecimal maxWeight, BigDecimal rate, BigDecimal quantity) {
        return ProductTestHelper.createDose(species, minWeight, maxWeight, rate, quantity, 2);
    }

    public static Entity createDose(Lookup species, BigDecimal minWeight, BigDecimal maxWeight, BigDecimal rate, BigDecimal quantity, int roundTo) {
        Entity dose = (Entity)TestHelper.create("entity.productDose");
        IMObjectBean bean = new IMObjectBean((IMObject)dose);
        if (species != null) {
            dose.addClassification(species);
        }
        bean.setValue("minWeight", (Object)minWeight);
        bean.setValue("maxWeight", (Object)maxWeight);
        bean.setValue("rate", (Object)rate);
        bean.setValue("quantity", (Object)quantity);
        bean.setValue("roundTo", (Object)roundTo);
        return dose;
    }

    public static void addDose(Product product, Entity dose) {
        IMObjectBean bean = new IMObjectBean((IMObject)product);
        bean.addTarget("doses", (IMObject)dose);
        bean.save(new IMObject[]{dose});
    }

    public static void addTest(Product product, Entity test) {
        IMObjectBean bean = new IMObjectBean((IMObject)product);
        bean.addTarget("tests", (IMObject)test);
        bean.save();
    }

    public static Product createTemplate() {
        return TestHelper.createProduct("product.template", null);
    }

    public static void addLocationExclusion(Product product, Party location) {
        IMObjectBean bean = new IMObjectBean((IMObject)product);
        bean.addTarget("locations", (IMObject)location);
        bean.save();
    }

    public static Product createTemplate(String name) {
        Product template = TestHelper.createProduct("product.template", null, false);
        template.setName(name);
        TestHelper.save((IMObject)template);
        return template;
    }

    public static Entity createProductType() {
        return ProductTestHelper.createProductType("XPRODUCTTYPE_" + System.currentTimeMillis());
    }

    public static Entity createProductType(String name) {
        Entity result = (Entity)TestHelper.create("entity.productType");
        result.setName(name);
        TestHelper.save((IMObject)result);
        return result;
    }

    public static Party createStockLocation() {
        Party result = (Party)TestHelper.create("party.organisationStockLocation");
        result.setName("STOCK-LOCATION-" + result.hashCode());
        TestHelper.save((IMObject)result);
        return result;
    }

    public static Party createStockLocation(Party location) {
        Party stockLocation = ProductTestHelper.createStockLocation();
        IMObjectBean locationBean = new IMObjectBean((IMObject)location);
        locationBean.addTarget("stockLocations", (IMObject)stockLocation, "locations");
        TestHelper.save(new IMObject[]{location, stockLocation});
        return stockLocation;
    }

    public static Relationship setStockQuantity(Product product, Party stockLocation, BigDecimal quantity) {
        IMObjectBean bean = new IMObjectBean((IMObject)product);
        List stockLocations = bean.getValues("stockLocations", Relationship.class);
        Relationship relationship = stockLocations.isEmpty() ? bean.addTarget("stockLocations", (IMObject)stockLocation) : (Relationship)stockLocations.get(0);
        IMObjectBean relBean = new IMObjectBean((IMObject)relationship);
        relBean.setValue("quantity", (Object)quantity);
        TestHelper.save((IMObject)product);
        return relationship;
    }

    public static void addInclude(Product template, Product include, int lowQuantity, int highQuantity) {
        ProductTestHelper.addInclude(template, include, lowQuantity, highQuantity, false);
    }

    public static void addInclude(Product template, Product include, int lowQuantity, int highQuantity, boolean zeroPrice) {
        ProductTestHelper.addInclude(template, include, lowQuantity, highQuantity, 0, 0, zeroPrice, false);
    }

    public static void addInclude(Product template, Product include, int lowQuantity, int highQuantity, int minWeight, int maxWeight) {
        ProductTestHelper.addInclude(template, include, lowQuantity, highQuantity, minWeight, maxWeight, false, false);
    }

    public static void addInclude(Product template, Product include, int quantity, boolean zeroPrice) {
        ProductTestHelper.addInclude(template, include, quantity, quantity, 0, 0, zeroPrice, false);
    }

    public static void addInclude(Product template, Product include, int lowQuantity, int highQuantity, int minWeight, int maxWeight, boolean zeroPrice, boolean skipIfMissing) {
        IMObjectBean bean = new IMObjectBean((IMObject)template);
        Relationship relationship = bean.addTarget("includes", (IMObject)include);
        IMObjectBean relBean = new IMObjectBean((IMObject)relationship);
        relBean.setValue("lowQuantity", (Object)lowQuantity);
        relBean.setValue("highQuantity", (Object)highQuantity);
        relBean.setValue("minWeight", (Object)minWeight);
        relBean.setValue("maxWeight", (Object)maxWeight);
        relBean.setValue("zeroPrice", (Object)zeroPrice);
        relBean.setValue("skipIfMissing", (Object)skipIfMissing);
        relBean.setValue("sequence", (Object)(bean.getValues("includes").size() - 1));
        bean.save();
    }

    public static void addServiceRatio(Party location, Entity productType, BigDecimal ratio) {
        ProductTestHelper.addServiceRatio(location, productType, ratio, null);
    }

    public static void addServiceRatio(Party location, Entity productType, BigDecimal ratio, Entity calendar) {
        IMObjectBean bean = new IMObjectBean((IMObject)location);
        Relationship relationship = bean.addTarget("serviceRatios", (IMObject)productType);
        IMObjectBean relBean = new IMObjectBean((IMObject)relationship);
        relBean.setValue("ratio", (Object)ratio);
        if (calendar != null) {
            relBean.setValue("calendar", (Object)calendar.getObjectReference());
        }
        bean.save();
    }

    public static Entity createBatch(String batchNumber, Product product, Date expiryDate, Party ... stockLocations) {
        Entity batch = TestHelper.create("entity.productBatch", Entity.class);
        IMObjectBean bean = new IMObjectBean((IMObject)batch);
        bean.setValue("name", (Object)batchNumber);
        Relationship relationship = bean.addTarget("product", (IMObject)product);
        IMObjectBean relBean = new IMObjectBean((IMObject)relationship);
        relBean.setValue("activeEndTime", (Object)expiryDate);
        for (Party stockLocation : stockLocations) {
            bean.addTarget("stockLocations", (IMObject)stockLocation);
        }
        TestHelper.save(new IMObject[]{batch, product});
        return batch;
    }
}

