/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.practice;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.rules.finance.deposit.DepositTestHelper;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.rules.util.EntityRelationshipHelper;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class LocationRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestPracticeFactory practiceFactory;
    private LocationRules rules;

    @Before
    public void setUp() {
        this.rules = new LocationRules(this.getArchetypeService());
    }

    @Test
    public void testGetPractice() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertNull((Object)this.rules.getPractice(location));
        Party practice = (Party)this.practiceFactory.newPractice().locations(location).build();
        Assert.assertEquals((Object)practice, (Object)this.rules.getPractice(location));
    }

    @Test
    public void testGetDefaultDepositAccount() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertNull((Object)this.rules.getDefaultDepositAccount(location));
        Party account1 = DepositTestHelper.createDepositAccount();
        Party account2 = DepositTestHelper.createDepositAccount();
        IMObjectBean bean = this.getBean((IMObject)location);
        bean.addTarget("depositAccounts", (IMObject)account1, "locations");
        Assert.assertNull((Object)this.rules.getDefaultDepositAccount(location));
        Relationship rel2 = bean.addTarget("depositAccounts", (IMObject)account2, "locations");
        EntityRelationshipHelper.setDefault((Entity)location, (String)"depositAccounts", (Relationship)rel2, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)account2, (Object)this.rules.getDefaultDepositAccount(location));
    }

    @Test
    public void testGetDefaultTill() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertNull((Object)this.rules.getDefaultTill(location));
        Entity till1 = this.practiceFactory.createTill();
        Entity till2 = this.practiceFactory.createTill();
        IMObjectBean bean = this.getBean((IMObject)location);
        bean.addTarget("tills", (IMObject)till1, "locations");
        Assert.assertNull((Object)this.rules.getDefaultTill(location));
        Relationship rel2 = bean.addTarget("tills", (IMObject)till2);
        EntityRelationshipHelper.setDefault((Entity)location, (String)"tills", (Relationship)rel2, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)till2, (Object)this.rules.getDefaultTill(location));
    }

    @Test
    public void testGetDefaultTerminal() {
        Entity till = this.practiceFactory.createTill();
        Assert.assertNull((Object)this.rules.getDefaultTerminal(till));
        Entity terminal1 = this.practiceFactory.createEFTPOSTerminal();
        Entity terminal2 = this.practiceFactory.createEFTPOSTerminal();
        IMObjectBean bean = this.getBean((IMObject)till);
        bean.addTarget("terminals", (IMObject)terminal1);
        Assert.assertNull((Object)this.rules.getDefaultTerminal(till));
        Relationship rel2 = bean.addTarget("terminals", (IMObject)terminal2);
        EntityRelationshipHelper.setDefault((Entity)till, (String)"terminals", (Relationship)rel2, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)terminal2, (Object)this.rules.getDefaultTerminal(till));
    }

    @Test
    public void testGetTerminals() {
        Entity till1 = this.practiceFactory.createTill();
        Assert.assertEquals((long)0L, (long)this.rules.getTerminals(till1).size());
        Entity terminal1 = this.practiceFactory.createEFTPOSTerminal();
        Entity terminal2 = this.practiceFactory.createEFTPOSTerminal();
        Entity till2 = (Entity)this.practiceFactory.newTill().terminals(terminal1, terminal2).build();
        Assert.assertEquals((long)2L, (long)this.rules.getTerminals(till2).size());
    }

    @Test
    public void testGetDefaultScheduleView() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertNull((Object)this.rules.getDefaultScheduleView(location));
        Party schedule1 = ScheduleTestHelper.createSchedule(location);
        Party schedule2 = ScheduleTestHelper.createSchedule(location);
        Entity view1 = ScheduleTestHelper.createScheduleView(new Entity[]{schedule1});
        Entity view2 = ScheduleTestHelper.createScheduleView(new Entity[]{schedule1, schedule2});
        IMObjectBean bean = this.getBean((IMObject)location);
        bean.addTarget("scheduleViews", (IMObject)view1);
        Assert.assertNull((Object)this.rules.getDefaultScheduleView(location));
        Relationship rel2 = bean.addTarget("scheduleViews", (IMObject)view2);
        EntityRelationshipHelper.setDefault((Entity)location, (String)"scheduleViews", (Relationship)rel2, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)view2, (Object)this.rules.getDefaultScheduleView(location));
    }

    @Test
    public void testGetScheduleViews() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertEquals((long)0L, (long)this.rules.getScheduleViews(location).size());
        Party schedule1 = ScheduleTestHelper.createSchedule(location);
        Party schedule2 = ScheduleTestHelper.createSchedule(location);
        Entity view1 = ScheduleTestHelper.createScheduleView(new Entity[]{schedule1});
        Entity view2 = ScheduleTestHelper.createScheduleView(new Entity[]{schedule1, schedule2});
        IMObjectBean bean = this.getBean((IMObject)location);
        bean.addTarget("scheduleViews", (IMObject)view1);
        bean.addTarget("scheduleViews", (IMObject)view2);
        bean.save(new IMObject[]{location});
        Assert.assertEquals((long)2L, (long)this.rules.getScheduleViews(location).size());
        view2.setActive(false);
        this.save((IMObject)view2);
        Assert.assertEquals((long)1L, (long)this.rules.getScheduleViews(location).size());
    }

    @Test
    public void testGetDefaultWorkListView() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertNull((Object)this.rules.getDefaultWorkListView(location));
        Party worklist1 = ScheduleTestHelper.createWorkList();
        Party worklist2 = ScheduleTestHelper.createWorkList();
        Entity view1 = ScheduleTestHelper.createWorkListView(new Entity[]{worklist1});
        Entity view2 = ScheduleTestHelper.createWorkListView(new Entity[]{worklist1, worklist2});
        IMObjectBean bean = this.getBean((IMObject)location);
        bean.addTarget("workListViews", (IMObject)view1);
        Assert.assertNull((Object)this.rules.getDefaultWorkListView(location));
        Relationship rel2 = bean.addTarget("workListViews", (IMObject)view2);
        EntityRelationshipHelper.setDefault((Entity)location, (String)"workListViews", (Relationship)rel2, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)view2, (Object)this.rules.getDefaultWorkListView(location));
    }

    @Test
    public void testGetWorkListViews() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertEquals((long)0L, (long)this.rules.getWorkListViews(location).size());
        Party worklist1 = ScheduleTestHelper.createWorkList();
        Party worklist2 = ScheduleTestHelper.createWorkList();
        Entity view1 = ScheduleTestHelper.createWorkListView(new Entity[]{worklist1});
        Entity view2 = ScheduleTestHelper.createWorkListView(new Entity[]{worklist1, worklist2});
        IMObjectBean bean = this.getBean((IMObject)location);
        bean.addTarget("workListViews", (IMObject)view1);
        bean.addTarget("workListViews", (IMObject)view2);
        bean.save(new IMObject[]{location});
        Assert.assertEquals((long)2L, (long)this.rules.getWorkListViews(location).size());
        view2.setActive(false);
        this.save((IMObject)view2);
        Assert.assertEquals((long)1L, (long)this.rules.getWorkListViews(location).size());
    }

    @Test
    public void testGetStockLocation() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertNull((Object)this.rules.getDefaultStockLocation(location));
        Assert.assertNull((Object)this.rules.getDefaultStockLocationRef(location));
        Party stockLocation = ProductTestHelper.createStockLocation();
        IMObjectBean bean = this.getBean((IMObject)location);
        bean.addTarget("stockLocations", (IMObject)stockLocation);
        Assert.assertEquals((Object)stockLocation, (Object)this.rules.getDefaultStockLocation(location));
        Assert.assertEquals((Object)stockLocation.getObjectReference(), (Object)this.rules.getDefaultStockLocationRef(location));
    }

    @Test
    public void testGetMailServer() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertNull((Object)this.rules.getMailServer(location));
        Entity mailServer = (Entity)this.practiceFactory.newMailServer().host("localhost").build();
        this.practiceFactory.updateLocation(location).setMailServer(mailServer).build();
        Assert.assertEquals((long)mailServer.getId(), (long)this.rules.getMailServer(location).getId());
        mailServer.setActive(false);
        this.save((IMObject)mailServer);
        Assert.assertNull((Object)this.rules.getMailServer(location));
    }

    @Test
    public void testGetPrinters() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertEquals((long)0L, (long)this.rules.getPrinters(location).size());
        IMObject printer1 = this.createPrinter("printer1");
        IMObject printer2 = this.createPrinter("printer2");
        this.save(new IMObject[]{printer1, printer2});
        IMObjectBean bean = this.getBean((IMObject)location);
        bean.addTarget("printers", printer1);
        bean.addTarget("printers", printer2);
        bean.save();
        List printers = this.rules.getPrinters(location);
        Assert.assertEquals((long)2L, (long)printers.size());
        Assert.assertTrue((((PrinterReference)printers.get(0)).getId().equals("printer1") || ((PrinterReference)printers.get(1)).getId().equals("printer1") ? 1 : 0) != 0);
        Assert.assertTrue((((PrinterReference)printers.get(0)).getId().equals("printer2") || ((PrinterReference)printers.get(1)).getId().equals("printer2") ? 1 : 0) != 0);
    }

    @Test
    public void testGapBenefitTill() {
        Party location = this.practiceFactory.createLocation();
        Assert.assertNull((Object)this.rules.getGapBenefitTill(location));
        IMObjectBean bean = this.getBean((IMObject)location);
        Entity till = this.practiceFactory.createTill();
        bean.setTarget("gapBenefitTill", (IMObject)till);
        bean.save();
        Assert.assertEquals((Object)till, (Object)this.rules.getGapBenefitTill(location));
    }

    protected IMObject createPrinter(String printer) {
        IMObject object = this.create("entity.printer");
        IMObjectBean bean = this.getBean(object);
        bean.setValue("name", (Object)printer);
        bean.setValue("printer", (Object)(":" + printer));
        bean.save();
        return object;
    }
}

