/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

public class ReminderItemQueryFactoryTestCase
extends ArchetypeServiceTest {
    @Test
    public void testQuery() {
        Entity reminderType = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient(customer);
        Date date = DateRules.getToday();
        Act email1 = ReminderTestHelper.createEmailReminder(date, date, "PENDING", 0);
        Act sms1 = ReminderTestHelper.createSMSReminder(date, date, "PENDING", 0);
        Act print1 = ReminderTestHelper.createPrintReminder(date, date, "PENDING", 0);
        Act export1 = ReminderTestHelper.createExportReminder(date, date, "PENDING", 0);
        Act list1 = ReminderTestHelper.createListReminder(date, date, "PENDING", 0);
        Act reminder1 = ReminderTestHelper.createReminder(date, patient, reminderType, email1, sms1, print1, export1, list1);
        Act email2 = ReminderTestHelper.createPrintReminder(date, date, "PENDING", 0);
        Act print2 = ReminderTestHelper.createPrintReminder(date, date, "PENDING", 0);
        Act reminder2 = ReminderTestHelper.createReminder(date, patient, reminderType, email2, print2);
        reminder2.setStatus("COMPLETED");
        this.save((IMObject)reminder2);
        Act email3 = ReminderTestHelper.createPrintReminder(date, date, "PENDING", 0);
        Act list3 = ReminderTestHelper.createListReminder(date, date, "PENDING", 0);
        Act reminder3 = ReminderTestHelper.createReminder(date, patient, reminderType, email3, list3);
        reminder3.setStatus("CANCELLED");
        this.save((IMObject)reminder3);
        ReminderItemQueryFactory query = new ReminderItemQueryFactory();
        this.checkExists(query, reminder1, patient, customer, email1, sms1, print1, export1, list1);
        this.checkNotExists(query, reminder2, patient, customer, email2, print2);
        this.checkNotExists(query, reminder3, patient, customer, email3, list3);
        query.setArchetype("act.patientReminderItemEmail");
        this.checkExists(query, reminder1, patient, customer, email1);
        this.checkNotExists(query, reminder1, patient, customer, sms1, print1, export1, list1);
        this.checkNotExists(query, reminder2, patient, customer, email2, print2);
        this.checkNotExists(query, reminder3, patient, customer, email3, list3);
        email1.setStatus("ERROR");
        this.save((IMObject)email1);
        query.setArchetype("act.patientReminderItem*");
        query.setStatus("PENDING");
        this.checkExists(query, reminder1, patient, customer, sms1, print1, export1, list1);
        this.checkNotExists(query, reminder1, patient, customer, email1);
        this.checkNotExists(query, reminder2, patient, customer, email2, print2);
        this.checkNotExists(query, reminder3, patient, customer, email3, list3);
        query.setStatus("ERROR");
        this.checkExists(query, reminder1, patient, customer, email1);
        this.checkNotExists(query, reminder1, patient, customer, sms1, print1, export1, list1);
        this.checkNotExists(query, reminder2, patient, customer, email2, print2);
        this.checkNotExists(query, reminder3, patient, customer, email3, list3);
    }

    @Test
    public void testQueryByCustomer() {
        Entity reminderType = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        Party customer1 = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient(customer1);
        Party customer2 = TestHelper.createCustomer();
        Party patient2 = TestHelper.createPatient(customer2);
        Date date = DateRules.getToday();
        Act email1 = ReminderTestHelper.createEmailReminder(date, date, "PENDING", 0);
        Act sms1 = ReminderTestHelper.createSMSReminder(date, date, "PENDING", 0);
        Act print1 = ReminderTestHelper.createPrintReminder(date, date, "PENDING", 0);
        Act export1 = ReminderTestHelper.createExportReminder(date, date, "PENDING", 0);
        Act list1 = ReminderTestHelper.createListReminder(date, date, "PENDING", 0);
        Act reminder1 = ReminderTestHelper.createReminder(date, patient1, reminderType, email1, sms1, print1, export1, list1);
        Act email2 = ReminderTestHelper.createPrintReminder(date, date, "PENDING", 0);
        Act print2 = ReminderTestHelper.createPrintReminder(date, date, "PENDING", 0);
        Act reminder2 = ReminderTestHelper.createReminder(date, patient2, reminderType, email2, print2);
        ReminderItemQueryFactory query = new ReminderItemQueryFactory();
        query.setCustomer(customer1);
        this.checkExists(query, reminder1, patient1, customer1, email1, sms1, print1, export1, list1);
        this.checkNotExists(query, reminder2, patient2, customer2, email2, print2);
        query.setCustomer(customer2);
        this.checkNotExists(query, reminder1, patient1, customer1, email1, sms1, print1, export1, list1);
        this.checkExists(query, reminder2, patient2, customer2, email2, print2);
    }

    @Test
    public void testQueryByLocation() {
        Date date = DateRules.getToday();
        Entity reminderType = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        Party customer1 = TestHelper.createCustomer();
        Party customer2 = TestHelper.createCustomer();
        Party customer3 = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient(customer1);
        Party patient2 = TestHelper.createPatient(customer2);
        Party patient3 = TestHelper.createPatient(customer3);
        Act email1 = ReminderTestHelper.createEmailReminder(date, date, "PENDING", 0);
        Act reminder1 = ReminderTestHelper.createReminder(date, patient1, reminderType, email1);
        Act email2 = ReminderTestHelper.createEmailReminder(date, date, "PENDING", 0);
        Act reminder2 = ReminderTestHelper.createReminder(date, patient2, reminderType, email2);
        Act email3 = ReminderTestHelper.createEmailReminder(date, date, "PENDING", 0);
        Act reminder3 = ReminderTestHelper.createReminder(date, patient3, reminderType, email3);
        ReminderItemQueryFactory query = new ReminderItemQueryFactory();
        this.checkExists(query, reminder1, patient1, customer1, email1);
        this.checkExists(query, reminder2, patient2, customer2, email2);
        this.checkExists(query, reminder3, patient3, customer3, email3);
        query.setLocation(Location.NONE);
        this.checkExists(query, reminder1, patient1, customer1, email1);
        this.checkExists(query, reminder2, patient2, customer2, email2);
        this.checkExists(query, reminder3, patient3, customer3, email3);
        Party location1 = TestHelper.createLocation();
        IMObjectBean bean = this.getBean((IMObject)customer1);
        bean.setTarget("practice", (IMObject)location1);
        bean.save();
        this.checkNotExists(query, reminder1, patient1, customer1, email1);
        this.checkExists(query, reminder2, patient2, customer2, email2);
        this.checkExists(query, reminder3, patient3, customer3, email3);
        query.setLocation(new Location(location1));
        this.checkExists(query, reminder1, patient1, customer1, email1);
        this.checkNotExists(query, reminder2, patient2, customer2, email2);
        this.checkNotExists(query, reminder3, patient3, customer3, email3);
    }

    private void checkExists(ReminderItemQueryFactory factory, Act reminder, Party patient, Party customer, Act ... items) {
        int matches = this.getMatches(factory, reminder, patient, customer, items);
        Assert.assertEquals((long)items.length, (long)matches);
    }

    private void checkNotExists(ReminderItemQueryFactory factory, Act reminder, Party patient, Party customer, Act ... items) {
        int matches = this.getMatches(factory, reminder, patient, customer, items);
        Assert.assertEquals((long)0L, (long)matches);
    }

    private int getMatches(ReminderItemQueryFactory factory, Act reminder, Party patient, Party customer, Act[] items) {
        int matches = 0;
        HashSet<Act> itemSet = new HashSet<Act>(Arrays.asList(items));
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator((IArchetypeQuery)factory.createQuery());
        while (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            Act actualReminder = (Act)set.get("reminder");
            if (!actualReminder.equals(reminder)) continue;
            Act actualItem = (Act)set.get("item");
            Party actualPatient = (Party)set.get("patient");
            Party actualCustomer = (Party)set.get("customer");
            if (!itemSet.contains(actualItem) || !actualPatient.equals(patient) || !actualCustomer.equals(customer)) continue;
            ++matches;
        }
        return matches;
    }
}

