/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.i18n.time.DurationFormatterTestHelper;
import org.openvpms.archetype.rules.patient.PatientAgeFormatter;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class PatientAgeFormatterTestCase
extends ArchetypeServiceTest {
    @Test
    public void testFormat() {
        Lookup formats = DurationFormatterTestHelper.createDurationFormats();
        DurationFormatterTestHelper.addFormat(formats, 7, DateUnits.DAYS, false, false, false, true);
        DurationFormatterTestHelper.addFormat(formats, 90, DateUnits.DAYS, false, false, true, false);
        DurationFormatterTestHelper.addFormat(formats, 1, DateUnits.YEARS, false, true, false, false);
        DurationFormatterTestHelper.addFormat(formats, 2, DateUnits.YEARS, true, true, false, false);
        this.setPracticeFormat(TestHelper.getPractice(), formats);
        PatientAgeFormatter formatter = this.createFormatter();
        Date from = TestHelper.getDate("2011-01-01");
        Date to1 = TestHelper.getDate("2011-01-07");
        Date to2 = TestHelper.getDate("2011-01-08");
        Date to3 = TestHelper.getDate("2012-01-01");
        Date to4 = TestHelper.getDate("2013-02-01");
        this.checkFormat("6 Days", from, to1, formatter);
        this.checkFormat("7 Days", from, to2, formatter);
        this.checkFormat("12 Months", from, to3, formatter);
        this.checkFormat("2 Years 1 Month", from, to4, formatter);
    }

    @Test
    public void testDefaultFormat() {
        this.setPracticeFormat(TestHelper.getPractice(), null);
        PatientAgeFormatter formatter = this.createFormatter();
        Date from = TestHelper.getDate("2011-01-01");
        Date to1 = TestHelper.getDate("2011-01-07");
        Date to2 = TestHelper.getDate("2011-01-08");
        Date to3 = TestHelper.getDate("2012-01-01");
        Date to4 = TestHelper.getDate("2013-02-01");
        this.checkFormat("6 Days", from, to1, formatter);
        this.checkFormat("7 Days", from, to2, formatter);
        this.checkFormat("12 Months", from, to3, formatter);
        this.checkFormat("2 Years", from, to4, formatter);
    }

    protected void setPracticeFormat(Party practice, Lookup formats) {
        IMObjectBean bean = this.getBean((IMObject)practice);
        String code = formats != null ? formats.getCode() : null;
        bean.setValue("patientAgeFormat", (Object)code);
        bean.save();
    }

    protected PatientAgeFormatter createFormatter() {
        PracticeRules rules = new PracticeRules((ArchetypeService)this.getArchetypeService(), null);
        return new PatientAgeFormatter(this.getLookupService(), rules, (ArchetypeService)this.getArchetypeService());
    }

    protected void checkFormat(String expected, Date from, Date to, PatientAgeFormatter formatter) {
        String result = formatter.format(from, to);
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

