/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.message;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.message.MessageRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.message.TestAuditMessageBuilder;
import org.openvpms.archetype.test.builder.message.TestMessageFactory;
import org.openvpms.archetype.test.builder.message.TestSystemMessageBuilder;
import org.openvpms.archetype.test.builder.message.TestUserMessageBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;

public class MessageRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestMessageFactory messageFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testHasNewMessages() {
        MessageRules rules = new MessageRules(this.getArchetypeService());
        User user1 = this.userFactory.createUser();
        User user2 = this.userFactory.createUser();
        Assert.assertFalse((boolean)rules.hasNewMessages(user1));
        Assert.assertFalse((boolean)rules.hasNewMessages(user2));
        Act message1 = (Act)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)this.messageFactory.newUserMessage().to(user1)).subject("a subject")).reason("PHONE_CALL")).message("a message")).status("PENDING")).build();
        Assert.assertTrue((boolean)rules.hasNewMessages(user1));
        Assert.assertFalse((boolean)rules.hasNewMessages(user2));
        ((TestUserMessageBuilder)this.messageFactory.updateUserMessage(message1).status("READ")).build();
        Assert.assertFalse((boolean)rules.hasNewMessages(user1));
        Assert.assertFalse((boolean)rules.hasNewMessages(user2));
        ((TestUserMessageBuilder)this.messageFactory.updateUserMessage(message1).status("COMPLETED")).build();
        Assert.assertFalse((boolean)rules.hasNewMessages(user1));
        Assert.assertFalse((boolean)rules.hasNewMessages(user2));
        Act message2 = (Act)((TestAuditMessageBuilder)((TestAuditMessageBuilder)((TestAuditMessageBuilder)((TestAuditMessageBuilder)this.messageFactory.newAuditMessage().subject("locking enabled")).reason("MEDICAL_RECORD_LOCKING")).to(user2)).status("PENDING")).build();
        Assert.assertFalse((boolean)rules.hasNewMessages(user1));
        Assert.assertTrue((boolean)rules.hasNewMessages(user2));
        ((TestAuditMessageBuilder)this.messageFactory.updateAuditMessage(message2).status("COMPLETED")).build();
        Assert.assertFalse((boolean)rules.hasNewMessages(user1));
        Assert.assertFalse((boolean)rules.hasNewMessages(user2));
        User user3 = this.userFactory.createUser();
        Assert.assertFalse((boolean)rules.hasNewMessages(user3));
        Act message3 = (Act)((TestSystemMessageBuilder)((TestSystemMessageBuilder)((TestSystemMessageBuilder)this.messageFactory.newSystemMessage().subject("order invoiced")).to(user3)).status("PENDING")).build();
        Assert.assertTrue((boolean)rules.hasNewMessages(user3));
        ((TestSystemMessageBuilder)this.messageFactory.updateSystemMessage(message3).status("READ")).build();
        Assert.assertFalse((boolean)rules.hasNewMessages(user3));
    }

    @Test
    public void testHasNewMessagesSince() {
        MessageRules rules = new MessageRules(this.getArchetypeService());
        User user1 = this.userFactory.createUser();
        Assert.assertFalse((boolean)rules.hasNewMessages(user1, TestHelper.getDate("2023-07-01")));
        Act message1 = (Act)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)((TestUserMessageBuilder)this.messageFactory.newUserMessage().to(user1)).startTime("2023-07-01")).subject("a subject")).reason("PHONE_CALL")).message("a message")).status("PENDING")).build();
        Assert.assertTrue((boolean)rules.hasNewMessages(user1, TestHelper.getDate("2023-07-01")));
        Assert.assertFalse((boolean)rules.hasNewMessages(user1, TestHelper.getDate("2023-07-02")));
        ((TestUserMessageBuilder)this.messageFactory.updateUserMessage(message1).status("READ")).build();
        Assert.assertFalse((boolean)rules.hasNewMessages(user1, TestHelper.getDate("2023-07-01")));
        Assert.assertFalse((boolean)rules.hasNewMessages(user1, TestHelper.getDate("2023-07-02")));
    }
}

