/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.math;

import junit.framework.TestCase;
import org.junit.Test;
import org.openvpms.archetype.rules.math.CurrencyException;

public class CurrencyExceptionTestCase
extends TestCase {
    @Test
    public void testMessages() {
        CurrencyExceptionTestCase.assertEquals((String)"Need to update tests to incorporate new messages", (int)3, (int)CurrencyException.ErrorCode.values().length);
        this.checkException(CurrencyException.ErrorCode.InvalidCurrencyCode, "'foo' is not a valid ISO currency code", "foo");
        this.checkException(CurrencyException.ErrorCode.InvalidRoundingMode, "'foo' is not a valid rounding mode for currency code bar", "foo", "bar");
        this.checkException(CurrencyException.ErrorCode.NoLookupForCode, "No lookup.currency has been defined for currency code foo", "foo");
    }

    private void checkException(CurrencyException.ErrorCode code, String expected, Object ... args) {
        CurrencyException exception = new CurrencyException(code, args);
        CurrencyExceptionTestCase.assertEquals((Object)code, (Object)exception.getErrorCode());
        CurrencyExceptionTestCase.assertEquals((String)expected, (String)exception.getMessage());
    }
}

