/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.insurance;

import java.math.BigDecimal;
import java.util.Date;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;

public class InsuranceTestHelper {
    public static Party createInsurer() {
        return InsuranceTestHelper.createInsurer(TestHelper.randomName("ZInsurer-"));
    }

    public static Party createInsurer(String name) {
        Party result = TestHelper.create("party.supplierInsurer", Party.class);
        result.setName(name);
        TestHelper.save((IMObject)result);
        return result;
    }

    public static Act createPolicy(Party customer, Party patient, Party insurer, String policyNumber) {
        ActIdentity identity = null;
        if (policyNumber != null) {
            identity = TestHelper.createActIdentity("actIdentity.insurancePolicy", policyNumber);
        }
        return InsuranceTestHelper.createPolicy(customer, patient, insurer, identity);
    }

    public static Act createPolicy(Party customer, Party patient, Party insurer, ActIdentity identity) {
        Act policy = TestHelper.create("act.patientInsurancePolicy", Act.class);
        IMObjectBean bean = new IMObjectBean((IMObject)policy);
        bean.setTarget("customer", (IMObject)customer);
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("insurer", (IMObject)insurer);
        if (identity != null) {
            policy.addIdentity(identity);
        }
        return policy;
    }

    public static FinancialAct createClaim(Act policy, Party location, User clinician, User claimHandler, FinancialAct ... items) {
        return InsuranceTestHelper.createClaim(policy, location, clinician, claimHandler, false, items);
    }

    public static FinancialAct createClaim(Act policy, Party location, User clinician, User claimHandler, boolean gapClaim, FinancialAct ... items) {
        FinancialAct claim = TestHelper.create("act.patientInsuranceClaim", FinancialAct.class);
        IMObjectBean bean = new IMObjectBean((IMObject)claim);
        IMObjectBean policyBean = new IMObjectBean((IMObject)policy);
        bean.setTarget("patient", policyBean.getTargetRef("patient"));
        bean.setTarget("clinician", (IMObject)clinician);
        bean.setTarget("location", (IMObject)location);
        bean.setTarget("user", (IMObject)claimHandler);
        bean.addTarget("policy", (IMObject)policy, "claims");
        bean.setValue("gapClaim", (Object)gapClaim);
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        for (FinancialAct item : items) {
            bean.addTarget("items", (IMObject)item, "claim");
            total = total.add(item.getTotal());
            tax = tax.add(item.getTaxAmount());
        }
        bean.setValue("amount", (Object)total);
        bean.setValue("tax", (Object)tax);
        return claim;
    }

    public static FinancialAct createClaimItem(FinancialAct ... invoiceItems) {
        InsuranceTestHelper.createDiagnosis("VENOM_328", "Abcess", "328");
        return InsuranceTestHelper.createClaimItem("VENOM_328", new Date(), new Date(), invoiceItems);
    }

    public static FinancialAct createClaimItem(String diagnosis, Date startTime, Date endTime, FinancialAct ... invoiceItems) {
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        FinancialAct item = TestHelper.create("act.patientInsuranceClaimItem", FinancialAct.class);
        IMObjectBean bean = new IMObjectBean((IMObject)item);
        item.setReason(TestHelper.getLookup("lookup.diagnosisVeNom", diagnosis, diagnosis, true).getCode());
        item.setActivityStartTime(startTime);
        item.setActivityEndTime(endTime);
        item.setDescription("Condition description");
        for (FinancialAct invoiceItem : invoiceItems) {
            total = total.add(invoiceItem.getTotal());
            tax = tax.add(invoiceItem.getTaxAmount());
            bean.addTarget("items", (IMObject)invoiceItem, "claims");
        }
        bean.setValue("amount", (Object)total);
        bean.setValue("tax", (Object)tax);
        return item;
    }

    public static DocumentAct createAttachment(DocumentAct document) {
        DocumentAct result = TestHelper.create("act.patientInsuranceClaimAttachment", DocumentAct.class);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("name", (Object)document.getName());
        Relationship original = bean.addTarget("original", (IMObject)document);
        document.addActRelationship((ActRelationship)original);
        TestHelper.save(new IMObject[]{result, document});
        return result;
    }

    public static Lookup createDiagnosis(String code, String name, String dictionaryId) {
        Lookup diagnosis = TestHelper.getLookup("lookup.diagnosisVeNom", code, false);
        IMObjectBean bean = new IMObjectBean((IMObject)diagnosis);
        bean.setValue("name", (Object)name);
        bean.setValue("dataDictionaryId", (Object)dictionaryId);
        bean.save();
        return diagnosis;
    }
}

