/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.insurance;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class InsuranceRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    @Autowired
    private PlatformTransactionManager transactionManager;
    private InsuranceRules rules;
    private Party customer;
    private Party patient;

    @Before
    public void setUp() {
        this.rules = new InsuranceRules(this.getArchetypeService(), this.transactionManager);
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
    }

    @Test
    public void testCreatePolicy() {
        Party insurer = this.insuranceFactory.createInsurer();
        Act policy1 = this.rules.createPolicy(this.customer, this.patient, insurer, null);
        Assert.assertTrue((boolean)policy1.isNew());
        Assert.assertTrue((boolean)policy1.isA("act.patientInsurancePolicy"));
        this.save((IMObject)policy1);
        this.checkPolicy(policy1, this.customer, this.patient, insurer, null);
        Act policy2 = this.rules.createPolicy(this.customer, this.patient, insurer, "POL1234");
        this.save((IMObject)policy2);
        this.checkPolicy(policy2, this.customer, this.patient, insurer, "POL1234");
        Act policy3 = this.rules.createPolicy(this.customer, this.patient, insurer, "POL987651");
        this.save((IMObject)policy3);
        this.checkPolicy(policy3, this.customer, this.patient, insurer, "POL987651");
    }

    @Test
    public void testGetPolicyForClaimForUnusedPolicy() {
        Party insurer1 = this.insuranceFactory.createInsurer();
        Party insurer2 = this.insuranceFactory.createInsurer();
        Act policy1 = this.rules.getPolicyForClaim(this.customer, this.patient, insurer1, null, null, null);
        Assert.assertNotNull((Object)policy1);
        Assert.assertTrue((boolean)policy1.isNew());
        this.save((IMObject)policy1);
        this.checkPolicy(policy1, this.customer, this.patient, insurer1, null);
        Act policy2 = this.rules.getPolicyForClaim(this.customer, this.patient, insurer1, "POL1234", null, null);
        Assert.assertEquals((Object)policy1, (Object)policy2);
        this.checkPolicy(policy2, this.customer, this.patient, insurer1, "POL1234");
        Act policy3 = this.rules.getPolicyForClaim(this.customer, this.patient, insurer1, "POL5678", null, null);
        Assert.assertEquals((Object)policy1, (Object)policy3);
        this.checkPolicy(policy3, this.customer, this.patient, insurer1, "POL5678");
        Act policy4 = this.rules.getPolicyForClaim(this.customer, this.patient, insurer2, "POL5678", null, null);
        Assert.assertEquals((Object)policy1, (Object)policy4);
        this.checkPolicy(policy4, this.customer, this.patient, insurer2, "POL5678");
        Act policy5 = this.rules.getPolicyForClaim(this.customer, this.patient, insurer1, "POL1234", null, null);
        Assert.assertEquals((Object)policy1, (Object)policy5);
        this.checkPolicy(policy5, this.customer, this.patient, insurer1, "POL1234");
    }

    @Test
    public void testGetPolicyForClaimForDifferentPatient() {
        Party patient2 = this.patientFactory.createPatient(this.customer);
        Party insurer1 = this.insuranceFactory.createInsurer();
        Act policy1 = this.rules.getPolicyForClaim(this.customer, this.patient, insurer1, null, null, null);
        this.save((IMObject)policy1);
        Act policy2 = this.rules.getPolicyForClaim(this.customer, patient2, insurer1, null, null, null);
        Assert.assertNotEquals((Object)policy1, (Object)policy2);
    }

    @Test
    public void testGetPolicyForClaimWithExistingClaims() {
        Party insurer1 = this.insuranceFactory.createInsurer();
        User clinician = this.userFactory.createClinician();
        Act policy1 = this.rules.createPolicy(this.customer, this.patient, insurer1, "POL12345");
        this.save((IMObject)policy1);
        FinancialAct claim1 = (FinancialAct)this.insuranceFactory.newClaim().policy(policy1).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).item().diagnosis("VENOM_328").add().build();
        Act same1 = this.rules.getPolicyForClaim(this.customer, this.patient, insurer1, "POL12345", null, null);
        Assert.assertEquals((Object)policy1, (Object)same1);
        this.checkPolicy(same1, this.customer, this.patient, insurer1, "POL12345");
        Act policy2 = this.rules.getPolicyForClaim(this.customer, this.patient, insurer1, "POL98765", null, null);
        Assert.assertNotEquals((Object)policy1, (Object)policy2);
        this.checkPolicy(policy2, this.customer, this.patient, insurer1, "POL98765");
        this.save((IMObject)policy2);
        FinancialAct claim2 = (FinancialAct)this.insuranceFactory.newClaim().policy(policy2).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).item().diagnosis("VENOM_328").add().build();
        Act same2 = this.rules.getPolicyForClaim(this.customer, this.patient, insurer1, "POL222222", claim2, policy2);
        Assert.assertEquals((Object)policy2, (Object)same2);
        this.checkPolicy(policy2, this.customer, this.patient, insurer1, "POL222222");
    }

    @Test
    public void testGetCurrentPolicy() {
        Assert.assertNull((Object)this.rules.getCurrentPolicy(this.customer, this.patient));
        Act policy = this.rules.createPolicy(this.customer, this.patient, this.insuranceFactory.createInsurer(), null);
        this.save((IMObject)policy);
        Assert.assertEquals((Object)policy, (Object)this.rules.getCurrentPolicy(this.customer, this.patient));
        policy.setActivityStartTime(DateRules.getYesterday());
        policy.setActivityEndTime(DateRules.getToday());
        this.save((IMObject)policy);
        Assert.assertNull((Object)this.rules.getCurrentPolicy(this.customer, this.patient));
        policy.setActivityEndTime(null);
        this.save((IMObject)policy);
        Assert.assertEquals((Object)policy, (Object)this.rules.getCurrentPolicy(this.customer, this.patient));
    }

    @Test
    public void testGetCurrentPolicies() {
        Assert.assertNull((Object)this.rules.getCurrentPolicy(this.customer, this.patient));
        Act policy1 = this.rules.createPolicy(this.customer, this.patient, this.insuranceFactory.createInsurer(), null);
        Act policy2 = this.rules.createPolicy(this.customer, this.patient, this.insuranceFactory.createInsurer(), null);
        Act policy3 = this.rules.createPolicy(this.customer, this.patient, this.insuranceFactory.createInsurer(), null);
        Date today = DateRules.getToday();
        policy1.setActivityStartTime(DateRules.getDate((Date)today, (int)-1, (DateUnits)DateUnits.YEARS));
        policy1.setActivityEndTime(DateRules.getYesterday());
        policy2.setActivityStartTime(DateRules.getDate((Date)today, (int)-6, (DateUnits)DateUnits.MONTHS));
        policy2.setActivityEndTime(null);
        policy3.setActivityStartTime(today);
        this.save((IMObject[])new Act[]{policy1, policy2, policy3});
        List policies = this.rules.getCurrentPolicies(this.customer, this.patient);
        Assert.assertEquals((long)2L, (long)policies.size());
        Assert.assertEquals((Object)policy3, policies.get(0));
        Assert.assertEquals((Object)policy2, policies.get(1));
    }

    @Test
    public void testCreateClaim() {
        Act policy = this.rules.createPolicy(this.customer, this.patient, this.insuranceFactory.createInsurer(), null);
        this.save((IMObject)policy);
        FinancialAct claim = this.rules.createClaim(policy);
        Assert.assertNotNull((Object)claim);
        Assert.assertTrue((boolean)claim.isA("act.patientInsuranceClaim"));
        IMObjectBean bean = this.getBean((IMObject)claim);
        Assert.assertEquals((Object)policy, (Object)bean.getTarget("policy"));
    }

    @Test
    public void testIsClaimed() {
        Act policy = this.rules.createPolicy(this.customer, this.patient, this.insuranceFactory.createInsurer(), null);
        this.save((IMObject)policy);
        User clinician = this.userFactory.createClinician();
        FinancialAct invoice1Item1 = this.createInvoiceItem();
        FinancialAct invoice1Item2 = this.createInvoiceItem();
        FinancialAct invoice1Item3 = this.createInvoiceItem();
        FinancialAct invoice = this.createInvoice("POSTED", invoice1Item1, invoice1Item2, invoice1Item3);
        Assert.assertFalse((boolean)this.rules.isClaimed(invoice));
        FinancialAct claim = (FinancialAct)this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).item(invoice1Item1, invoice1Item2).build();
        for (String status : new String[]{"PENDING", "POSTED", "SUBMITTED", "ACCEPTED", "PRE_SETTLED", "SETTLED", "DECLINED"}) {
            claim.setStatus(status);
            this.save((IMObject)claim);
            Assert.assertTrue((boolean)this.rules.isClaimed(invoice));
            if ("PENDING".equals(status)) {
                Assert.assertFalse((boolean)this.rules.isClaimed(invoice, true));
                continue;
            }
            Assert.assertTrue((boolean)this.rules.isClaimed(invoice, true));
        }
        for (String status : new String[]{"CANCELLING", "CANCELLED"}) {
            claim.setStatus(status);
            this.save((IMObject)claim);
            Assert.assertFalse((boolean)this.rules.isClaimed(invoice));
        }
    }

    @Test
    public void testGetCurrentClaims() {
        Act policy = this.rules.createPolicy(this.customer, this.patient, this.insuranceFactory.createInsurer(), null);
        this.save((IMObject)policy);
        User clinician = this.userFactory.createClinician();
        FinancialAct invoice1Item1 = this.createInvoiceItem();
        FinancialAct invoice1Item2 = this.createInvoiceItem();
        FinancialAct invoice1Item3 = this.createInvoiceItem();
        FinancialAct invoice1 = this.createInvoice("POSTED", invoice1Item1, invoice1Item2, invoice1Item3);
        FinancialAct invoice2Item1 = this.createInvoiceItem();
        FinancialAct invoice2 = this.createInvoice("POSTED", invoice2Item1);
        FinancialAct claim1 = (FinancialAct)this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).item(invoice1Item1, invoice1Item2).build();
        FinancialAct claim2 = (FinancialAct)this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).item(invoice1Item3).build();
        this.checkCurrentClaims(invoice1, claim1, claim2);
        this.checkCurrentClaims(invoice2, new FinancialAct[0]);
        claim1.setStatus("ACCEPTED");
        this.save((IMObject)claim1);
        this.checkCurrentClaims(invoice1, claim1, claim2);
        claim1.setStatus("SETTLED");
        this.save((IMObject)claim1);
        this.checkCurrentClaims(invoice1, claim2);
        claim1.setStatus("DECLINED");
        this.save((IMObject)claim1);
        this.checkCurrentClaims(invoice1, claim2);
        claim1.setStatus("CANCELLED");
        this.save((IMObject)claim1);
        this.checkCurrentClaims(invoice1, claim2);
    }

    @Test
    public void testGetCurrentGapClaims() {
        Act policy = this.rules.createPolicy(this.customer, this.patient, this.insuranceFactory.createInsurer(), null);
        this.save((IMObject)policy);
        User clinician = this.userFactory.createClinician();
        FinancialAct invoice1Item1 = this.createInvoiceItem();
        FinancialAct invoice1Item2 = this.createInvoiceItem();
        FinancialAct invoice1Item3 = this.createInvoiceItem();
        FinancialAct invoice1 = this.createInvoice("POSTED", invoice1Item1, invoice1Item2, invoice1Item3);
        FinancialAct invoice2Item1 = this.createInvoiceItem();
        FinancialAct invoice2 = this.createInvoice("POSTED", invoice2Item1);
        FinancialAct claim1 = (FinancialAct)this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).gapClaim(true).item(invoice1Item1, invoice1Item2).build();
        FinancialAct claim2 = (FinancialAct)this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).gapClaim(true).item(invoice1Item3).build();
        this.checkCurrentGapClaims(invoice1, claim1, claim2);
        this.checkCurrentGapClaims(invoice2, new FinancialAct[0]);
        claim1.setStatus("ACCEPTED");
        this.save((IMObject)claim1);
        this.checkCurrentGapClaims(invoice1, claim1, claim2);
        claim1.setStatus2("PENDING");
        this.save((IMObject)claim1);
        this.checkCurrentGapClaims(invoice1, claim1, claim2);
        claim1.setStatus2("RECEIVED");
        this.save((IMObject)claim1);
        this.checkCurrentGapClaims(invoice1, claim1, claim2);
        claim1.setStatus2("PAID");
        this.save((IMObject)claim1);
        this.checkCurrentGapClaims(invoice1, claim2);
        claim1.setStatus2("NOTIFIED");
        this.save((IMObject)claim1);
        this.checkCurrentGapClaims(invoice1, claim2);
        claim1.setStatus("SETTLED");
        this.save((IMObject)claim1);
        this.checkCurrentGapClaims(invoice1, claim2);
        claim1.setStatus("DECLINED");
        this.save((IMObject)claim1);
        this.checkCurrentGapClaims(invoice1, claim2);
        claim1.setStatus("CANCELLED");
        this.save((IMObject)claim1);
        this.checkCurrentGapClaims(invoice1, claim2);
    }

    @Test
    public void testCanChangePolicyNumber() {
        Act policy = this.rules.createPolicy(this.customer, this.patient, this.insuranceFactory.createInsurer(), null);
        this.save((IMObject)policy);
        Assert.assertTrue((boolean)this.rules.canChangePolicyNumber(policy));
        User clinician = this.userFactory.createClinician();
        FinancialAct claim = (FinancialAct)this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).item().diagnosis("VENOM_328", "Abcess", "328").add().build();
        Assert.assertEquals((Object)"PENDING", (Object)claim.getStatus());
        Assert.assertTrue((boolean)this.rules.canChangePolicyNumber(policy));
        claim.setStatus("POSTED");
        this.save((IMObject)claim);
        Assert.assertTrue((boolean)this.rules.canChangePolicyNumber(policy));
        claim.setStatus("SUBMITTED");
        this.save((IMObject)claim);
        Assert.assertFalse((boolean)this.rules.canChangePolicyNumber(policy));
        claim.setStatus("ACCEPTED");
        this.save((IMObject)claim);
        Assert.assertFalse((boolean)this.rules.canChangePolicyNumber(policy));
        claim.setStatus("CANCELLING");
        this.save((IMObject)claim);
        Assert.assertFalse((boolean)this.rules.canChangePolicyNumber(policy));
        claim.setStatus("CANCELLED");
        this.save((IMObject)claim);
        Assert.assertFalse((boolean)this.rules.canChangePolicyNumber(policy));
        claim.setStatus("SETTLED");
        this.save((IMObject)claim);
        Assert.assertFalse((boolean)this.rules.canChangePolicyNumber(policy));
        claim.setStatus("DECLINED");
        this.save((IMObject)claim);
        Assert.assertFalse((boolean)this.rules.canChangePolicyNumber(policy));
    }

    @Test
    public void testHasBenefitAmount() {
        FinancialAct claim = this.create("act.patientInsuranceClaim", FinancialAct.class);
        Assert.assertNull((Object)claim.getStatus2());
        Assert.assertFalse((boolean)this.rules.hasBenefitAmount(claim));
        claim.setStatus2("PENDING");
        Assert.assertFalse((boolean)this.rules.hasBenefitAmount(claim));
        claim.setStatus2("RECEIVED");
        Assert.assertTrue((boolean)this.rules.hasBenefitAmount(claim));
        claim.setStatus2("PAID");
        Assert.assertTrue((boolean)this.rules.hasBenefitAmount(claim));
        claim.setStatus2("NOTIFIED");
        Assert.assertTrue((boolean)this.rules.hasBenefitAmount(claim));
    }

    @Test
    public void testGetGapAmount() {
        FinancialAct claim = this.create("act.patientInsuranceClaim", FinancialAct.class);
        this.checkEquals(BigDecimal.ZERO, this.rules.getGapAmount(claim));
        IMObjectBean bean = this.getBean((IMObject)claim);
        bean.setValue("amount", (Object)1000);
        bean.setValue("benefitAmount", (Object)800);
        this.checkEquals(BigDecimal.valueOf(200L), this.rules.getGapAmount(claim));
        Assert.assertEquals((Object)BigDecimal.valueOf(300L), (Object)this.rules.getGapAmount(BigDecimal.valueOf(500L), BigDecimal.valueOf(200L)));
    }

    @Test
    public void testGetPriorTreatmentDate() {
        Party location = this.practiceFactory.createLocation();
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        User clinician = this.userFactory.createClinician();
        Entity service1 = this.insuranceFactory.createInsuranceService();
        Party insurer1 = (Party)this.insuranceFactory.newInsurer().insuranceService(service1).build();
        Party insurer2 = this.insuranceFactory.createInsurer();
        Party insurer3 = (Party)this.insuranceFactory.newInsurer().insuranceService(service1).build();
        Act policy1 = this.insuranceFactory.createPolicy(customer, patient, insurer1, "P1");
        FinancialAct claim1a = (FinancialAct)this.insuranceFactory.newClaim().policy(policy1).location(location).date("2021-02-01 10:30").item().treatmentDates("2021-01-01 09:00", "2021-01-01 10:00").add().item().treatmentDates("2021-02-01 09:00", "2021-02-01 10:00").add().clinician(clinician).claimHandler(clinician).status("SETTLED").build();
        Date claim1aTreatmentDate = this.getMinTreatementDate(claim1a);
        Assert.assertNull((Object)this.rules.getPriorTreatmentDate(patient, insurer1, (Act)claim1a, claim1aTreatmentDate));
        Assert.assertNull((Object)this.rules.getPriorTreatmentDate(patient, insurer2, (Act)claim1a, claim1aTreatmentDate));
        Assert.assertNull((Object)this.rules.getPriorTreatmentDate(patient, insurer3, (Act)claim1a, claim1aTreatmentDate));
        FinancialAct claim1b = (FinancialAct)this.insuranceFactory.newClaim().policy(policy1).location(location).date("2022-02-01 10:30").item().treatmentDates("2022-01-01 09:00", "2022-01-01 10:00").add().item().treatmentDates("2022-02-01 09:00", "2022-02-01 10:00").add().clinician(clinician).claimHandler(clinician).status("PENDING").build();
        Date claim1bTreatmentDate = this.getMinTreatementDate(claim1b);
        Assert.assertEquals((Object)TestHelper.getDatetime("2021-02-01 10:00"), (Object)this.rules.getPriorTreatmentDate(patient, insurer1, (Act)claim1b, claim1bTreatmentDate));
        Assert.assertNull((Object)this.rules.getPriorTreatmentDate(patient, insurer2, (Act)claim1b, claim1bTreatmentDate));
        Assert.assertEquals((Object)TestHelper.getDatetime("2021-02-01 10:00"), (Object)this.rules.getPriorTreatmentDate(patient, insurer3, (Act)claim1b, claim1bTreatmentDate));
        Act policy2 = this.insuranceFactory.createPolicy(customer, patient, insurer2, "P2");
        FinancialAct claim2 = (FinancialAct)this.insuranceFactory.newClaim().policy(policy2).location(location).date("2022-04-01 10:00").item().treatmentDates("2022-03-01 09:00", "2022-03-01 10:00").add().item().treatmentDates("2022-04-01 09:00", "2022-04-01 10:00").add().clinician(clinician).claimHandler(clinician).status("ACCEPTED").build();
        Date claim2TreatmentDate = this.getMinTreatementDate(claim2);
        Assert.assertEquals((Object)TestHelper.getDatetime("2021-02-01 10:00"), (Object)this.rules.getPriorTreatmentDate(patient, insurer1, (Act)claim2, claim2TreatmentDate));
        Assert.assertNull((Object)this.rules.getPriorTreatmentDate(patient, insurer2, (Act)claim2, claim2TreatmentDate));
        Assert.assertEquals((Object)TestHelper.getDatetime("2021-02-01 10:00"), (Object)this.rules.getPriorTreatmentDate(patient, insurer3, (Act)claim2, claim2TreatmentDate));
        Act policy3 = this.insuranceFactory.createPolicy(customer, patient, insurer3, "P3");
        FinancialAct claim3 = (FinancialAct)this.insuranceFactory.newClaim().policy(policy3).location(location).date("2023-04-01 11:00").item().treatmentDates("2023-03-01 09:00", "2023-03-01 10:00").add().item().treatmentDates("2023-04-01 09:00", "2023-04-01 10:00").add().clinician(clinician).claimHandler(clinician).status("SUBMITTED").build();
        Date claim3TreatmentDate = this.getMinTreatementDate(claim3);
        Assert.assertEquals((Object)TestHelper.getDatetime("2021-02-01 10:00"), (Object)this.rules.getPriorTreatmentDate(patient, insurer1, (Act)claim3, claim3TreatmentDate));
        Assert.assertNull((Object)this.rules.getPriorTreatmentDate(patient, insurer2, (Act)claim3, claim3TreatmentDate));
        Assert.assertEquals((Object)TestHelper.getDatetime("2021-02-01 10:00"), (Object)this.rules.getPriorTreatmentDate(patient, insurer3, (Act)claim3, claim3TreatmentDate));
        Assert.assertEquals((Object)TestHelper.getDatetime("2021-02-01 10:00"), (Object)this.rules.getPriorTreatmentDate(patient, insurer1, (Act)claim2, claim2TreatmentDate));
        Assert.assertNull((Object)this.rules.getPriorTreatmentDate(patient, insurer2, (Act)claim2, claim2TreatmentDate));
        Assert.assertEquals((Object)TestHelper.getDatetime("2021-02-01 10:00"), (Object)this.rules.getPriorTreatmentDate(patient, insurer3, (Act)claim2, claim2TreatmentDate));
    }

    private void checkCurrentClaims(FinancialAct invoice, FinancialAct ... claims) {
        List currentClaims = this.rules.getCurrentClaims(invoice);
        Assert.assertEquals((long)claims.length, (long)currentClaims.size());
        for (FinancialAct claim : claims) {
            Assert.assertTrue((boolean)currentClaims.contains(claim));
        }
    }

    private void checkCurrentGapClaims(FinancialAct invoice, FinancialAct ... claims) {
        List currentClaims = this.rules.getCurrentGapClaims(invoice);
        Assert.assertEquals((long)claims.length, (long)currentClaims.size());
        for (FinancialAct claim : claims) {
            Assert.assertTrue((boolean)currentClaims.contains(claim));
        }
    }

    private Date getMinTreatementDate(FinancialAct claim) {
        IMObjectBean bean = this.getBean((IMObject)claim);
        List conditions = bean.getTargets("items", Act.class);
        return conditions.stream().map(Act::getActivityStartTime).min(Comparator.naturalOrder()).orElse(null);
    }

    private FinancialAct createInvoice(String status, FinancialAct ... items) {
        return (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(this.customer)).clinician(this.userFactory.createClinician())).status(status)).add(items)).build();
    }

    private FinancialAct createInvoiceItem() {
        return (FinancialAct)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)this.accountFactory.newInvoiceItem().patient(this.patient)).clinician(this.userFactory.createClinician())).product(this.productFactory.createMedication())).quantity(1)).unitPrice(10)).discount(1)).tax(new BigDecimal("0.82"))).build(false);
    }

    private void checkPolicy(Act policy, Party customer, Party patient, Party insurer, String policyNumber) {
        IMObjectBean bean = this.getBean((IMObject)policy);
        Assert.assertEquals((Object)customer, (Object)bean.getTarget("customer"));
        Assert.assertEquals((Object)patient, (Object)bean.getTarget("patient"));
        Assert.assertEquals((Object)insurer, (Object)bean.getTarget("insurer"));
        Assert.assertEquals((Object)policyNumber, (Object)this.rules.getPolicyNumber(policy));
        Assert.assertNotNull((Object)policy.getActivityStartTime());
        Assert.assertNull((Object)policy.getActivityEndTime());
    }
}

