/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.till;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.till.AbstractTillRulesTest;
import org.openvpms.archetype.rules.finance.till.TillBalanceRules;
import org.openvpms.archetype.rules.finance.till.TillRuleException;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.ruleengine.RuleEngineException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;

public class TillBalanceRulesTestCase
extends AbstractTillRulesTest {
    private Entity till;
    private TillBalanceRules rules;

    @Before
    public void setUp() {
        this.till = TestHelper.createTill();
        this.save((IMObject)this.till);
        this.rules = new TillBalanceRules(this.getArchetypeService());
    }

    @Test
    public void testSaveUnclearedTillBalance() {
        FinancialAct balance1 = this.createBalance(this.till, "UNCLEARED");
        this.save((IMObject)balance1);
        this.save((IMObject)balance1);
        FinancialAct balance2 = this.createBalance(this.till, "UNCLEARED");
        try {
            this.save((IMObject)balance2);
            Assert.fail((String)"Expected save of second uncleared till balance to fail");
        }
        catch (RuleEngineException expected) {
            Throwable cause;
            for (cause = expected.getCause(); cause != null && !(cause instanceof TillRuleException); cause = cause.getCause()) {
            }
            Assert.assertNotNull((Object)cause);
            TillRuleException exception = (TillRuleException)cause;
            Assert.assertEquals((Object)TillRuleException.ErrorCode.UnclearedTillExists, (Object)exception.getErrorCode());
        }
    }

    @Test
    public void testSaveClearedTillBalance() {
        for (int i = 0; i < 3; ++i) {
            FinancialAct balance = this.createBalance(this.till, "CLEARED");
            this.save((IMObject)balance);
        }
    }

    @Test
    public void testCheckCanSaveTillBalanceWithInvalidAct() {
        FinancialAct act = this.create("act.bankDeposit", FinancialAct.class);
        try {
            this.rules.checkCanSaveTillBalance((Act)act);
        }
        catch (TillRuleException expected) {
            Assert.assertEquals((Object)TillRuleException.ErrorCode.InvalidTillArchetype, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testAddToTillBalance() {
        List<FinancialAct> payment = this.createPayment(this.till);
        List<FinancialAct> refund = this.createRefund(this.till);
        this.checkAddToTillBalance(this.till, payment, false, BigDecimal.ZERO);
        this.checkAddToTillBalance(this.till, refund, false, BigDecimal.ZERO);
        payment.get(0).setStatus("POSTED");
        this.checkAddToTillBalance(this.till, payment, false, BigDecimal.ONE);
        this.checkAddToTillBalance(this.till, refund, true, BigDecimal.ONE);
        refund.get(0).setStatus("POSTED");
        this.checkAddToTillBalance(this.till, refund, true, BigDecimal.ZERO);
        this.checkAddToTillBalance(this.till, payment, true, BigDecimal.ZERO);
        this.checkAddToTillBalance(this.till, refund, true, BigDecimal.ZERO);
        List<FinancialAct> payment2 = this.createPayment(this.till);
        payment2.get(0).setStatus("POSTED");
        this.checkAddToTillBalance(this.till, payment2, true, BigDecimal.ONE);
    }

    @Test
    public void testAddToTillBalanceWithInvalidAct() {
        FinancialAct act = this.create("act.bankDeposit", FinancialAct.class);
        try {
            this.rules.addToTill((Act)act);
        }
        catch (TillRuleException expected) {
            Assert.assertEquals((Object)TillRuleException.ErrorCode.CantAddActToTill, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testAddToTillBalanceWithNoTill() {
        FinancialAct act = this.create("act.customerAccountPayment", FinancialAct.class);
        act.setStatus("IN_PROGRESS");
        Party party = TestHelper.createCustomer();
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("customer", (IMObject)party);
        try {
            this.rules.addToTill((Act)act);
        }
        catch (TillRuleException expected) {
            Assert.assertEquals((Object)TillRuleException.ErrorCode.MissingTill, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testChangeTillBalanceAdjustment() {
        FinancialAct act = this.create("act.tillBalanceAdjustment", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("credit", (Object)true);
        bean.setTarget("till", (IMObject)this.till);
        bean.setValue("amount", (Object)BigDecimal.ONE);
        bean.save();
        FinancialAct balance = this.rules.getUnclearedBalance(this.till);
        Assert.assertNotNull((Object)balance);
        this.checkEquals(BigDecimal.ONE, balance.getTotal());
        bean.setValue("amount", (Object)BigDecimal.TEN);
        bean.save();
        balance = this.get(balance);
        this.checkEquals(BigDecimal.TEN, balance.getTotal());
    }
}

