/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.component.processor.ProcessorListener;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.archetype.rules.finance.statement.AbstractStatementTest;
import org.openvpms.archetype.rules.finance.statement.EndOfPeriodProcessor;
import org.openvpms.archetype.rules.finance.statement.Statement;
import org.openvpms.archetype.rules.finance.statement.StatementProcessor;
import org.openvpms.archetype.rules.finance.statement.StatementProcessorException;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;

public class StatementProcessorTestCase
extends AbstractStatementTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private LaboratoryRules laboratoryRules;

    @Test
    public void testStatementDate() {
        IArchetypeService service = this.getArchetypeService();
        Date now = new Date();
        try {
            new StatementProcessor(now, this.getPractice(), service, this.accountRules);
            Assert.fail((String)"Expected StatementProcessorException to be thrown");
        }
        catch (StatementProcessorException expected) {
            Assert.assertEquals((Object)StatementProcessorException.ErrorCode.InvalidStatementDate, (Object)expected.getErrorCode());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        try {
            new StatementProcessor(calendar.getTime(), this.getPractice(), service, this.accountRules);
        }
        catch (StatementProcessorException exception) {
            Assert.fail((String)("Construction failed with exception: " + (Object)((Object)exception)));
        }
    }

    @Test
    public void testProcessPreview() {
        Party customer = this.getCustomer();
        BigDecimal feeAmount = new BigDecimal("25.00");
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).accountFee(feeAmount, AccountType.FeeType.FIXED).accountFeeDays(30).accountFeeBalance(BigDecimal.ZERO).accountFeeMessage("Test Accounting Fee").build();
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        List<FinancialAct> invoices1 = this.createChargesInvoice(new BigDecimal(100));
        FinancialAct invoice1 = invoices1.get(0);
        invoice1.setActivityStartTime(this.getDatetime("2007-01-01 10:00:00"));
        this.save(invoices1);
        List<FinancialAct> invoices2 = this.createChargesInvoice(new BigDecimal(100));
        FinancialAct invoice2 = invoices2.get(0);
        invoice2.setActivityStartTime(this.getDatetime("2007-01-01 10:30:00"));
        invoice2.setStatus("COMPLETED");
        this.save(invoices2);
        List<FinancialAct> invoices3 = this.createChargesInvoice(new BigDecimal(10));
        FinancialAct invoice3 = invoices3.get(0);
        invoice3.setActivityStartTime(this.getDatetime("2007-01-01 11:00:00"));
        invoice3.setStatus("IN_PROGRESS");
        this.save(invoices3);
        List<FinancialAct> invoices4 = this.createChargesInvoice(new BigDecimal(10));
        FinancialAct invoice4 = invoices4.get(0);
        invoice4.setActivityStartTime(this.getDatetime("2007-01-03 11:00:00"));
        invoice4.setStatus("POSTED");
        this.save(invoices4);
        Date statementDate = this.getDate("2007-01-02");
        List<Act> acts = this.processStatement(statementDate, customer);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1, "POSTED");
        this.checkAct(acts.get(1), invoice2, "COMPLETED");
        statementDate = this.getDate("2007-02-05");
        acts = this.processStatement(statementDate, customer);
        Assert.assertEquals((long)4L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1, "POSTED");
        this.checkAct(acts.get(1), invoice2, "COMPLETED");
        this.checkAct(acts.get(2), invoice4, "POSTED");
        FinancialAct fee = (FinancialAct)acts.get(3);
        this.checkDebitAdjust((Act)fee, feeAmount, "Test Accounting Fee");
        Assert.assertTrue((boolean)fee.isNew());
    }

    @Test
    public void testProcessEndOfPeriod() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        BigDecimal feeAmount = new BigDecimal("25.00");
        customer.addClassification(this.createAccountType(30, DateUnits.DAYS, feeAmount));
        this.save((IMObject)customer);
        List<FinancialAct> invoices1 = this.createChargesInvoice(new BigDecimal(100));
        FinancialAct invoice1 = invoices1.get(0);
        invoice1.setActivityStartTime(this.getDatetime("2007-01-01 10:00:00"));
        this.save(invoices1);
        List<FinancialAct> invoices2 = this.createChargesInvoice(new BigDecimal(100));
        FinancialAct invoice2 = invoices2.get(0);
        invoice2.setActivityStartTime(this.getDatetime("2007-01-01 10:30:00"));
        invoice2.setStatus("COMPLETED");
        this.save(invoices2);
        List<FinancialAct> invoices3 = this.createChargesInvoice(new BigDecimal(10));
        FinancialAct invoice3 = invoices3.get(0);
        invoice3.setActivityStartTime(this.getDatetime("2007-01-01 11:00:00"));
        invoice3.setStatus("IN_PROGRESS");
        this.save(invoices3);
        List<FinancialAct> invoices4 = this.createChargesInvoice(new BigDecimal(10));
        FinancialAct invoice4 = invoices4.get(0);
        invoice4.setActivityStartTime(this.getDatetime("2007-02-06 11:00:00"));
        invoice4.setStatus("COMPLETED");
        this.save(invoices4);
        Date statementDate = this.getDate("2007-02-05");
        EndOfPeriodProcessor eop = new EndOfPeriodProcessor(statementDate, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        eop.process(customer);
        List<Act> acts = this.processStatement(statementDate, customer);
        Assert.assertEquals((long)3L, (long)acts.size());
        this.checkAct(acts.get(0), invoice1, "POSTED");
        this.checkAct(acts.get(1), invoice2, "POSTED");
        FinancialAct fee = (FinancialAct)acts.get(2);
        this.checkAct((Act)fee, "act.customerAccountDebitAdjust", feeAmount);
        Assert.assertFalse((boolean)fee.isNew());
        acts = this.processStatement(statementDate, customer, false, false);
        Assert.assertEquals((long)0L, (long)acts.size());
        acts = this.processStatement(statementDate, customer, true, true);
        Assert.assertEquals((long)3L, (long)acts.size());
        statementDate = this.getDate("2007-02-06");
        acts = this.processStatement(statementDate, customer);
        Assert.assertEquals((long)3L, (long)acts.size());
        this.checkAct(acts.get(0), "act.customerAccountOpeningBalance", new BigDecimal("225.00"));
        this.checkAct(acts.get(1), invoice4, "COMPLETED");
        this.checkDebitAdjust(acts.get(2), feeAmount, "Accounting Fee");
    }

    @Test
    public void testBackDatedStatements() {
        IArchetypeRuleService service = (IArchetypeRuleService)this.getArchetypeService();
        Party customer = this.getCustomer();
        BigDecimal amount = new BigDecimal(950);
        List<FinancialAct> invoices1 = this.createChargesInvoice(amount);
        FinancialAct invoice1 = invoices1.get(0);
        invoice1.setActivityStartTime(this.getDatetime("2007-12-29 10:00:00"));
        this.save(invoices1);
        Date statementDate1 = this.getDate("2007-12-31");
        EndOfPeriodProcessor eop = new EndOfPeriodProcessor(statementDate1, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        eop.process(customer);
        FinancialAct payment = this.createPayment(amount);
        payment.setActivityStartTime(this.getDatetime("2008-01-14 14:52:00"));
        this.save((IMObject)payment);
        Date statementDate3 = this.getDate("2008-01-01");
        List<Act> acts = this.processStatement(statementDate3, customer);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkAct(acts.get(0), "act.customerAccountOpeningBalance", amount);
        Date statementDate4 = this.getDate("2008-01-14");
        acts = this.processStatement(statementDate4, customer);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), "act.customerAccountOpeningBalance", amount);
        this.checkAct(acts.get(1), "act.customerAccountPayment", amount);
        Date statementDate5 = this.getDate("2008-01-31");
        eop = new EndOfPeriodProcessor(statementDate5, true, this.getPractice(), service, this.accountRules, this.laboratoryRules);
        eop.process(customer);
        Date statementDate6 = this.getDate("2008-02-01");
        acts = this.processStatement(statementDate6, customer);
        Assert.assertEquals((long)1L, (long)acts.size());
        this.checkAct(acts.get(0), "act.customerAccountOpeningBalance", BigDecimal.ZERO);
        this.processStatement(statementDate4, customer);
        acts = this.processStatement(statementDate4, customer);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), "act.customerAccountOpeningBalance", amount);
        this.checkAct(acts.get(1), "act.customerAccountPayment", amount);
    }

    @Test
    public void testProcessPreviewForOTCCustomer() {
        Party customer = this.create("party.organisationOTC", Party.class);
        customer.setName("Z OTC customer");
        this.save((IMObject)customer);
        this.setCustomer(customer);
        List<FinancialAct> counters1 = this.createChargesCounter(new BigDecimal(100));
        FinancialAct counter1 = counters1.get(0);
        counter1.setActivityStartTime(this.getDatetime("2007-01-01 10:00:00"));
        this.save(counters1);
        List<FinancialAct> counters2 = this.createChargesCounter(new BigDecimal(100));
        FinancialAct counter2 = counters2.get(0);
        counter2.setActivityStartTime(this.getDatetime("2007-01-01 10:30:00"));
        counter2.setStatus("COMPLETED");
        this.save(counters2);
        List<FinancialAct> counters3 = this.createChargesCounter(new BigDecimal(10));
        FinancialAct counter3 = counters3.get(0);
        counter3.setActivityStartTime(this.getDatetime("2007-01-01 11:00:00"));
        counter3.setStatus("IN_PROGRESS");
        this.save(counters3);
        List<FinancialAct> counters4 = this.createChargesCounter(new BigDecimal(10));
        FinancialAct counter4 = counters4.get(0);
        counter4.setActivityStartTime(this.getDatetime("2007-01-03 11:00:00"));
        counter4.setStatus("POSTED");
        this.save(counters4);
        Date statementDate = this.getDate("2007-01-02");
        List<Act> acts = this.processStatement(statementDate, customer);
        Assert.assertEquals((long)2L, (long)acts.size());
        this.checkAct(acts.get(0), counter1, "POSTED");
        this.checkAct(acts.get(1), counter2, "COMPLETED");
        statementDate = this.getDate("2007-02-05");
        acts = this.processStatement(statementDate, customer);
        Assert.assertEquals((long)3L, (long)acts.size());
        this.checkAct(acts.get(0), counter1, "POSTED");
        this.checkAct(acts.get(1), counter2, "COMPLETED");
        this.checkAct(acts.get(2), counter4, "POSTED");
    }

    private List<Act> processStatement(Date statementDate, Party customer) {
        return this.processStatement(statementDate, customer, false, true);
    }

    private List<Act> processStatement(Date statementDate, Party customer, boolean reprint, boolean expectStatement) {
        List<Act> acts;
        IArchetypeService service = this.getArchetypeService();
        StatementRules rules = new StatementRules(this.getPractice(), service, this.accountRules);
        StatementProcessor processor = new StatementProcessor(statementDate, this.getPractice(), service, this.accountRules);
        processor.setReprint(reprint);
        Listener listener = new Listener();
        processor.addListener((ProcessorListener)listener);
        processor.process(customer);
        List statements = listener.getStatements();
        if (expectStatement) {
            Assert.assertEquals((long)1L, (long)statements.size());
            Statement statement = (Statement)statements.get(0);
            Assert.assertEquals((Object)customer, (Object)statement.getCustomer());
            if (!statement.isPreview()) {
                rules.setPrinted(customer, statement.getStatementDate());
            }
            acts = this.getActs(statement);
        } else {
            Assert.assertEquals((long)0L, (long)statements.size());
            acts = Collections.emptyList();
        }
        return acts;
    }

    private List<Act> getActs(Statement event) {
        ArrayList<Act> result = new ArrayList<Act>();
        for (Act act : event.getActs()) {
            result.add(act);
        }
        return result;
    }

    private static class Listener
    implements ProcessorListener<Statement> {
        private final List<Statement> statements = new ArrayList<Statement>();

        private Listener() {
        }

        public void process(Statement statement) {
            this.statements.add(statement);
        }

        private List<Statement> getStatements() {
            return this.statements;
        }
    }
}

