/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.openvpms.archetype.rules.finance.account.AbstractCustomerAccountTest;
import org.openvpms.archetype.rules.finance.statement.StatementActHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;

public class AbstractStatementTest
extends AbstractCustomerAccountTest {
    private Party practice;

    protected Party getPractice() {
        if (this.practice == null) {
            this.practice = this.create("party.organisationPractice", Party.class);
            this.practice.setName("Z Test Practice");
        }
        return this.practice;
    }

    protected Date getDatetime(String value) {
        return TestHelper.getDatetime(value);
    }

    protected Date getDate(String value) {
        return TestHelper.getDate(value);
    }

    protected List<Act> getActs(Party customer, Date statementDate) {
        StatementActHelper helper = new StatementActHelper(this.getArchetypeService());
        Date timestamp = helper.getStatementTimestamp(statementDate);
        Iterable acts = helper.getActs(customer, timestamp);
        ArrayList<Act> result = new ArrayList<Act>();
        for (Act act : acts) {
            result.add(act);
        }
        return result;
    }

    protected List<Act> getPostedActs(Party customer, Date statementDate) {
        StatementActHelper helper = new StatementActHelper(this.getArchetypeService());
        Date open = helper.getOpeningBalanceTimestamp(customer, statementDate);
        Date close = helper.getClosingBalanceTimestamp(customer, statementDate, open);
        Iterable acts = helper.getPostedActs(customer, open, close, true);
        ArrayList<Act> result = new ArrayList<Act>();
        for (Act act : acts) {
            result.add(act);
        }
        return result;
    }

    protected void checkDebitAdjust(Act act, BigDecimal amount, String accountFeeMessage) {
        this.checkAct(act, "act.customerAccountDebitAdjust", amount);
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)accountFeeMessage, (Object)bean.getString("notes"));
    }

    protected void checkAct(Act act, String shortName, BigDecimal amount) {
        this.checkAct(act, shortName, amount, "POSTED");
    }

    protected void checkAct(Act act, String shortName, BigDecimal amount, String status) {
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)act, (String)shortName));
        Assert.assertEquals((Object)status, (Object)act.getStatus());
        this.checkEquals(amount, ((FinancialAct)act).getTotal());
    }

    protected void checkAct(Act act, FinancialAct expected, String status) {
        Assert.assertEquals((Object)expected, (Object)act);
        this.checkAct(act, expected.getArchetype(), expected.getTotal(), status);
    }

    protected void checkAct(List<Act> acts, FinancialAct expected, String status) {
        for (Act act : acts) {
            if (!act.equals(expected)) continue;
            this.checkAct(act, expected, status);
            return;
        }
        Assert.fail((String)("Expected act " + expected + " not found in acts"));
    }

    protected void checkOpeningBalance(Act act, BigDecimal amount) {
        this.checkAct(act, "act.customerAccountOpeningBalance", amount, "POSTED");
    }

    protected void checkClosingBalance(Act act, BigDecimal amount, BigDecimal overdue) {
        this.checkAct(act, "act.customerAccountClosingBalance", amount, "POSTED");
        IMObjectBean bean = this.getBean((IMObject)act);
        this.checkEquals(overdue, bean.getBigDecimal("overdueBalance"));
    }
}

