/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.AbstractCustomerAccountTest;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRuleException;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.account.PostStatus;
import org.openvpms.archetype.rules.finance.invoice.ChargeItemEventLinker;
import org.openvpms.archetype.rules.finance.till.TillBalanceRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.account.TestCashPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSPaymentBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSRefundBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.BuiltObjects;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderFactory;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorFactory;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorPaymentBuilder;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorRefundBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.business.service.ruleengine.RuleEngineException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.archetype.ValidationError;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerAccountRulesTestCase
extends AbstractCustomerAccountTest {
    @Autowired
    private PatientRules patientRules;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPaymentProcessorFactory paymentProcessorFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestReminderFactory reminderFactory;
    @Autowired
    private TestUserFactory userFactory;
    @Autowired
    private StockRules stockRules;
    private TillBalanceRules tillBalanceRules;

    @Before
    public void setUp() {
        this.tillBalanceRules = new TillBalanceRules(this.getArchetypeService());
    }

    @Test
    public void testCalculateTotal() {
        CustomerAccountRules rules = this.getRules();
        BigDecimal fixedPrice = BigDecimal.valueOf(10L);
        BigDecimal discount = BigDecimal.valueOf(5L);
        BigDecimal unitPrice1 = new BigDecimal("0.50");
        BigDecimal quantity = BigDecimal.valueOf(2L);
        this.checkEquals(BigDecimal.valueOf(6L), rules.calculateTotal(fixedPrice, unitPrice1, quantity, discount));
        this.checkEquals(BigDecimal.valueOf(-6L), rules.calculateTotal(fixedPrice, unitPrice1, quantity.negate(), discount));
        BigDecimal unitPrice2 = new BigDecimal("0.514");
        this.checkEquals(new BigDecimal("6.03"), rules.calculateTotal(fixedPrice, unitPrice2, quantity, discount));
        this.checkEquals(new BigDecimal("-6.03"), rules.calculateTotal(fixedPrice, unitPrice2, quantity.negate(), discount));
        BigDecimal fixedPrice3 = new BigDecimal("12.00");
        BigDecimal discount3 = new BigDecimal("106.08");
        BigDecimal unitPrice3 = new BigDecimal("37.63");
        BigDecimal quantity3 = new BigDecimal("2.50");
        this.checkEquals(BigDecimal.ZERO, rules.calculateTotal(fixedPrice3, unitPrice3, quantity3, discount3));
        this.checkEquals(BigDecimal.ZERO, rules.calculateTotal(fixedPrice3, unitPrice3, quantity3.negate(), discount3));
        this.checkEquals(BigDecimal.ZERO, rules.calculateTotal(fixedPrice, unitPrice1, BigDecimal.ZERO, discount));
        this.checkEquals(BigDecimal.ZERO, rules.calculateTotal(fixedPrice, unitPrice2, BigDecimal.ZERO, discount));
        this.checkEquals(BigDecimal.ZERO, rules.calculateTotal(fixedPrice3, unitPrice3, BigDecimal.ZERO, discount3));
        this.checkEquals(BigDecimal.ZERO, rules.calculateTotal(fixedPrice, unitPrice1, BigDecimal.ZERO.negate(), discount));
    }

    @Test
    public void testGetOpeningBalanceBeforeAndAfter() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        Assert.assertNull((Object)rules.getOpeningBalanceBefore(customer, new Date()));
        Assert.assertNull((Object)rules.getOpeningBalanceAfter(customer, new Date()));
        Date date1 = TestHelper.getDate("2018-01-01");
        Date date2 = TestHelper.getDate("2018-02-01");
        Date date3 = TestHelper.getDate("2018-03-01");
        FinancialAct open1 = rules.createOpeningBalance(customer, date1, BigDecimal.TEN);
        FinancialAct open2 = rules.createOpeningBalance(customer, date2, BigDecimal.TEN.negate());
        FinancialAct open3 = rules.createOpeningBalance(customer, date3, BigDecimal.ONE);
        this.save((IMObject[])new FinancialAct[]{open1, open2, open3});
        Assert.assertNull((Object)rules.getOpeningBalanceBefore(customer, date1));
        Assert.assertEquals((Object)open1, (Object)rules.getOpeningBalanceBefore(customer, date2));
        Assert.assertEquals((Object)open2, (Object)rules.getOpeningBalanceBefore(customer, date3));
        Assert.assertEquals((Object)open2, (Object)rules.getOpeningBalanceAfter(customer, date1));
        Assert.assertEquals((Object)open3, (Object)rules.getOpeningBalanceAfter(customer, date2));
        Assert.assertNull((Object)rules.getOpeningBalanceAfter(customer, date3));
    }

    @Test
    public void testCreateOpeningBalance() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        Date date = new Date();
        FinancialAct open1 = rules.createOpeningBalance(customer, date, BigDecimal.ZERO);
        FinancialAct open2 = rules.createOpeningBalance(customer, date, BigDecimal.TEN);
        FinancialAct open3 = rules.createOpeningBalance(customer, date, BigDecimal.TEN.negate());
        this.checkOpeningBalance(open1, customer, date, BigDecimal.ZERO, false);
        this.checkOpeningBalance(open2, customer, date, BigDecimal.TEN, false);
        this.checkOpeningBalance(open3, customer, date, BigDecimal.TEN, true);
    }

    @Test
    public void testCreateClosingBalance() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        Date date = new Date();
        FinancialAct close1 = rules.createClosingBalance(customer, date, BigDecimal.ZERO);
        FinancialAct close2 = rules.createClosingBalance(customer, date, BigDecimal.TEN);
        FinancialAct close3 = rules.createClosingBalance(customer, date, BigDecimal.TEN.negate());
        this.checkClosingBalance(close1, customer, date, BigDecimal.ZERO, true);
        this.checkClosingBalance(close2, customer, date, BigDecimal.TEN, true);
        this.checkClosingBalance(close3, customer, date, BigDecimal.TEN, false);
    }

    @Test
    public void testAddChargesInvoiceToBalance() {
        this.checkAddToBalance(this.createChargesInvoice(new BigDecimal(100)));
    }

    @Test
    public void testAddChargesCounterToBalance() {
        this.checkAddToBalance(this.createChargesCounter(new BigDecimal(100)));
    }

    @Test
    public void testAddChargesCreditToBalance() {
        this.checkAddToBalance(this.createChargesCredit(new BigDecimal(100)));
    }

    @Test
    public void testAddPaymentToBalance() {
        this.checkAddToBalance(this.createPayment(new BigDecimal(100)));
    }

    @Test
    public void testAddRefundToBalance() {
        this.checkAddToBalance(this.createRefund(new BigDecimal(100)));
    }

    @Test
    public void testAddCreditAdjustToBalance() {
        this.checkAddToBalance(this.createCreditAdjust(new BigDecimal(100)));
    }

    @Test
    public void testAddDebitAdjustToBalance() {
        this.checkAddToBalance(this.createDebitAdjust(new BigDecimal(100)));
    }

    @Test
    public void testAddInitialBalanceToBalance() {
        this.checkAddToBalance(this.createInitialBalance(new BigDecimal(100)));
    }

    @Test
    public void testAddBadDebtToBalance() {
        this.checkAddToBalance(this.createBadDebt(new BigDecimal(100)));
    }

    @Test
    public void testGetBalanceForInvoice() {
        Party customer = this.getCustomer();
        BigDecimal amount = new BigDecimal(100);
        this.save(this.createChargesInvoice(amount));
        this.checkEquals(amount, this.getRules().getBalance(customer));
    }

    @Test
    public void testGetBalanceForCredit() {
        Party customer = this.getCustomer();
        BigDecimal amount = new BigDecimal(100);
        this.save(this.createChargesCredit(amount));
        this.checkEquals(amount.negate(), this.getRules().getBalance(customer));
    }

    @Test
    public void testGetBalanceForNegativeInvoice() {
        Party customer = this.getCustomer();
        BigDecimal amount = new BigDecimal(-100);
        this.save(this.createChargesInvoice(amount));
        this.checkEquals(amount, this.getRules().getBalance(customer));
    }

    @Test
    public void testGetBalanceForNegativeCredit() {
        Party customer = this.getCustomer();
        BigDecimal amount = new BigDecimal(-100);
        List<FinancialAct> invoiceActs = this.createChargesCredit(amount);
        this.save(invoiceActs);
        this.checkEquals(amount.negate(), this.getRules().getBalance(customer));
    }

    @Test
    public void testGetBalanceForChargesInvoiceAndPayment() {
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        List<FinancialAct> payment = Collections.singletonList(this.createPayment(amount));
        this.checkCalculateBalanceForSameAmount(invoice, payment);
    }

    @Test
    public void testGetBalanceForChargesCounterAndPayment() {
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> counter = this.createChargesCounter(amount);
        List<FinancialAct> payment = Collections.singletonList(this.createPayment(amount));
        this.checkCalculateBalanceForSameAmount(counter, payment);
    }

    @Test
    public void testGetBalanceForChargesInvoiceAndCredit() {
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        List<FinancialAct> credit = this.createChargesCredit(amount);
        this.checkCalculateBalanceForSameAmount(invoice, credit);
    }

    @Test
    public void testGetBalanceForRefundAndPayment() {
        BigDecimal amount = new BigDecimal(100);
        FinancialAct refund = this.createRefund(amount);
        FinancialAct payment = this.createPayment(amount);
        this.checkCalculateBalanceForSameAmount(refund, payment);
    }

    @Test
    public void testGetBalanceForDebitAndCreditAdjust() {
        BigDecimal amount = new BigDecimal(100);
        FinancialAct debit = this.createDebitAdjust(amount);
        FinancialAct credit = this.createCreditAdjust(amount);
        this.checkCalculateBalanceForSameAmount(debit, credit);
    }

    @Test
    public void testGetBalanceForInitialBalanceAndBadDebt() {
        BigDecimal amount = new BigDecimal(100);
        FinancialAct debit = this.createInitialBalance(amount);
        FinancialAct credit = this.createBadDebt(amount);
        this.checkCalculateBalanceForSameAmount(debit, credit);
    }

    @Test
    public void testGetBalance() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        FinancialAct invoice = this.createInvoice(new Date(), 100);
        this.checkEquals(100, rules.getBalance(customer));
        IMObjectBean bean = this.getBean((IMObject)invoice);
        Assert.assertEquals((Object)customer, (Object)bean.getTarget("accountBalance"));
        invoice = this.get(invoice);
        this.checkEquals(100, invoice.getTotal());
        this.checkAllocation(invoice, 0, new FinancialAct[0]);
        FinancialAct payment1 = this.createPayment(60);
        this.save((IMObject)payment1);
        this.checkEquals(40, rules.getBalance(customer));
        invoice = this.get(invoice);
        payment1 = this.get(payment1);
        this.checkEquals(100, invoice.getTotal());
        this.checkAllocation(invoice, 60, payment1);
        this.checkEquals(60, payment1.getTotal());
        this.checkAllocation(payment1, 60, invoice);
        FinancialAct payment2 = this.createPayment(40);
        this.save((IMObject)payment2);
        this.checkEquals(BigDecimal.ZERO, rules.getBalance(customer));
        invoice = this.get(invoice);
        payment2 = this.get(payment2);
        this.checkEquals(100, invoice.getTotal());
        this.checkAllocation(invoice, 100, payment1, payment2);
        this.checkEquals(40, payment2.getTotal());
        this.checkAllocation(payment2, 40, invoice);
    }

    @Test
    public void testGetRunningBalance() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        BigDecimal hundred = new BigDecimal(100);
        BigDecimal sixty = new BigDecimal(60);
        BigDecimal forty = new BigDecimal(40);
        BigDecimal ten = new BigDecimal(10);
        BigDecimal five = new BigDecimal(5);
        List<FinancialAct> invoice = this.createChargesInvoice(hundred);
        this.save(invoice);
        this.checkEquals(hundred, rules.getBalance(customer, BigDecimal.ZERO, true));
        this.checkEquals(BigDecimal.ZERO, rules.getBalance(customer, BigDecimal.ZERO, false));
        this.checkEquals(forty, rules.getBalance(customer, sixty, true));
        FinancialAct payment1 = this.createPayment(new BigDecimal("110.0"));
        this.save((IMObject)payment1);
        this.checkEquals(BigDecimal.ZERO, rules.getBalance(customer, BigDecimal.ZERO, true));
        this.checkEquals(ten, rules.getBalance(customer, BigDecimal.ZERO, false));
        this.checkEquals(five, rules.getBalance(customer, five, false));
    }

    @Test
    public void testGetCurrentOverdueBalance() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        customer.addClassification(this.createAccountType(30, DateUnits.DAYS));
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal(100);
        Date startTime = TestHelper.getDate("2007-01-01");
        List<FinancialAct> invoice = this.createChargesInvoice(amount, startTime);
        this.save(invoice);
        BigDecimal overdue = rules.getOverdueBalance(customer, startTime);
        this.checkEquals(BigDecimal.ZERO, overdue);
        Date now = DateRules.getDate((Date)startTime, (int)30, (DateUnits)DateUnits.DAYS);
        overdue = rules.getOverdueBalance(customer, now);
        this.checkEquals(BigDecimal.ZERO, overdue);
        now = DateRules.getDate((Date)now, (int)1, (DateUnits)DateUnits.DAYS);
        overdue = rules.getOverdueBalance(customer, now);
        this.checkEquals(amount, overdue);
        List<FinancialAct> creditActs = this.createChargesCredit(new BigDecimal(150));
        FinancialAct credit = creditActs.get(0);
        credit.setActivityStartTime(startTime);
        this.save(creditActs);
        this.checkBalance(new BigDecimal(-50));
        overdue = rules.getOverdueBalance(customer, now);
        this.checkEquals(BigDecimal.ZERO, overdue);
    }

    @Test
    public void testGetCurrentOverdueBalanceForNegativeInvoice() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        customer.addClassification(this.createAccountType(30, DateUnits.DAYS));
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal(-100);
        Date startTime = TestHelper.getDate("2007-01-01");
        List<FinancialAct> invoice = this.createChargesInvoice(amount, startTime);
        this.save(invoice);
        this.checkEquals(amount, rules.getBalance(customer));
        this.checkEquals(BigDecimal.ZERO, rules.getOverdueBalance(customer, startTime));
        Date now = DateRules.getDate((Date)startTime, (int)31, (DateUnits)DateUnits.DAYS);
        this.checkEquals(BigDecimal.ZERO, rules.getOverdueBalance(customer, now));
    }

    @Test
    public void testGetCurrentOverdueBalanceForNegativeCredit() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        customer.addClassification(this.createAccountType(30, DateUnits.DAYS));
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal(-100);
        Date startTime = TestHelper.getDate("2007-01-01");
        List<FinancialAct> credit = this.createChargesCredit(amount);
        credit.get(0).setActivityStartTime(startTime);
        this.save(credit);
        this.checkEquals(amount.negate(), rules.getBalance(customer));
        this.checkEquals(BigDecimal.ZERO, rules.getOverdueBalance(customer, startTime));
        Date now = DateRules.getDate((Date)startTime, (int)31, (DateUnits)DateUnits.DAYS);
        this.checkEquals(amount.negate(), rules.getOverdueBalance(customer, now));
    }

    @Test
    public void testGetOverdueBalance() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        customer.addClassification(this.createAccountType(30, DateUnits.DAYS));
        this.save((IMObject)customer);
        BigDecimal amount = new BigDecimal(100);
        Date startTime = TestHelper.getDate("2007-01-01");
        this.createInvoice(startTime, 50);
        this.createInvoice(startTime, 50);
        Date overdueDate = rules.getOverdueDate(customer, startTime);
        BigDecimal overdue = rules.getOverdueBalance(customer, startTime, overdueDate);
        this.checkEquals(BigDecimal.ZERO, overdue);
        Date now = DateRules.getDate((Date)startTime, (int)30, (DateUnits)DateUnits.DAYS);
        overdueDate = rules.getOverdueDate(customer, now);
        overdue = rules.getOverdueBalance(customer, now, overdueDate);
        this.checkEquals(BigDecimal.ZERO, overdue);
        Date statementDate = DateRules.getDate((Date)now, (int)1, (DateUnits)DateUnits.DAYS);
        overdueDate = rules.getOverdueDate(customer, statementDate);
        overdue = rules.getOverdueBalance(customer, statementDate, overdueDate);
        this.checkEquals(amount, overdue);
        now = DateRules.getDate((Date)statementDate, (int)1, (DateUnits)DateUnits.DAYS);
        this.createCredit(new BigDecimal(40), now);
        this.createCredit(new BigDecimal(35), now);
        this.createCredit(new BigDecimal(75), now);
        this.checkBalance(new BigDecimal(-50));
        overdue = rules.getOverdueBalance(customer, statementDate, overdueDate);
        this.checkEquals(amount, overdue);
    }

    @Test
    public void testGetOverdueBalanceForInitialBalance() {
        BigDecimal plus100 = BigDecimal.valueOf(100L);
        this.checkOverdueBalance(Collections.singletonList(this.createInitialBalance(plus100)), plus100, plus100);
    }

    @Test
    public void testGetOverdueBalanceForCounterSale() {
        BigDecimal plus100 = BigDecimal.valueOf(100L);
        this.checkOverdueBalance(this.createChargesCounter(plus100), plus100, plus100);
    }

    @Test
    public void testGetOverdueBalanceForDebitAdjust() {
        BigDecimal plus100 = BigDecimal.valueOf(100L);
        this.checkOverdueBalance(Collections.singletonList(this.createDebitAdjust(plus100)), plus100, plus100);
    }

    @Test
    public void testGetOverdueBalanceForPositiveInvoice() {
        BigDecimal plus100 = BigDecimal.valueOf(100L);
        this.checkOverdueBalance(this.createChargesInvoice(plus100), plus100, plus100);
    }

    @Test
    public void testGetOverdueBalanceForNegativeInvoice() {
        BigDecimal minus100 = BigDecimal.valueOf(-100L);
        this.checkOverdueBalance(this.createChargesInvoice(minus100), minus100, BigDecimal.ZERO);
    }

    @Test
    public void testGetOverdueBalanceForPositiveCredit() {
        BigDecimal plus100 = BigDecimal.valueOf(100L);
        this.checkOverdueBalance(this.createChargesCredit(plus100), plus100.negate(), BigDecimal.ZERO);
    }

    @Test
    public void testGetOverdueBalanceForNegativeCredit() {
        BigDecimal plus100 = BigDecimal.valueOf(100L);
        BigDecimal minus100 = BigDecimal.valueOf(-100L);
        this.checkOverdueBalance(this.createChargesCredit(minus100), plus100, plus100);
    }

    @Test
    public void testGetOverdueBalanceForRefund() {
        BigDecimal plus100 = BigDecimal.valueOf(100L);
        this.checkOverdueBalance(Collections.singletonList(this.createRefund(plus100)), plus100, plus100);
    }

    @Test
    public void testGetOverdueBalanceForCreditAdjustment() {
        BigDecimal plus100 = BigDecimal.valueOf(100L);
        this.checkOverdueBalance(Collections.singletonList(this.createCreditAdjust(plus100)), plus100.negate(), BigDecimal.ZERO);
    }

    @Test
    public void testGetOverdueBalanceForBadDebt() {
        BigDecimal plus100 = BigDecimal.valueOf(100L);
        this.checkOverdueBalance(Collections.singletonList(this.createBadDebt(plus100)), plus100.negate(), BigDecimal.ZERO);
    }

    @Test
    public void testGetOverdueBalanceForPayment() {
        BigDecimal plus100 = BigDecimal.valueOf(100L);
        this.checkOverdueBalance(Collections.singletonList(this.createPayment(plus100)), plus100.negate(), BigDecimal.ZERO);
    }

    @Test
    public void testGetUnbilledAmount() {
        CustomerAccountRules rules = this.getRules();
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoices = this.createChargesInvoice(amount);
        List<FinancialAct> counters = this.createChargesCounter(amount);
        List<FinancialAct> credits = this.createChargesCredit(amount);
        FinancialAct invoice = invoices.get(0);
        invoice.setStatus("IN_PROGRESS");
        FinancialAct counter = counters.get(0);
        counter.setStatus("IN_PROGRESS");
        FinancialAct credit = credits.get(0);
        credit.setStatus("IN_PROGRESS");
        this.checkEquals(BigDecimal.ZERO, rules.getUnbilledAmount(this.getCustomer()));
        this.save(invoices);
        this.checkEquals(amount, rules.getUnbilledAmount(this.getCustomer()));
        this.save(counters);
        this.checkEquals(amount.multiply(new BigDecimal(2)), rules.getUnbilledAmount(this.getCustomer()));
        this.save(credits);
        this.checkEquals(amount, rules.getUnbilledAmount(this.getCustomer()));
        credit.setStatus("POSTED");
        this.save((IMObject)credit);
        this.checkEquals(amount.multiply(new BigDecimal(2)), rules.getUnbilledAmount(this.getCustomer()));
        counter.setStatus("POSTED");
        this.save((IMObject)counter);
        this.checkEquals(amount, rules.getUnbilledAmount(this.getCustomer()));
        invoice.setStatus("POSTED");
        this.save((IMObject)invoice);
        this.checkEquals(BigDecimal.ZERO, rules.getUnbilledAmount(this.getCustomer()));
    }

    @Test
    public void testReverse() {
        this.checkReverse(this.createInitialBalance(new BigDecimal(25)), "act.customerAccountCreditAdjust");
        this.checkReverseInvoice();
        this.checkReverseCharge(this.createChargesCredit(new BigDecimal(50)), "act.customerAccountChargesInvoice", "act.customerAccountInvoiceItem");
        this.checkReverseCharge(this.createChargesCounter(new BigDecimal(40)), "act.customerAccountChargesCredit", "act.customerAccountCreditItem");
        this.checkReverse(this.createPaymentCash(new BigDecimal(75)), "act.customerAccountRefund", "act.customerAccountRefundCash", false, null, new BigDecimal(75));
        this.checkReverse(this.createPaymentCheque(new BigDecimal(23)), "act.customerAccountRefund", "act.customerAccountRefundCheque", false, null, null);
        this.checkReverse(this.createPaymentCredit(new BigDecimal(24)), "act.customerAccountRefund", "act.customerAccountRefundCredit", false, null, null);
        this.checkReverse(this.createPaymentDiscount(new BigDecimal(25)), "act.customerAccountRefund", "act.customerAccountRefundDiscount", false, null, null);
        this.checkReverse(this.createPaymentEFT(new BigDecimal(26)), "act.customerAccountRefund", "act.customerAccountRefundEFT", false, null, null);
        this.checkReverse(this.createPaymentOther(new BigDecimal(26)), "act.customerAccountRefund", "act.customerAccountRefundOther", false, null, null);
        this.checkReverse(this.createRefundCash(BigDecimal.TEN), "act.customerAccountPayment", "act.customerAccountPaymentCash", false, null, BigDecimal.TEN);
        this.checkReverse(this.createRefundCheque(new BigDecimal(11)), "act.customerAccountPayment", "act.customerAccountPaymentCheque", false, null, null);
        this.checkReverse(this.createRefundCredit(new BigDecimal(12)), "act.customerAccountPayment", "act.customerAccountPaymentCredit", false, null, null);
        this.checkReverse(this.createRefundDiscount(new BigDecimal(13)), "act.customerAccountPayment", "act.customerAccountPaymentDiscount", false, null, null);
        this.checkReverse(this.createRefundEFT(new BigDecimal(15)), "act.customerAccountPayment", "act.customerAccountPaymentEFT", false, null, null);
        this.checkReverse(this.createRefundOther(new BigDecimal(15)), "act.customerAccountPayment", "act.customerAccountPaymentOther", false, null, null);
        this.checkReverse(this.createDebitAdjust(new BigDecimal(5)), "act.customerAccountCreditAdjust");
        this.checkReverse(this.createCreditAdjust(new BigDecimal(15)), "act.customerAccountDebitAdjust");
        this.checkReverse(this.createBadDebt(new BigDecimal(20)), "act.customerAccountDebitAdjust");
    }

    @Test
    public void testReverseNegativeInvoice() {
        this.checkReversalOfNegativeCharge("act.customerAccountChargesInvoice", "act.customerAccountInvoiceItem", "act.customerAccountChargesCredit", "act.customerAccountCreditItem");
    }

    @Test
    public void testReverseInvoiceWithNegativeLineItem() {
        this.checkReversalOfChargeWithNegativeQuantity("act.customerAccountChargesInvoice", "act.customerAccountInvoiceItem", "act.customerAccountChargesCredit", "act.customerAccountCreditItem");
    }

    @Test
    public void testReverseNegativeCredit() {
        this.checkReversalOfNegativeCharge("act.customerAccountChargesCredit", "act.customerAccountCreditItem", "act.customerAccountChargesInvoice", "act.customerAccountInvoiceItem");
    }

    @Test
    public void testReverseCreditWithNegativeLineItem() {
        this.checkReversalOfChargeWithNegativeQuantity("act.customerAccountChargesCredit", "act.customerAccountCreditItem", "act.customerAccountChargesInvoice", "act.customerAccountInvoiceItem");
    }

    @Test
    public void testReverseNegativeCounterSale() {
        this.checkReversalOfNegativeCharge("act.customerAccountChargesCounter", "act.customerAccountCounterItem", "act.customerAccountChargesCredit", "act.customerAccountCreditItem");
    }

    @Test
    public void testReverseCounterSaleWithNegativeLineItem() {
        this.checkReversalOfChargeWithNegativeQuantity("act.customerAccountChargesCounter", "act.customerAccountCounterItem", "act.customerAccountChargesCredit", "act.customerAccountCreditItem");
    }

    @Test
    public void testReverseAllocated() {
        CustomerAccountRules rules = this.getRules();
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        this.save(invoice);
        FinancialAct payment = this.createPayment(amount);
        this.save((IMObject)payment);
        this.checkAllocation(invoice.get(0), amount, payment);
        this.checkBalance(BigDecimal.ZERO);
        FinancialAct reversal = rules.reverse(payment, new Date(), "Test reversal", null, false);
        this.checkAllocation(reversal, amount, payment);
        this.checkAllocation(invoice.get(0), BigDecimal.ZERO, new FinancialAct[0]);
        this.checkBalance(amount);
    }

    @Test
    public void testReverseUnallocated() {
        CustomerAccountRules rules = this.getRules();
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        this.save(invoice);
        this.checkBalance(amount);
        FinancialAct reversal = rules.reverse(invoice.get(0), new Date(), "Test reversal", null, false);
        this.checkBalance(BigDecimal.ZERO);
        this.checkAllocation(invoice.get(0), amount, reversal);
    }

    @Test
    public void testReversePartiallyAllocated() {
        CustomerAccountRules rules = this.getRules();
        BigDecimal amount = new BigDecimal(100);
        BigDecimal sixty = new BigDecimal(60);
        BigDecimal forty = new BigDecimal(40);
        List<FinancialAct> invoices = this.createChargesInvoice(amount);
        this.save(invoices);
        FinancialAct invoice = invoices.get(0);
        this.checkAllocation(invoice, BigDecimal.ZERO, new FinancialAct[0]);
        FinancialAct payment = this.createPayment(sixty);
        this.save((IMObject)payment);
        this.checkAllocation(invoice, sixty, payment);
        this.checkBalance(forty);
        FinancialAct reversal = rules.reverse(payment, new Date(), "Test reversal", null, false);
        this.checkAllocation(reversal, sixty, payment);
        this.checkAllocation(invoice, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkBalance(amount);
    }

    @Test
    public void testReverseMultiplePaymentsToInvoice() {
        CustomerAccountRules rules = this.getRules();
        List<FinancialAct> invoices = this.createChargesInvoice(MathRules.ONE_HUNDRED);
        this.save(invoices);
        FinancialAct invoice = invoices.get(0);
        this.checkBalance(MathRules.ONE_HUNDRED);
        this.checkAllocation(invoice, BigDecimal.ZERO, new FinancialAct[0]);
        BigDecimal fifty = new BigDecimal(50);
        FinancialAct payment1 = this.createPayment(fifty);
        this.save((IMObject)payment1);
        FinancialAct payment2 = this.createPayment(fifty);
        this.save((IMObject)payment2);
        invoice = this.checkAllocation(invoice, MathRules.ONE_HUNDRED, payment1, payment2);
        this.checkBalance(BigDecimal.ZERO);
        FinancialAct reversal1 = rules.reverse(payment1, new Date(), "Test reversal 1", null, false);
        FinancialAct reversal2 = rules.reverse(payment2, new Date(), "Test reversal 2", null, false);
        this.checkAllocation(payment1, fifty, reversal1);
        this.checkAllocation(payment2, fifty, reversal2);
        invoice = this.checkAllocation(invoice, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkBalance(MathRules.ONE_HUNDRED);
        FinancialAct reversal3 = rules.reverse(invoice, new Date(), "Test reversal 3", null, false);
        this.checkAllocation(invoice, MathRules.ONE_HUNDRED, reversal3);
        this.checkAllocation(payment1, fifty, reversal1);
        this.checkAllocation(payment2, fifty, reversal2);
        this.checkBalance(BigDecimal.ZERO);
    }

    @Test
    public void testReversePaymentToMultipleInvoices() {
        CustomerAccountRules rules = this.getRules();
        BigDecimal forty = new BigDecimal(40);
        BigDecimal sixty = new BigDecimal(60);
        List<FinancialAct> invoices1 = this.createChargesInvoice(forty);
        this.save(invoices1);
        FinancialAct invoice1 = invoices1.get(0);
        List<FinancialAct> invoices2 = this.createChargesInvoice(sixty);
        this.save(invoices2);
        FinancialAct invoice2 = invoices2.get(0);
        this.checkBalance(MathRules.ONE_HUNDRED);
        this.checkAllocation(invoice1, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkAllocation(invoice2, BigDecimal.ZERO, new FinancialAct[0]);
        FinancialAct payment = this.createPayment(MathRules.ONE_HUNDRED);
        this.save((IMObject)payment);
        invoice1 = this.checkAllocation(invoice1, forty, payment);
        invoice2 = this.checkAllocation(invoice2, sixty, payment);
        this.checkBalance(BigDecimal.ZERO);
        FinancialAct reversal = rules.reverse(payment, new Date(), "Test reversal", null, false);
        this.checkAllocation(payment, MathRules.ONE_HUNDRED, reversal);
        this.checkAllocation(invoice1, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkAllocation(invoice2, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkBalance(MathRules.ONE_HUNDRED);
    }

    @Test
    public void testReversalDoesntImpactGapClaim() {
        List<FinancialAct> invoice1Acts = this.createChargesInvoice(BigDecimal.TEN, DateRules.getYesterday());
        this.save(invoice1Acts);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        this.checkBalance(BigDecimal.TEN);
        Act policy = this.insuranceFactory.createPolicy(this.getCustomer(), this.getPatient(), this.insuranceFactory.createInsurer(), "12345");
        User clinician = this.userFactory.createClinician();
        this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).gapClaim(true).item(item1).build();
        List<FinancialAct> invoice2Acts = this.createChargesInvoice(BigDecimal.TEN);
        this.save(invoice2Acts);
        FinancialAct invoice2 = invoice2Acts.get(0);
        this.checkBalance(BigDecimal.valueOf(20L));
        FinancialAct payment = this.createPayment(BigDecimal.TEN);
        this.save((IMObject)payment);
        this.checkBalance(BigDecimal.TEN);
        this.checkAllocation(invoice1, BigDecimal.ZERO, new FinancialAct[0]);
        invoice2 = this.checkAllocation(invoice2, BigDecimal.TEN, payment);
        this.checkAllocation(payment, BigDecimal.TEN, invoice2);
        FinancialAct reversal = this.getRules().reverse(invoice2, new Date());
        this.checkAllocation(invoice2, BigDecimal.TEN, reversal);
        this.checkBalance(BigDecimal.ZERO);
        this.checkAllocation(invoice1, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkAllocation(payment, BigDecimal.ZERO, new FinancialAct[0]);
    }

    @Test
    public void testReversalDoesntAffectPostedClaim() {
        this.checkReversalDoesntAffectClaim("POSTED");
    }

    @Test
    public void testReversalDoesntAffectSubmittedClaim() {
        this.checkReversalDoesntAffectClaim("SUBMITTED");
    }

    @Test
    public void testReversalDoesntAffectAcceptedClaim() {
        this.checkReversalDoesntAffectClaim("ACCEPTED");
    }

    @Test
    public void testReversalDoesntAffectPreSettledClaim() {
        this.checkReversalDoesntAffectClaim("PRE_SETTLED");
    }

    @Test
    public void testReversalDoesntAffectSettledClaim() {
        this.checkReversalDoesntAffectClaim("SETTLED");
    }

    @Test
    public void testReversalDoesntAffectDeclinedClaim() {
        this.checkReversalDoesntAffectClaim("DECLINED");
    }

    @Test
    public void testReversalCanAffectPendingClaim() {
        this.checkReversalCanAffectClaim("PENDING");
    }

    @Test
    public void testReversalCanAffectCancellingClaim() {
        this.checkReversalCanAffectClaim("CANCELLING");
    }

    @Test
    public void testReversalCanAffectCancelledClaim() {
        this.checkReversalCanAffectClaim("CANCELLED");
    }

    @Test
    public void testReversalAllocationOrder() {
        FinancialAct invoice1 = this.createInvoice(DateRules.getYesterday(), BigDecimal.TEN, "POSTED");
        FinancialAct invoice2 = this.createInvoice(DateRules.getToday(), BigDecimal.TEN, "POSTED");
        FinancialAct reverse = this.getRules().reverse(invoice2, new Date());
        this.checkAllocation(invoice1, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkAllocation(invoice2, BigDecimal.TEN, reverse);
        this.checkAllocation(reverse, BigDecimal.TEN, invoice2);
    }

    @Test
    public void testReversalAllocationOrder2() {
        FinancialAct invoice1 = this.createInvoice(DateRules.getYesterday(), BigDecimal.TEN, "POSTED");
        BigDecimal five = BigDecimal.valueOf(5L);
        FinancialAct invoice2 = this.createInvoice(DateRules.getToday(), BigDecimal.TEN, "POSTED");
        FinancialAct invoice3 = this.createInvoice(new Date(), BigDecimal.TEN, "POSTED");
        FinancialAct payment = this.createPayment(five);
        this.save((IMObject)payment);
        invoice1 = this.checkAllocation(invoice1, five, payment);
        this.checkAllocation(invoice2, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkAllocation(invoice3, BigDecimal.ZERO, new FinancialAct[0]);
        FinancialAct reverse = this.getRules().reverse(invoice1, new Date());
        this.checkAllocation(invoice1, BigDecimal.TEN, reverse);
        this.checkAllocation(reverse, BigDecimal.TEN, invoice1);
        this.checkAllocation(invoice2, five, payment);
        this.checkAllocation(invoice3, BigDecimal.ZERO, new FinancialAct[0]);
    }

    @Test
    public void testReverseTwice() {
        CustomerAccountRules rules = this.getRules();
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        this.save(invoice);
        this.checkBalance(amount);
        rules.reverse(invoice.get(0), new Date(), "Test reversal", null, false);
        this.checkBalance(BigDecimal.ZERO);
        try {
            rules.reverse(invoice.get(0), new Date(), "Test reversal 2", null, false);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testReverseHide() {
        List<FinancialAct> invoice1 = this.createChargesInvoice(new BigDecimal(100));
        this.save(invoice1);
        this.checkReverse(invoice1.get(0), "act.customerAccountChargesCredit", "act.customerAccountCreditItem", true, null, null);
        List<FinancialAct> invoice2 = this.createChargesInvoice(new BigDecimal(100));
        this.save(invoice2);
        this.checkReverse(invoice2.get(0), "act.customerAccountChargesCredit", "act.customerAccountCreditItem", false, null, null);
    }

    @Test
    public void testIsReversedIsReversal() {
        List<FinancialAct> invoice = this.createChargesInvoice(new BigDecimal(100));
        this.save(invoice);
        CustomerAccountRules rules = this.getRules();
        FinancialAct act = invoice.get(0);
        FinancialAct reverse = rules.reverse(act, new Date());
        Assert.assertTrue((boolean)rules.isReversed(act));
        Assert.assertFalse((boolean)rules.isReversed(reverse));
        Assert.assertFalse((boolean)rules.isReversal(act));
        Assert.assertTrue((boolean)rules.isReversal(reverse));
        FinancialAct reverse2 = rules.reverse(reverse, new Date());
        Assert.assertTrue((boolean)rules.isReversed(reverse));
        Assert.assertTrue((boolean)rules.isReversal(reverse));
        Assert.assertFalse((boolean)rules.isReversed(reverse2));
        Assert.assertTrue((boolean)rules.isReversal(reverse2));
    }

    @Test
    public void testReversePaymentEFTWithEFPOSTransaction() {
        FinancialAct transaction = (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(this.getCustomer())).terminal(this.practiceFactory.createEFTPOSTerminal())).amount(BigDecimal.TEN)).location(this.practiceFactory.createLocation())).status("NO_TERMINAL")).build();
        FinancialAct item = (FinancialAct)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.accountFactory.newEFTPaymentItem().addTransaction(transaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)this.newPayment().status("POSTED")).add(item)).build();
        FinancialAct reversal = this.checkReverse(payment, "act.customerAccountRefund", "act.customerAccountRefundEFT", false, null, null);
        FinancialAct reversalItem = this.getItem(reversal);
        IMObjectBean bean = this.getBean((IMObject)reversalItem);
        List eft = bean.getTargets("transactions", FinancialAct.class);
        Assert.assertEquals((long)0L, (long)eft.size());
        Assert.assertEquals((long)0L, (long)reversalItem.getSourceActRelationships().size());
    }

    @Test
    public void testReverseRefundEFTWithEFPOSTransaction() {
        FinancialAct transaction = (FinancialAct)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)this.accountFactory.newEFTPOSRefund().customer(this.getCustomer())).terminal(this.practiceFactory.createEFTPOSTerminal())).amount(BigDecimal.TEN)).location(this.practiceFactory.createLocation())).status("NO_TERMINAL")).build();
        FinancialAct item = (FinancialAct)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.accountFactory.newEFTRefundItem().addTransaction(transaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)this.newRefund().status("POSTED")).add(item)).build();
        FinancialAct reversal = this.checkReverse(refund, "act.customerAccountPayment", "act.customerAccountPaymentEFT", false, null, null);
        FinancialAct reversalItem = this.getItem(reversal);
        List eft = this.getBean((IMObject)reversalItem).getTargets("transactions", FinancialAct.class);
        Assert.assertEquals((long)0L, (long)eft.size());
        Assert.assertEquals((long)0L, (long)reversalItem.getSourceActRelationships().size());
    }

    @Test
    public void testReverseNonPosted() {
        for (String status : new String[]{"IN_PROGRESS", "COMPLETED", "ON_HOLD"}) {
            List<FinancialAct> acts = this.createChargesInvoice(new BigDecimal(100));
            FinancialAct invoice = acts.get(0);
            invoice.setStatus(status);
            this.save(acts);
            try {
                this.getRules().reverse(invoice, new Date());
                Assert.fail((String)"Expected reverse to fail");
            }
            catch (IllegalStateException expected) {
                Assert.assertEquals((Object)("Cannot reverse act with status " + status), (Object)expected.getMessage());
            }
        }
    }

    @Test
    public void testReverseOther() {
        Lookup stripe = (Lookup)((TestLookupBuilder)((TestLookupBuilder)this.accountFactory.newCustomPaymentType().code("STRIPE")).isDefault(true)).build();
        FinancialAct payment1 = this.createPaymentOther(BigDecimal.TEN);
        this.checkReverseOther(payment1, "act.customerAccountRefund", "act.customerAccountRefundOther", null);
        FinancialAct payment2 = this.createPaymentOther(BigDecimal.TEN, stripe.getCode());
        this.checkReverseOther(payment2, "act.customerAccountRefund", "act.customerAccountRefundOther", stripe.getCode());
        FinancialAct refund1 = this.createRefundOther(BigDecimal.TEN);
        this.checkReverseOther(refund1, "act.customerAccountPayment", "act.customerAccountPaymentOther", null);
        FinancialAct refund2 = this.createRefundOther(BigDecimal.TEN, stripe.getCode());
        this.checkReverseOther(refund2, "act.customerAccountPayment", "act.customerAccountPaymentOther", stripe.getCode());
    }

    @Test
    public void testReversePaymentProcessorPayment() {
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.newPayment().customer(this.getCustomer())).till(this.getTill())).status("POSTED")).paymentProcessor(this.paymentProcessorFactory.createPaymentProcessor(), 10)).build();
        try {
            this.getRules().reverse(payment, new Date());
            Assert.fail((String)"Expected reverse to fail");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"Cannot reverse act.customerAccountPaymentPP", (Object)expected.getMessage());
        }
    }

    @Test
    public void testReversePaymentProcessorRefund() {
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.getCustomer())).till(this.getTill())).status("POSTED")).paymentProcessor(this.paymentProcessorFactory.createPaymentProcessor(), 10)).build();
        try {
            this.getRules().reverse(refund, new Date());
            Assert.fail((String)"Expected reverse to fail");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"Cannot reverse act.customerAccountRefundPP", (Object)expected.getMessage());
        }
    }

    @Test
    public void testCreatePaymentProcessorReversal() {
        TestPaymentBuilder builder = this.newPayment();
        Party customer = this.getCustomer();
        Entity till = this.getTill();
        Party location = this.practiceFactory.createLocation();
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        Date now = new Date();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)builder.startTime(DateRules.getYesterday())).customer(customer)).till(till)).location(location)).status("POSTED")).paymentProcessor().processor(paymentProcessor)).amount(10)).addTransaction("COMPLETED")).add()).build();
        BuiltObjects objects = builder.getBuiltObjects();
        FinancialAct paymentPP = objects.getObject("act.customerAccountPaymentPP", FinancialAct.class);
        FinancialAct transactionPP = objects.getObject("act.paymentProcessorPayment", FinancialAct.class);
        Assert.assertNotNull((Object)transactionPP);
        FinancialAct refund = this.getRules().createPaymentProcessorReversal(payment);
        Assert.assertTrue((DateRules.compareTo((Date)refund.getActivityStartTime(), (Date)now) >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"act.customerAccountRefund", (Object)refund.getArchetype());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)refund.getStatus());
        this.checkEquals(10, refund.getTotal());
        IMObjectBean bean = this.getBean((IMObject)refund);
        Assert.assertEquals((Object)payment, (Object)bean.getSource("reverses"));
        Assert.assertEquals((Object)customer, (Object)bean.getTarget("customer"));
        Assert.assertEquals((Object)till, (Object)bean.getTarget("till"));
        Assert.assertEquals((Object)location, (Object)bean.getTarget("location"));
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        FinancialAct refundPP = (FinancialAct)items.get(0);
        Assert.assertEquals((Object)"act.customerAccountRefundPP", (Object)refundPP.getArchetype());
        this.checkEquals(10, refundPP.getTotal());
        IMObjectBean refundPPBean = this.getBean((IMObject)refundPP);
        Assert.assertEquals((Object)paymentPP, (Object)refundPPBean.getSource("reverses"));
        Assert.assertEquals((Object)refund, (Object)refundPPBean.getSource("transaction"));
        Assert.assertEquals((long)0L, (long)refundPPBean.getTargets("transactions").size());
    }

    @Test
    public void testCreatePaymentProcessorReversalForRefund() {
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.newRefund().customer(this.getCustomer())).till(this.getTill())).status("POSTED")).paymentProcessor(this.paymentProcessorFactory.createPaymentProcessor(), 10)).build();
        try {
            this.getRules().createPaymentProcessorReversal(refund);
            Assert.fail((String)"Expected createPaymentProcessorReversal() to fail");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertEquals((Object)"Argument 'payment' must be a act.customerAccountPayment, not a act.customerAccountRefund", (Object)expected.getMessage());
        }
    }

    @Test
    public void testCreatePaymentProcessorReversalForNonPosted() {
        for (String status : Arrays.asList("IN_PROGRESS", "ON_HOLD")) {
            FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.newPayment().customer(this.getCustomer())).till(this.getTill())).status(status)).paymentProcessor(this.paymentProcessorFactory.createPaymentProcessor(), 10)).build();
            try {
                this.getRules().createPaymentProcessorReversal(payment);
                Assert.fail((String)"Expected createPaymentProcessorReversal to fail");
            }
            catch (IllegalStateException expected) {
                Assert.assertEquals((Object)("Cannot reverse act with status " + status), (Object)expected.getMessage());
            }
        }
    }

    @Test
    public void testCreatePaymentProcessorReversalWhenAlreadyReversed() {
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.newPayment().customer(this.getCustomer())).till(this.getTill())).status("POSTED")).paymentProcessor(this.paymentProcessorFactory.createPaymentProcessor(), 10)).build();
        CustomerAccountRules rules = this.getRules();
        rules.createPaymentProcessorReversal(payment);
        try {
            rules.createPaymentProcessorReversal(payment);
            Assert.fail((String)"Expected createPaymentProcessorReversal() to fail");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)("Act=" + payment.getId() + " has already been reversed"), (Object)expected.getMessage());
        }
    }

    @Test
    public void testReversalOfPaymentProcessorPaymentAllocation() {
        this.checkBalance(0);
        FinancialAct invoice1 = this.createInvoice(DateRules.getYesterday(), 50);
        FinancialAct invoice2 = this.createInvoice(DateRules.getYesterday(), 50);
        this.checkBalance(100);
        TestPaymentBuilder builder = this.newPayment();
        Entity paymentProcessor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)builder.customer(this.getCustomer())).till(this.getTill())).location(this.practiceFactory.createLocation())).status("POSTED")).paymentProcessor().processor(paymentProcessor)).amount(100)).addTransaction("COMPLETED")).add()).build();
        this.checkAllocation(payment, 100, invoice1, invoice2);
        this.checkAllocation(invoice1, 50, payment);
        this.checkAllocation(invoice2, 50, payment);
        this.checkBalance(0);
        FinancialAct refund = this.accountRules.createPaymentProcessorReversal(payment);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)refund.getStatus());
        this.checkEquals(100, refund.getTotal());
        Assert.assertTrue((boolean)MathRules.isZero((BigDecimal)refund.getAllocatedAmount()));
        refund.setStatus("POSTED");
        this.save((IMObject)refund);
        this.checkAllocation(payment, 100, refund);
        this.checkAllocation(refund, 100, payment);
        this.checkAllocation(invoice1, 0, new FinancialAct[0]);
        this.checkAllocation(invoice2, 0, new FinancialAct[0]);
        this.checkBalance(100);
    }

    @Test
    public void testSetHidden() {
        CustomerAccountRules rules = this.getRules();
        BigDecimal amount = new BigDecimal(100);
        FinancialAct invoice = this.createInvoice(new Date(), 100);
        this.checkBalance(amount);
        Assert.assertFalse((boolean)rules.isHidden((Act)invoice));
        FinancialAct reversal = rules.reverse(invoice, new Date(), "Test reversal", null, false);
        Assert.assertFalse((boolean)rules.isHidden((Act)reversal));
        this.checkBalance(BigDecimal.ZERO);
        rules.setHidden(invoice, true);
        this.checkBalance(BigDecimal.ZERO);
        rules.setHidden(reversal, true);
        this.checkBalance(BigDecimal.ZERO);
        Assert.assertTrue((boolean)rules.isHidden((Act)invoice));
        Assert.assertTrue((boolean)rules.isHidden((Act)reversal));
        rules.setHidden(invoice, false);
        Assert.assertFalse((boolean)rules.isHidden((Act)invoice));
        this.checkBalance(BigDecimal.ZERO);
        rules.setHidden(reversal, false);
        Assert.assertFalse((boolean)rules.isHidden((Act)reversal));
        this.checkBalance(BigDecimal.ZERO);
    }

    @Test
    public void testHideIgnoredForReverseOfReverse() {
        CustomerAccountRules rules = this.getRules();
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount);
        this.save(invoice);
        this.checkBalance(amount);
        FinancialAct act = invoice.get(0);
        FinancialAct reversal = rules.reverse(act, new Date(), "Test reversal", null, true);
        this.checkBalance(BigDecimal.ZERO);
        Assert.assertTrue((boolean)rules.isHidden((Act)act));
        Assert.assertTrue((boolean)rules.isHidden((Act)reversal));
        FinancialAct reversal2 = rules.reverse(reversal, new Date(), "Test reversal 2", null, true);
        act = this.get(act);
        reversal = this.get(reversal);
        Assert.assertTrue((boolean)rules.isHidden((Act)act));
        Assert.assertTrue((boolean)rules.isHidden((Act)reversal));
        Assert.assertFalse((boolean)rules.isHidden((Act)reversal2));
        this.checkBalance(amount);
    }

    @Test
    public void getReversalArchetype() {
        CustomerAccountRules rules = this.getRules();
        Assert.assertEquals((Object)"act.customerAccountChargesCredit", (Object)rules.getReversalArchetype("act.customerAccountChargesInvoice"));
        Assert.assertEquals((Object)"act.customerAccountChargesInvoice", (Object)rules.getReversalArchetype("act.customerAccountChargesCredit"));
        Assert.assertEquals((Object)"act.customerAccountRefund", (Object)rules.getReversalArchetype("act.customerAccountPayment"));
        Assert.assertEquals((Object)"act.customerAccountPayment", (Object)rules.getReversalArchetype("act.customerAccountRefund"));
        Assert.assertEquals((Object)"act.customerAccountRefundCash", (Object)rules.getReversalArchetype("act.customerAccountPaymentCash"));
        Assert.assertEquals((Object)"act.customerAccountPaymentCash", (Object)rules.getReversalArchetype("act.customerAccountRefundCash"));
        Assert.assertEquals((Object)"act.customerAccountRefundEFT", (Object)rules.getReversalArchetype("act.customerAccountPaymentEFT"));
        Assert.assertEquals((Object)"act.customerAccountPaymentEFT", (Object)rules.getReversalArchetype("act.customerAccountRefundEFT"));
        Assert.assertNull((Object)rules.getReversalArchetype("act.supplierAccountChargesInvoice"));
    }

    @Test
    public void testZeroAct() {
        List<FinancialAct> invoices = this.createChargesInvoice(BigDecimal.ZERO);
        FinancialAct invoice = invoices.get(0);
        invoice.setStatus("IN_PROGRESS");
        this.save(invoices);
        IMObjectBean bean = this.getBean((IMObject)invoice);
        Assert.assertTrue((boolean)bean.getValues("accountBalance").isEmpty());
        invoice.setTotal(BigDecimal.TEN);
        this.save((IMObject)invoice);
        Assert.assertFalse((boolean)bean.getValues("accountBalance").isEmpty());
        invoice.setTotal((BigDecimal)Money.ZERO);
        this.save((IMObject)invoice);
        Assert.assertTrue((boolean)bean.getValues("accountBalance").isEmpty());
        invoice.setStatus("POSTED");
        this.save((IMObject)invoice);
        Assert.assertTrue((boolean)bean.getValues("accountBalance").isEmpty());
    }

    @Test
    public void testAllocationOrder() {
        BigDecimal sixty = new BigDecimal(60);
        BigDecimal forty = new BigDecimal(40);
        BigDecimal twenty = new BigDecimal(20);
        Date chargeTime1 = TestHelper.getDate("2007-01-01");
        Date chargeTime2 = TestHelper.getDate("2007-03-30");
        List<FinancialAct> invoice1 = this.createChargesInvoice(sixty, chargeTime1);
        this.save(invoice1);
        List<FinancialAct> invoice2 = this.createChargesInvoice(forty, chargeTime2);
        this.save(invoice2);
        Date payTime1 = TestHelper.getDate("2007-04-01");
        FinancialAct payment1 = this.createPayment(forty, payTime1);
        this.save((IMObject)payment1);
        this.checkAllocation(invoice1.get(0), forty, payment1);
        this.checkAllocation(invoice2.get(0), BigDecimal.ZERO, new FinancialAct[0]);
        Date payTime2 = TestHelper.getDate("2007-04-02");
        FinancialAct payment2 = this.createPayment(twenty, payTime2);
        this.save((IMObject)payment2);
        this.checkAllocation(invoice1.get(0), sixty, payment1, payment2);
        this.checkAllocation(invoice2.get(0), BigDecimal.ZERO, new FinancialAct[0]);
        Date payTime3 = TestHelper.getDate("2007-04-03");
        FinancialAct payment3 = this.createPayment(forty, payTime3);
        this.save((IMObject)payment3);
        this.checkAllocation(invoice1.get(0), sixty, payment1, payment2);
        this.checkAllocation(invoice2.get(0), forty, payment3);
    }

    @Test
    public void testGetInvoice() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        Assert.assertNull((Object)rules.getInvoice(customer));
        this.createInvoice(TestHelper.getDate("2013-05-02"), BigDecimal.TEN, "POSTED");
        this.createInvoice(TestHelper.getDate("2013-05-02"), BigDecimal.TEN, "ON_HOLD");
        Assert.assertNull((Object)rules.getInvoice(customer));
        FinancialAct invoice2 = this.createInvoice(TestHelper.getDate("2013-05-02"), BigDecimal.TEN, "COMPLETED");
        Assert.assertEquals((Object)invoice2, (Object)rules.getInvoice(customer));
        FinancialAct invoice3 = this.createInvoice(TestHelper.getDate("2013-05-01"), BigDecimal.TEN, "IN_PROGRESS");
        Assert.assertEquals((Object)invoice3, (Object)rules.getInvoice(customer));
        FinancialAct invoice4 = this.createInvoice(TestHelper.getDate("2013-05-05"), BigDecimal.TEN, "IN_PROGRESS");
        Assert.assertEquals((Object)invoice4, (Object)rules.getInvoice(customer));
    }

    @Test
    public void testGetCredit() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        Assert.assertNull((Object)rules.getCredit(customer));
        this.createCredit(TestHelper.getDate("2013-05-02"), "POSTED");
        Assert.assertNull((Object)rules.getInvoice(customer));
        FinancialAct credit2 = this.createCredit(TestHelper.getDate("2013-05-02"), "COMPLETED");
        Assert.assertEquals((Object)credit2, (Object)rules.getCredit(customer));
        FinancialAct credit3 = this.createCredit(TestHelper.getDate("2013-05-01"), "IN_PROGRESS");
        Assert.assertEquals((Object)credit3, (Object)rules.getCredit(customer));
        FinancialAct credit4 = this.createCredit(TestHelper.getDate("2013-05-05"), "IN_PROGRESS");
        Assert.assertEquals((Object)credit4, (Object)rules.getCredit(customer));
    }

    @Test
    public void testReverseInvoiceRemovesEntriesFromHistory() {
        CustomerAccountRules rules = this.getRules();
        Party patient = this.getPatient();
        Party location = this.practiceFactory.createLocation();
        Product product = this.getProduct();
        ((AbstractTestIMObjectBuilder)this.productFactory.updateProduct(product).addDemographicUpdate("patient.entity", "party:setPatientDesexed(.)")).build();
        this.initStockQuantity(new BigDecimal("10"));
        List<FinancialAct> invoice1 = this.createChargesInvoice(new BigDecimal(100));
        FinancialAct invoice = invoice1.get(0);
        invoice.setStatus("IN_PROGRESS");
        Act item1 = (Act)invoice1.get(1);
        Act medication = this.patientFactory.createMedication(patient, product);
        Act investigation = (Act)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(this.laboratoryFactory.createInvestigationType()).build();
        DocumentAct document = this.patientFactory.createForm(patient);
        IMObjectBean itemBean = this.getBean((IMObject)item1);
        itemBean.addTarget("dispensing", (IMObject)medication, "invoiceItem");
        itemBean.addTarget("investigations", (IMObject)investigation, "invoiceItems");
        ActRelationship documentRelationship = (ActRelationship)itemBean.addTarget("documents", (IMObject)document);
        document.addActRelationship(documentRelationship);
        Assert.assertEquals((long)3L, (long)item1.getSourceActRelationships().size());
        List<FinancialAct> invoice2 = this.createChargesInvoice(new BigDecimal(10), this.getCustomer(), this.productFactory.createMedication());
        Act item2 = (Act)invoice2.get(1);
        ArrayList<FinancialAct> toSave = new ArrayList<FinancialAct>(invoice1);
        toSave.add((FinancialAct)medication);
        toSave.add((FinancialAct)investigation);
        toSave.add((FinancialAct)document);
        toSave.addAll(invoice2);
        this.save(toSave);
        this.checkStock(new BigDecimal("9"));
        Assert.assertFalse((boolean)this.patientRules.isDesexed(this.get(patient)));
        Act event = this.patientFactory.createVisit(patient);
        IMObjectBean eventBean = this.getBean((IMObject)event);
        ChargeItemEventLinker linker = new ChargeItemEventLinker((ArchetypeService)this.getArchetypeService());
        linker.link(event, item1, new PatientHistoryChanges(location, (ArchetypeService)this.getArchetypeService()));
        linker.link(event, item2, new PatientHistoryChanges(location, (ArchetypeService)this.getArchetypeService()));
        List charges = eventBean.getTargets("chargeItems", Act.class);
        Assert.assertEquals((long)2L, (long)charges.size());
        Assert.assertTrue((boolean)charges.contains(item1));
        Assert.assertTrue((boolean)charges.contains(item2));
        List items = eventBean.getTargets("items", Act.class);
        Assert.assertEquals((long)3L, (long)items.size());
        Assert.assertTrue((boolean)items.contains(medication));
        Assert.assertTrue((boolean)items.contains(investigation));
        Assert.assertTrue((boolean)items.contains(document));
        invoice.setStatus("POSTED");
        this.save((IMObject)invoice);
        this.checkStock(new BigDecimal("9"));
        patient = this.get(patient);
        Assert.assertTrue((boolean)this.patientRules.isDesexed(patient));
        this.patientFactory.updatePatient(patient).desexed(false).build();
        FinancialAct credit = rules.reverse(invoice, new Date());
        Assert.assertTrue((boolean)credit.isA("act.customerAccountChargesCredit"));
        FinancialAct creditItem = this.getItem(credit);
        Assert.assertEquals((long)0L, (long)creditItem.getSourceActRelationships().size());
        event = this.get(event);
        eventBean = this.getBean((IMObject)event);
        item1 = this.get(item1);
        Assert.assertNotNull((Object)item1);
        Assert.assertNotNull((Object)this.get(medication));
        Assert.assertNotNull((Object)this.get(investigation));
        Assert.assertNotNull((Object)this.get(document));
        charges = eventBean.getTargets("chargeItems", Act.class);
        Assert.assertEquals((long)1L, (long)charges.size());
        Assert.assertEquals((Object)item2, charges.get(0));
        items = eventBean.getTargets("items", Act.class);
        Assert.assertEquals((long)0L, (long)items.size());
        Assert.assertEquals((long)3L, (long)item1.getSourceActRelationships().size());
        Assert.assertFalse((boolean)this.patientRules.isDesexed(this.get(patient)));
        this.checkStock(new BigDecimal("10"));
    }

    @Test
    public void testReverseInvoiceWithReminder() {
        CustomerAccountRules rules = this.getRules();
        Party patient = this.getPatient();
        List<FinancialAct> invoiceActs = this.createChargesInvoice(new BigDecimal(100));
        FinancialAct invoice = invoiceActs.get(0);
        Act item = (Act)invoiceActs.get(1);
        Act reminder = this.reminderFactory.createReminder(patient, this.reminderFactory.createReminderType());
        IMObjectBean itemBean = this.getBean((IMObject)item);
        ActRelationship relationship = (ActRelationship)itemBean.addTarget("reminders", (IMObject)reminder);
        reminder.addActRelationship(relationship);
        Assert.assertEquals((long)1L, (long)item.getSourceActRelationships().size());
        ArrayList<FinancialAct> toSave = new ArrayList<FinancialAct>(invoiceActs);
        toSave.add((FinancialAct)reminder);
        this.save(toSave);
        FinancialAct credit = rules.reverse(invoice, new Date());
        Assert.assertTrue((boolean)credit.isA("act.customerAccountChargesCredit"));
        FinancialAct creditItem = this.getItem(credit);
        Assert.assertEquals((long)0L, (long)creditItem.getSourceActRelationships().size());
        item = this.get(item);
        itemBean = this.getBean((IMObject)item);
        reminder = this.get(reminder);
        Assert.assertNotNull((Object)reminder);
        Assert.assertTrue((boolean)itemBean.getTargets("reminders").contains(reminder));
    }

    @Test
    public void testReverseToSpecifiedTillBalance() {
        Entity till = this.getTill();
        Assert.assertNull((Object)this.tillBalanceRules.getUnclearedBalance(till));
        BigDecimal amount = new BigDecimal(75);
        FinancialAct payment1 = this.createPaymentCash(amount);
        payment1.setStatus("POSTED");
        this.save((IMObject)payment1);
        FinancialAct balance1 = this.tillBalanceRules.getUnclearedBalance(till);
        Assert.assertNotNull((Object)balance1);
        this.checkEquals(amount, balance1.getTotal());
        balance1.setStatus("IN_PROGRESS");
        this.save((IMObject)balance1);
        FinancialAct payment2 = this.createPaymentCash(BigDecimal.TEN);
        payment2.setStatus("POSTED");
        this.save((IMObject)payment2);
        FinancialAct balance2 = this.tillBalanceRules.getUnclearedBalance(till);
        Assert.assertNotNull((Object)balance2);
        Assert.assertNotEquals((long)balance1.getId(), (long)balance2.getId());
        this.checkEquals(BigDecimal.TEN, balance2.getTotal());
        FinancialAct refund = this.checkReverse(payment1, "act.customerAccountRefund", "act.customerAccountRefundCash", false, balance1, amount);
        balance1 = this.get(balance1);
        IMObjectBean bean = this.getBean((IMObject)balance1);
        Assert.assertTrue((boolean)bean.hasTarget("items", (IMObject)payment1));
        Assert.assertTrue((boolean)bean.hasTarget("items", (IMObject)refund));
        this.checkEquals(BigDecimal.ZERO, balance1.getTotal());
    }

    @Test
    public void testHasAccountActs() {
        Party customer = this.getCustomer();
        CustomerAccountRules rules = this.getRules();
        Assert.assertFalse((boolean)rules.hasAccountActs(customer));
        this.save(this.createChargesInvoice(BigDecimal.TEN));
        Assert.assertTrue((boolean)rules.hasAccountActs(customer));
    }

    @Test
    public void testReverseCashWithRoundedAmountDifferentToAmount() {
        BigDecimal amount = new BigDecimal("51.54");
        BigDecimal rounded = new BigDecimal("51.55");
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestCashPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.getCustomer())).till(this.getTill())).cash().amount(amount)).roundedAmount(rounded).tendered(rounded).add()).status("POSTED")).build();
        FinancialAct refund = this.checkReverse(payment, "act.customerAccountRefund", "act.customerAccountRefundCash", false, null, rounded);
        FinancialAct payment2 = this.checkReverse(refund, "act.customerAccountPayment", "act.customerAccountPaymentCash", false, null, rounded);
        this.checkAllocation(payment, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkAllocation(payment2, amount, refund);
    }

    @Test
    public void testReverseCashWithTenderedDifferentToAmount() {
        BigDecimal amount = new BigDecimal("51.54");
        BigDecimal rounded = new BigDecimal("51.55");
        BigDecimal tendered = new BigDecimal("60.00");
        TestPaymentBuilder builder = this.accountFactory.newPayment();
        FinancialAct payment1 = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestCashPaymentItemBuilder)((TestPaymentBuilder)((TestPaymentBuilder)builder.customer(this.getCustomer())).till(this.getTill())).cash().amount(amount)).roundedAmount(rounded).tendered(tendered).add()).status("POSTED")).build();
        IMObjectBean item = this.getBean((IMObject)this.getItem(payment1));
        this.checkEquals(new BigDecimal("8.45"), item.getBigDecimal("change"));
        FinancialAct refund = this.checkReverse(payment1, "act.customerAccountRefund", "act.customerAccountRefundCash", false, null, rounded);
        FinancialAct payment2 = this.checkReverse(refund, "act.customerAccountPayment", "act.customerAccountPaymentCash", false, null, rounded);
        IMObjectBean cash = this.getBean((IMObject)this.getItem(payment2));
        this.checkEquals(rounded, cash.getBigDecimal("tendered"));
        this.checkEquals(BigDecimal.ZERO, cash.getBigDecimal("change"));
        this.checkAllocation(payment1, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkAllocation(payment2, amount, refund);
    }

    @Test
    public void testNegativeAmountsUnsupported() {
        BigDecimal minusOne = new BigDecimal(-1);
        this.checkNegativeAmounts(this.createPayment(minusOne));
        this.checkNegativeAmounts(this.createRefund(minusOne));
        this.checkNegativeAmounts(this.createCreditAdjust(minusOne));
        this.checkNegativeAmounts(this.createDebitAdjust(minusOne));
        this.checkNegativeAmounts(this.createInitialBalance(minusOne));
        this.checkNegativeAmounts(this.createBadDebt(minusOne));
    }

    @Test
    public void testInvoiceInGapClaimWithPayment() {
        this.checkInvoiceInGapClaim("PENDING", this.createPayment(BigDecimal.TEN), false);
    }

    @Test
    public void testInvoiceInGapClaimWithCredit() {
        this.checkInvoiceInGapClaim("POSTED", this.createChargesCredit(BigDecimal.TEN), false);
    }

    @Test
    public void testInvoiceInGapClaimWithCreditAdjust() {
        this.checkInvoiceInGapClaim("SUBMITTED", this.createCreditAdjust(BigDecimal.TEN), false);
    }

    @Test
    public void testInvoiceInGapClaimWithBadDebt() {
        this.checkInvoiceInGapClaim("ACCEPTED", this.createBadDebt(BigDecimal.TEN), false);
    }

    @Test
    public void testInvoiceInCancelledGapClaim() {
        this.checkInvoiceInGapClaim("CANCELLED", this.createPayment(BigDecimal.TEN), true);
    }

    @Test
    public void testInvoiceInSettledGapClaim() {
        this.checkInvoiceInGapClaim("SETTLED", this.createChargesCredit(BigDecimal.TEN), true);
    }

    @Test
    public void testInvoiceDeclinedGapClaim() {
        this.checkInvoiceInGapClaim("DECLINED", this.createCreditAdjust(BigDecimal.TEN), true);
    }

    @Test
    public void testCreatePaymentOther() {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        Party location = this.practiceFactory.createLocation();
        Entity till = this.getTill();
        this.accountFactory.createCustomPaymentType("GAP_BENEFIT_PAYMENT");
        List acts = rules.createPaymentOther(customer, BigDecimal.TEN, till, location, "GAP_BENEFIT_PAYMENT", "some notes");
        Assert.assertEquals((long)2L, (long)acts.size());
        FinancialAct payment = (FinancialAct)acts.get(0);
        FinancialAct item = (FinancialAct)acts.get(1);
        Assert.assertTrue((boolean)payment.isA("act.customerAccountPayment"));
        Assert.assertTrue((boolean)item.isA("act.customerAccountPaymentOther"));
        Assert.assertTrue((boolean)payment.isNew());
        Assert.assertTrue((boolean)item.isNew());
        Assert.assertEquals((Object)"POSTED", (Object)payment.getStatus());
        this.checkEquals(BigDecimal.TEN, payment.getTotal());
        this.checkEquals(BigDecimal.TEN, item.getTotal());
        IMObjectBean paymentBean = this.getBean((IMObject)payment);
        Assert.assertEquals((Object)customer.getObjectReference(), (Object)paymentBean.getTargetRef("customer"));
        Assert.assertEquals((Object)till.getObjectReference(), (Object)paymentBean.getTargetRef("till"));
        Assert.assertEquals((Object)"some notes", (Object)paymentBean.getString("notes"));
        IMObjectBean itemBean = this.getBean((IMObject)item);
        Assert.assertEquals((Object)"GAP_BENEFIT_PAYMENT", (Object)itemBean.getString("paymentType"));
        this.checkAddToBalance(acts);
    }

    @Test
    public void testHasClearedTillBalance() {
        CustomerAccountRules rules = this.getRules();
        FinancialAct payment = this.createPayment(BigDecimal.TEN);
        this.save((IMObject)payment);
        Assert.assertFalse((boolean)rules.hasClearedTillBalance(payment));
        IMObjectBean bean = this.getBean((IMObject)payment);
        FinancialAct balance = (FinancialAct)bean.getSource("tillBalance", FinancialAct.class);
        Assert.assertNotNull((Object)balance);
        Assert.assertEquals((Object)"UNCLEARED", (Object)balance.getStatus());
        balance.setStatus("IN_PROGRESS");
        this.save((IMObject)balance);
        Assert.assertFalse((boolean)rules.hasClearedTillBalance(payment));
        balance.setStatus("CLEARED");
        this.save((IMObject)balance);
        Assert.assertTrue((boolean)rules.hasClearedTillBalance(payment));
    }

    @Test
    public void testPost() {
        CustomerAccountRules rules = this.getRules();
        this.checkBalance(BigDecimal.ZERO);
        FinancialAct payment = this.createPayment(BigDecimal.TEN);
        this.save((IMObject)payment);
        this.checkBalance(BigDecimal.TEN.negate());
        FinancialAct invoice = this.createInvoice(DateRules.getYesterday(), BigDecimal.TEN, "IN_PROGRESS");
        Date now = new Date();
        Assert.assertTrue((now.compareTo(invoice.getActivityStartTime()) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rules.canPost(invoice));
        rules.post(invoice);
        invoice = this.get(invoice);
        Assert.assertEquals((Object)"POSTED", (Object)invoice.getStatus());
        this.checkAllocation(invoice, BigDecimal.TEN, payment);
        this.checkAllocation(payment, BigDecimal.TEN, invoice);
        this.checkBalance(BigDecimal.ZERO);
        Assert.assertTrue((DateRules.compareTo((Date)now, (Date)invoice.getActivityStartTime(), (boolean)true) <= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPostForPayment() {
        this.checkPostForPaymentRefund(true);
    }

    @Test
    public void testPostForRefund() {
        this.checkPostForPaymentRefund(false);
    }

    @Test
    public void testPostPaymentForOutstandingEFT() {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        TestEFTPOSPaymentBuilder eftposPaymentBuilder = new TestEFTPOSPaymentBuilder((ArchetypeService)this.getArchetypeService());
        FinancialAct transaction = (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)eftposPaymentBuilder.customer(this.getCustomer())).amount(BigDecimal.TEN)).terminal(terminal)).location(this.practiceFactory.createLocation())).status("PENDING")).build();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.newPayment().eft().amount(BigDecimal.TEN)).addTransaction(transaction)).add()).build();
        this.checkPostForEFTPOS(payment, transaction, "PENDING", true);
        this.checkPostForEFTPOS(payment, transaction, "IN_PROGRESS", true);
        this.checkPostForEFTPOS(payment, transaction, "DECLINED", true);
        this.checkPostForEFTPOS(payment, transaction, "ERROR", true);
        this.checkPostForEFTPOS(payment, transaction, "APPROVED", false);
    }

    @Test
    public void testPostRefundForOutstandingEFT() {
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        TestEFTPOSRefundBuilder eftposRefundBuilder = new TestEFTPOSRefundBuilder((ArchetypeService)this.getArchetypeService());
        FinancialAct transaction = (FinancialAct)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)eftposRefundBuilder.customer(this.getCustomer())).amount(BigDecimal.TEN)).terminal(terminal)).location(this.practiceFactory.createLocation())).status("PENDING")).build();
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.newRefund().eft().amount(BigDecimal.TEN)).addTransaction(transaction)).add()).build();
        this.checkPostForEFTPOS(refund, transaction, "PENDING", true);
        this.checkPostForEFTPOS(refund, transaction, "IN_PROGRESS", true);
        this.checkPostForEFTPOS(refund, transaction, "DECLINED", true);
        this.checkPostForEFTPOS(refund, transaction, "ERROR", true);
        this.checkPostForEFTPOS(refund, transaction, "APPROVED", false);
    }

    @Test
    public void testPostForInitialPaymentProcessorPayment() {
        CustomerAccountRules rules = this.getRules();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)this.newPayment().paymentProcessor(this.paymentProcessorFactory.createPaymentProcessor(), 10)).build();
        Assert.assertFalse((boolean)rules.canPost(payment));
        PostStatus postStatus = rules.getPostStatus(payment);
        Assert.assertFalse((boolean)postStatus.canPost());
        Assert.assertTrue((boolean)postStatus.hasUnsubmittedPaymentProcessorTransaction());
        try {
            rules.post(payment);
            Assert.fail((String)"Expected post() to fail");
        }
        catch (CustomerAccountRuleException exception) {
            Assert.assertEquals((Object)CustomerAccountRuleException.ErrorCode.CannotPostWithOutstandingPaymentProcessorItem, (Object)exception.getErrorCode());
            Assert.assertEquals((Object)"Cannot finalise Payment. It has an incomplete Payment Processor Payment.", (Object)exception.getMessage());
            payment = this.get(payment);
            Assert.assertEquals((Object)"IN_PROGRESS", (Object)payment.getStatus());
        }
    }

    @Test
    public void testPostPaymentForOutstandingPaymentProcessorTransaction() {
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct transaction = (FinancialAct)((TestPaymentProcessorPaymentBuilder)((TestPaymentProcessorPaymentBuilder)((TestPaymentProcessorPaymentBuilder)((TestPaymentProcessorPaymentBuilder)((TestPaymentProcessorPaymentBuilder)this.accountFactory.newPaymentProcessorPayment().customer(this.getCustomer())).amount(BigDecimal.TEN)).paymentProcessor(processor)).location(this.practiceFactory.createLocation())).status("PENDING")).build();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(BigDecimal.TEN)).addTransaction(transaction)).add()).build();
        this.checkPostForPaymentProcessorTransaction(payment, transaction, "PENDING", true);
        this.checkPostForPaymentProcessorTransaction(payment, transaction, "IN_PROGRESS", true);
        this.checkPostForPaymentProcessorTransaction(payment, transaction, "SUBMITTED", true);
        this.checkPostForPaymentProcessorTransaction(payment, transaction, "CANCELLED", true);
        this.checkPostForPaymentProcessorTransaction(payment, transaction, "ERROR", true);
        this.checkPostForPaymentProcessorTransaction(payment, transaction, "COMPLETED", false);
    }

    @Test
    public void testPostForInitialPaymentProcessorRefund() {
        CustomerAccountRules rules = this.getRules();
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)this.newRefund().paymentProcessor(this.paymentProcessorFactory.createPaymentProcessor(), 10)).build();
        Assert.assertFalse((boolean)rules.canPost(refund));
        PostStatus postStatus = rules.getPostStatus(refund);
        Assert.assertFalse((boolean)postStatus.canPost());
        Assert.assertTrue((boolean)postStatus.hasUnsubmittedPaymentProcessorTransaction());
        try {
            rules.post(refund);
            Assert.fail((String)"Expected post() to fail");
        }
        catch (CustomerAccountRuleException exception) {
            Assert.assertEquals((Object)CustomerAccountRuleException.ErrorCode.CannotPostWithOutstandingPaymentProcessorItem, (Object)exception.getErrorCode());
            Assert.assertEquals((Object)"Cannot finalise Refund. It has an incomplete Payment Processor Refund.", (Object)exception.getMessage());
            refund = this.get(refund);
            Assert.assertEquals((Object)"IN_PROGRESS", (Object)refund.getStatus());
        }
    }

    @Test
    public void testPostRefundForOutstandingPaymentProcessorTransaction() {
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct transaction = (FinancialAct)((TestPaymentProcessorRefundBuilder)((TestPaymentProcessorRefundBuilder)((TestPaymentProcessorRefundBuilder)((TestPaymentProcessorRefundBuilder)((TestPaymentProcessorRefundBuilder)this.accountFactory.newPaymentProcessorRefund().customer(this.getCustomer())).amount(BigDecimal.TEN)).paymentProcessor(processor)).location(this.practiceFactory.createLocation())).status("PENDING")).build();
        FinancialAct refund = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(BigDecimal.TEN)).addTransaction(transaction)).add()).build();
        this.checkPostForPaymentProcessorTransaction(refund, transaction, "PENDING", true);
        this.checkPostForPaymentProcessorTransaction(refund, transaction, "IN_PROGRESS", true);
        this.checkPostForPaymentProcessorTransaction(refund, transaction, "SUBMITTED", true);
        this.checkPostForPaymentProcessorTransaction(refund, transaction, "CANCELLED", true);
        this.checkPostForPaymentProcessorTransaction(refund, transaction, "ERROR", true);
        this.checkPostForPaymentProcessorTransaction(refund, transaction, "COMPLETED", false);
    }

    @Test
    public void testPostForPostedTransaction() {
        CustomerAccountRules rules = this.getRules();
        FinancialAct invoice = this.createInvoice(new Date(), BigDecimal.TEN, "POSTED");
        Assert.assertFalse((boolean)rules.canPost(invoice));
        try {
            rules.post(invoice);
            Assert.fail((String)"Expected CustomerAccountRuleException");
        }
        catch (CustomerAccountRuleException expected) {
            Assert.assertEquals((Object)CustomerAccountRuleException.ErrorCode.AlreadyPosted, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testHasOutstandingAndApprovedEFTPOSTransactionForPayment() {
        CustomerAccountRules rules = this.getRules();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct payment1 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)this.newPayment().eft().amount(BigDecimal.TEN)).add()).build();
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(payment1, false));
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(payment1, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(payment1));
        FinancialAct payment2 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.newPayment().eft().amount(BigDecimal.TEN)).addTransaction("PENDING", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(payment2, false));
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(payment2, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(payment2));
        FinancialAct payment3 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.newPayment().eft().amount(BigDecimal.TEN)).addTransaction("IN_PROGRESS", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(payment3, false));
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(payment3, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(payment3));
        FinancialAct payment4 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.newPayment().eft().amount(BigDecimal.TEN)).addTransaction("APPROVED", terminal)).add()).build();
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(payment4, false));
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(payment4, true));
        Assert.assertTrue((boolean)rules.hasApprovedEFTPOSTransaction(payment4));
        FinancialAct payment5 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.newPayment().eft().amount(BigDecimal.TEN)).addTransaction("DECLINED", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(payment5, false));
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(payment5, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(payment5));
        FinancialAct payment6 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.newPayment().eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(payment6, false));
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(payment6, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(payment6));
        FinancialAct payment7 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.newPayment().eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("PENDING", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(payment7, false));
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(payment7, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(payment7));
        FinancialAct payment8 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.newPayment().eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("IN_PROGRESS", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(payment8, false));
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(payment8, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(payment8));
        FinancialAct payment9 = (FinancialAct)((TestPaymentBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.newPayment().eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("APPROVED", terminal)).add()).build();
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(payment9, false));
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(payment9, true));
        Assert.assertTrue((boolean)rules.hasApprovedEFTPOSTransaction(payment9));
    }

    @Test
    public void testHasOutstandingAndApprovedEFTPOSTransactionForRefund() {
        CustomerAccountRules rules = this.getRules();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct refund1 = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)this.newRefund().eft().amount(BigDecimal.TEN)).add()).build();
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(refund1, false));
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(refund1, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(refund1));
        FinancialAct refund2 = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.newRefund().eft().amount(BigDecimal.TEN)).addTransaction("PENDING", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(refund2, false));
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(refund2, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(refund2));
        FinancialAct refund3 = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.newRefund().eft().amount(BigDecimal.TEN)).addTransaction("IN_PROGRESS", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(refund3, false));
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(refund3, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(refund3));
        FinancialAct refund4 = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.newRefund().eft().amount(BigDecimal.TEN)).addTransaction("APPROVED", terminal)).add()).build();
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(refund4, false));
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(refund4, true));
        Assert.assertTrue((boolean)rules.hasApprovedEFTPOSTransaction(refund4));
        FinancialAct refund5 = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.newRefund().eft().amount(BigDecimal.TEN)).addTransaction("DECLINED", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(refund5, false));
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(refund5, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(refund5));
        FinancialAct refund6 = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.newRefund().eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(refund6, false));
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(refund6, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(refund6));
        FinancialAct refund7 = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.newRefund().eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("PENDING", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(refund7, false));
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(refund7, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(refund7));
        FinancialAct refund8 = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.newRefund().eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("IN_PROGRESS", terminal)).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(refund8, false));
        Assert.assertTrue((boolean)rules.hasOutstandingEFTPOSTransaction(refund8, true));
        Assert.assertFalse((boolean)rules.hasApprovedEFTPOSTransaction(refund8));
        FinancialAct refund9 = (FinancialAct)((TestRefundBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.newRefund().eft().amount(BigDecimal.TEN)).addTransaction("ERROR", terminal)).addTransaction("DECLINED", terminal)).addTransaction("APPROVED", terminal)).add()).build();
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(refund9, false));
        Assert.assertFalse((boolean)rules.hasOutstandingEFTPOSTransaction(refund9, true));
        Assert.assertTrue((boolean)rules.hasApprovedEFTPOSTransaction(refund9));
    }

    @Test
    public void testHasOutstandingAndCompletedPaymentProcessorItemForPayment() {
        CustomerAccountRules rules = this.getRules();
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment1 = (FinancialAct)((TestPaymentBuilder)this.newPayment().paymentProcessor(processor, 10)).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment1, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment1, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(payment1));
        FinancialAct payment2 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("PENDING")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment2, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment2, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(payment2));
        FinancialAct payment3 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("IN_PROGRESS")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment3, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment3, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(payment3));
        FinancialAct payment4 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("SUBMITTED")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment4, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment4, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(payment4));
        FinancialAct payment5 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("COMPLETED")).add()).build();
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(payment5, false));
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(payment5, true));
        Assert.assertTrue((boolean)rules.hasCompletedPaymentProcessorItem(payment5));
        FinancialAct payment6 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("CANCELLED")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment6, false));
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(payment6, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(payment6));
        FinancialAct payment7 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment7, false));
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(payment7, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(payment7));
        FinancialAct payment8 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).addTransaction("CANCELLED")).addTransaction("PENDING")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment8, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment8, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(payment8));
        FinancialAct payment9 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).addTransaction("CANCELLED")).addTransaction("IN_PROGRESS")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment9, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment9, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(payment9));
        FinancialAct payment10 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).addTransaction("CANCELLED")).addTransaction("SUBMITTED")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment10, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(payment10, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(payment10));
        FinancialAct payment11 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).addTransaction("CANCELLED")).addTransaction("COMPLETED")).add()).build();
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(payment11, false));
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(payment11, true));
        Assert.assertTrue((boolean)rules.hasCompletedPaymentProcessorItem(payment11));
    }

    @Test
    public void testHasOutstandingAndCompletedPaymentProcessorItemForRefund() {
        CustomerAccountRules rules = this.getRules();
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct refund1 = (FinancialAct)((TestRefundBuilder)this.newRefund().paymentProcessor(processor, 10)).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund1, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund1, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(refund1));
        FinancialAct refund2 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("PENDING")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund2, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund2, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(refund2));
        FinancialAct refund3 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("IN_PROGRESS")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund3, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund3, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(refund3));
        FinancialAct refund4 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("SUBMITTED")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund4, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund4, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(refund4));
        FinancialAct refund5 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("COMPLETED")).add()).build();
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(refund5, false));
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(refund5, true));
        Assert.assertTrue((boolean)rules.hasCompletedPaymentProcessorItem(refund5));
        FinancialAct refund6 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("CANCELLED")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund6, false));
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(refund6, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(refund6));
        FinancialAct refund7 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund7, false));
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(refund7, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(refund7));
        FinancialAct refund8 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).addTransaction("PENDING")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund8, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund8, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(refund8));
        FinancialAct refund9 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).addTransaction("IN_PROGRESS")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund9, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund9, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(refund9));
        FinancialAct refund10 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).addTransaction("SUBMITTED")).add()).build();
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund10, false));
        Assert.assertTrue((boolean)rules.hasOutstandingPaymentProcessorItem(refund10, true));
        Assert.assertFalse((boolean)rules.hasCompletedPaymentProcessorItem(refund10));
        FinancialAct refund11 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).addTransaction("COMPLETED")).add()).build();
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(refund11, false));
        Assert.assertFalse((boolean)rules.hasOutstandingPaymentProcessorItem(refund11, true));
        Assert.assertTrue((boolean)rules.hasCompletedPaymentProcessorItem(refund11));
    }

    @Test
    public void testGetPaymentProcessorTransaction() {
        CustomerAccountRules rules = this.getRules();
        Entity processor = this.paymentProcessorFactory.createPaymentProcessor();
        FinancialAct payment1 = (FinancialAct)((TestPaymentBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)((TestPaymentProcessorPaymentItemBuilder)this.newPayment().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).addTransaction("SUBMITTED")).add()).build();
        FinancialAct paymentTxn1 = rules.getPaymentProcessorTransaction(payment1);
        Assert.assertNotNull((Object)paymentTxn1);
        Assert.assertTrue((boolean)paymentTxn1.isA("act.paymentProcessorPayment"));
        Assert.assertEquals((Object)"SUBMITTED", (Object)paymentTxn1.getStatus());
        FinancialAct payment2 = (FinancialAct)this.newPayment().cash(10).build();
        FinancialAct paymentTxn2 = rules.getPaymentProcessorTransaction(payment2);
        Assert.assertNull((Object)paymentTxn2);
        FinancialAct refund1 = (FinancialAct)((TestRefundBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)((TestPaymentProcessorRefundItemBuilder)this.newRefund().paymentProcessor().processor(processor)).amount(10)).addTransaction("ERROR")).addTransaction("COMPLETED")).add()).build();
        FinancialAct refundTxn = rules.getPaymentProcessorTransaction(refund1);
        Assert.assertNotNull((Object)refundTxn);
        Assert.assertTrue((boolean)refundTxn.isA("act.paymentProcessorRefund"));
        Assert.assertEquals((Object)"COMPLETED", (Object)refundTxn.getStatus());
    }

    private TestPaymentBuilder newPayment() {
        return (TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.getCustomer())).till(this.getTill())).location(this.practiceFactory.createLocation())).status("IN_PROGRESS");
    }

    private TestRefundBuilder newRefund() {
        return (TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.getCustomer())).till(this.getTill())).location(this.practiceFactory.createLocation())).status("IN_PROGRESS");
    }

    private FinancialAct getItem(FinancialAct act) {
        List items = this.getBean((IMObject)act).getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)1L, (long)items.size());
        return (FinancialAct)items.get(0);
    }

    private void checkPostForPaymentRefund(boolean payment) {
        Entity till = this.getTill();
        Assert.assertNull((Object)this.tillBalanceRules.getUnclearedBalance(till));
        this.checkBalance(0);
        int amount = 10;
        this.createInvoice(new Date(), amount);
        this.checkBalance(amount);
        FinancialAct act = payment ? (FinancialAct)this.newPayment().cash(amount).build() : (FinancialAct)this.newRefund().cash(amount).build();
        this.checkBalance(amount);
        Assert.assertNull((Object)this.tillBalanceRules.getUnclearedBalance(till));
        CustomerAccountRules rules = this.getRules();
        Assert.assertTrue((boolean)rules.canPost(act));
        Assert.assertTrue((boolean)rules.getPostStatus(act).canPost());
        rules.post(act);
        FinancialAct balance = this.tillBalanceRules.getUnclearedBalance(till);
        Assert.assertNotNull((Object)balance);
        IMObjectBean bean = this.getBean((IMObject)balance);
        Assert.assertTrue((boolean)bean.hasTarget("items", (IMObject)act));
        this.checkEquals(payment ? amount : -amount, balance.getTotal());
        if (payment) {
            this.checkBalance(0);
        } else {
            this.checkBalance(20);
        }
    }

    private void checkPostForEFTPOS(FinancialAct act, FinancialAct transaction, String status, boolean fail) {
        CustomerAccountRules rules = this.getRules();
        transaction.setStatus(status);
        this.save((IMObject)transaction);
        Assert.assertEquals((Object)(!fail ? 1 : 0), (Object)rules.canPost(act));
        PostStatus postStatus = rules.getPostStatus(act);
        if (fail) {
            Assert.assertFalse((boolean)postStatus.canPost());
            Assert.assertTrue((boolean)postStatus.hasOutstandingEFTPOSTransaction());
            Assert.assertEquals((Object)transaction, (Object)postStatus.getTransaction());
            Assert.assertEquals((Object)this.getBean((IMObject)transaction).getSource("transaction"), (Object)postStatus.getItem());
        } else {
            Assert.assertTrue((boolean)postStatus.canPost());
        }
        try {
            rules.post(act);
            if (fail) {
                Assert.fail((String)"Expected post() to fail");
            }
            act = this.get(act);
            Assert.assertEquals((Object)"POSTED", (Object)act.getStatus());
        }
        catch (CustomerAccountRuleException exception) {
            if (!fail) {
                Assert.fail((String)"Expected post() to succeed");
            }
            Assert.assertEquals((Object)CustomerAccountRuleException.ErrorCode.CannotPostWithOutstandingEFT, (Object)exception.getErrorCode());
            act = this.get(act);
            Assert.assertEquals((Object)"IN_PROGRESS", (Object)act.getStatus());
        }
    }

    private void checkPostForPaymentProcessorTransaction(FinancialAct act, FinancialAct transaction, String status, boolean fail) {
        CustomerAccountRules rules = this.getRules();
        transaction.setStatus(status);
        this.save((IMObject)transaction);
        Assert.assertEquals((Object)(!fail ? 1 : 0), (Object)rules.canPost(act));
        PostStatus postStatus = rules.getPostStatus(act);
        if (fail) {
            Assert.assertFalse((boolean)postStatus.canPost());
            Assert.assertEquals((Object)transaction, (Object)postStatus.getTransaction());
            Assert.assertEquals((Object)this.getBean((IMObject)transaction).getSource("transaction"), (Object)postStatus.getItem());
            if ("PENDING".equals(transaction.getStatus()) || "IN_PROGRESS".equals(transaction.getStatus()) || "CANCELLED".equals(transaction.getStatus()) || "ERROR".equals(transaction.getStatus())) {
                Assert.assertTrue((boolean)postStatus.hasUnsubmittedPaymentProcessorTransaction());
            } else if ("SUBMITTED".equals(transaction.getStatus())) {
                Assert.assertTrue((boolean)postStatus.hasOutstandingPaymentProcessorTransaction());
            } else {
                Assert.fail((String)("Unexpected status " + status));
            }
        } else {
            Assert.assertTrue((boolean)postStatus.canPost());
        }
        try {
            rules.post(act);
            if (fail) {
                Assert.fail((String)"Expected post() to fail");
            }
            act = this.get(act);
            Assert.assertEquals((Object)"POSTED", (Object)act.getStatus());
        }
        catch (CustomerAccountRuleException exception) {
            if (!fail) {
                Assert.fail((String)"Expected post() to succeed");
            }
            Assert.assertEquals((Object)CustomerAccountRuleException.ErrorCode.CannotPostWithOutstandingPaymentProcessorItem, (Object)exception.getErrorCode());
            if (act.isA("act.customerAccountPayment")) {
                Assert.assertEquals((Object)"Cannot finalise Payment. It has an incomplete Payment Processor Payment.", (Object)exception.getMessage());
            } else {
                Assert.assertEquals((Object)"Cannot finalise Refund. It has an incomplete Payment Processor Refund.", (Object)exception.getMessage());
            }
            act = this.get(act);
            Assert.assertEquals((Object)"IN_PROGRESS", (Object)act.getStatus());
        }
    }

    private void checkOverdueBalance(List<FinancialAct> acts, BigDecimal balance, BigDecimal expected) {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        customer.addClassification(this.createAccountType(30, DateUnits.DAYS));
        this.save((IMObject)customer);
        Date startTime = TestHelper.getDate("2007-01-01");
        acts.get(0).setActivityStartTime(startTime);
        this.save(acts);
        this.checkEquals(balance, rules.getBalance(customer));
        this.checkEquals(BigDecimal.ZERO, rules.getOverdueBalance(customer, startTime));
        Date statementDate = DateRules.getDate((Date)startTime, (int)32, (DateUnits)DateUnits.DAYS);
        Date days30 = DateRules.getDate((Date)startTime, (int)30, (DateUnits)DateUnits.DAYS);
        this.checkEquals(BigDecimal.ZERO, rules.getOverdueBalance(customer, days30));
        this.checkEquals(BigDecimal.ZERO, rules.getOverdueBalance(customer, statementDate, rules.getOverdueDate(customer, days30)));
        Date overdueDate = DateRules.getDate((Date)startTime, (int)31, (DateUnits)DateUnits.DAYS);
        this.checkEquals(expected, rules.getOverdueBalance(customer, overdueDate));
        this.checkEquals(expected, rules.getOverdueBalance(customer, statementDate, rules.getOverdueDate(customer, overdueDate)));
    }

    private void checkReversalOfNegativeCharge(String archetype, String itemArchetype, String reversalArchetype, String reversalItemArchetype) {
        Product product1 = this.getProduct();
        Party patient = !itemArchetype.equals("act.customerAccountCounterItem") ? this.getPatient() : null;
        BigDecimal minusOne = BigDecimal.ONE.negate();
        FinancialAct item1 = FinancialTestHelper.createChargeItem(itemArchetype, patient, null, product1, minusOne, BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
        List<FinancialAct> charge = FinancialTestHelper.createCharges(archetype, this.getCustomer(), null, "POSTED", item1);
        this.save(charge);
        FinancialAct reversal = this.checkReverse(charge.get(0), reversalArchetype, false, null);
        FinancialAct reversalItem = this.getItem(reversal);
        FinancialTestHelper.checkItem(reversalItem, reversalItemArchetype, patient, product1, null, -1, null, null, BigDecimal.ZERO, minusOne, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.TEN, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-11L), true);
    }

    private void checkReversalOfChargeWithNegativeQuantity(String archetype, String itemArchetype, String reversalArchetype, String reversalItemArchetype) {
        Product product1 = this.getProduct();
        Product product2 = this.productFactory.createMedication();
        Party patient = !itemArchetype.equals("act.customerAccountCounterItem") ? this.getPatient() : null;
        FinancialAct item1 = FinancialTestHelper.createChargeItem(itemArchetype, patient, null, product1, BigDecimal.ONE, BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
        BigDecimal minusOne = BigDecimal.ONE.negate();
        FinancialAct item2 = FinancialTestHelper.createChargeItem(itemArchetype, patient, null, product2, minusOne, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
        List<FinancialAct> charge = FinancialTestHelper.createCharges(archetype, this.getCustomer(), null, "POSTED", item1, item2);
        this.save(charge);
        FinancialAct reversal = this.checkReverse(charge.get(0), reversalArchetype, false, null);
        IMObjectBean bean = this.getBean((IMObject)reversal);
        List items = bean.getTargets("items", FinancialAct.class);
        FinancialAct item1Reversal = (FinancialAct)FinancialTestHelper.find(items, patient, product1);
        FinancialAct item2Reversal = (FinancialAct)FinancialTestHelper.find(items, patient, product2);
        FinancialTestHelper.checkItem(item1Reversal, reversalItemArchetype, patient, product1, null, -1, null, null, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.TEN, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(11L), true);
        FinancialTestHelper.checkItem(item2Reversal, reversalItemArchetype, patient, product2, null, -1, null, null, BigDecimal.ZERO, minusOne, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2L), true);
    }

    private void checkInvoiceInGapClaim(String status, FinancialAct credit, boolean allocated) {
        this.checkInvoiceInGapClaim(status, Collections.singletonList(credit), allocated);
    }

    private void checkInvoiceInGapClaim(String status, List<FinancialAct> credit, boolean allocated) {
        List<FinancialAct> acts = this.createChargesInvoice(MathRules.ONE_HUNDRED);
        this.save(acts);
        FinancialAct invoiceItem = acts.get(1);
        Party location = this.practiceFactory.createLocation();
        Party customer = this.getCustomer();
        Act policy = this.insuranceFactory.createPolicy(customer, this.getPatient(), this.insuranceFactory.createInsurer(), "12345");
        this.insuranceFactory.newClaim().policy(policy).location(location).clinician(this.userFactory.createClinician()).claimHandler(this.userFactory.createUser()).gapClaim(true).item(invoiceItem).status(status).build();
        this.save(credit);
        FinancialAct invoice = (FinancialAct)this.get((IMObject)acts.get(0));
        if (allocated) {
            this.checkEquals(credit.get(0).getAllocatedAmount(), invoice.getAllocatedAmount());
        } else {
            this.checkEquals(BigDecimal.ZERO, invoice.getAllocatedAmount());
        }
    }

    private void checkOpeningBalance(FinancialAct act, Party customer, Date date, BigDecimal total, boolean credit) {
        this.checkBalanceAct(act, "act.customerAccountOpeningBalance", customer, date, total, credit);
    }

    private void checkClosingBalance(FinancialAct act, Party customer, Date date, BigDecimal total, boolean credit) {
        this.checkBalanceAct(act, "act.customerAccountClosingBalance", customer, date, total, credit);
    }

    private void checkBalanceAct(FinancialAct act, String archetype, Party customer, Date date, BigDecimal total, boolean credit) {
        Assert.assertTrue((boolean)act.isA(archetype));
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)customer.getObjectReference(), (Object)bean.getTargetRef("customer"));
        Assert.assertEquals((Object)date, (Object)act.getActivityStartTime());
        Assert.assertNull((Object)act.getActivityEndTime());
        this.checkEquals(total, act.getTotal());
        Assert.assertEquals((Object)credit, (Object)act.isCredit());
    }

    private void checkNegativeAmounts(FinancialAct act) {
        this.checkNegativeAmounts(Collections.singletonList(act));
    }

    private void checkNegativeAmounts(List<FinancialAct> acts) {
        try {
            this.save(acts);
            Assert.fail((String)("Expected save of negative " + acts.get(0).getArchetype() + " to fail"));
        }
        catch (ValidationException expected) {
            List errors = expected.getErrors();
            Assert.assertEquals((long)1L, (long)errors.size());
            String message = ((ValidationError)errors.get(0)).getMessage();
            Assert.assertTrue(("Value must be >= 0.0".equals(message) || "Value must be > 0.0".equals(message) ? 1 : 0) != 0);
        }
    }

    private void checkAddToBalance(List<FinancialAct> acts) {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        IMObjectBean bean = this.getBean((IMObject)acts.get(0));
        Assert.assertTrue((boolean)bean.getValues("accountBalance").isEmpty());
        this.save(acts);
        Act act = (Act)this.get((IMObject)acts.get(0));
        bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)this.getCustomer(), (Object)bean.getTarget("accountBalance"));
        Assert.assertTrue((boolean)rules.hasAccountActs(customer));
        try {
            this.save((IMObject)this.createInitialBalance(BigDecimal.TEN));
            Assert.fail((String)"Expected save of Initial Balance to fail");
        }
        catch (RuleEngineException expected) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)expected);
            Assert.assertTrue((boolean)(rootCause instanceof CustomerAccountRuleException));
            CustomerAccountRuleException cause = (CustomerAccountRuleException)rootCause;
            Assert.assertEquals((Object)CustomerAccountRuleException.ErrorCode.CannotCreateInitialBalance, (Object)cause.getErrorCode());
        }
    }

    private void checkAddToBalance(FinancialAct act) {
        this.checkAddToBalance(Collections.singletonList(act));
    }

    private void checkCalculateBalanceForSameAmount(FinancialAct debit, FinancialAct credit) {
        this.checkCalculateBalanceForSameAmount(Collections.singletonList(debit), Collections.singletonList(credit));
    }

    private void checkCalculateBalanceForSameAmount(List<FinancialAct> debits, List<FinancialAct> credits) {
        FinancialAct debit = debits.get(0);
        FinancialAct credit = credits.get(0);
        BigDecimal amount = credit.getTotal();
        this.checkEquals(amount, debit.getTotal());
        Assert.assertTrue((boolean)credit.isCredit());
        Assert.assertFalse((boolean)debit.isCredit());
        this.save(debits);
        debit = this.get(debit);
        this.checkEquals(amount, debit.getTotal());
        this.checkAllocation(debit, BigDecimal.ZERO, new FinancialAct[0]);
        this.checkBalance(amount);
        this.save(credits);
        credit = this.get(credit);
        debit = this.get(debit);
        this.checkEquals(amount, credit.getTotal());
        this.checkAllocation(credit, amount, debit);
        this.checkEquals(amount, debit.getTotal());
        this.checkAllocation(debit, amount, credit);
        this.checkBalance(BigDecimal.ZERO);
    }

    private void checkBalance(int amount) {
        this.checkBalance(BigDecimal.valueOf(amount));
    }

    private void checkBalance(BigDecimal amount) {
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        this.checkEquals(amount, rules.getBalance(customer));
        this.checkEquals(amount, rules.getDefinitiveBalance(customer));
    }

    private FinancialAct checkAllocation(FinancialAct act, int expectedAllocation, FinancialAct ... acts) {
        return this.checkAllocation(act, BigDecimal.valueOf(expectedAllocation), acts);
    }

    private FinancialAct checkAllocation(FinancialAct act, BigDecimal expectedAllocation, FinancialAct ... acts) {
        act = this.get(act);
        this.checkEquals(expectedAllocation, act.getAllocatedAmount());
        IMObjectBean bean = this.getBean((IMObject)act);
        BigDecimal total = BigDecimal.ZERO;
        List allocations = bean.getValues("allocation", ActRelationship.class);
        Assert.assertEquals((long)allocations.size(), (long)acts.length);
        ArrayList<FinancialAct> matches = new ArrayList<FinancialAct>();
        for (ActRelationship relationship : allocations) {
            boolean credit;
            boolean bl = credit = act.isCredit() && act.getTotal().signum() != -1 || !act.isCredit() && act.getTotal().signum() == -1;
            if (credit) {
                Assert.assertEquals((Object)act.getObjectReference(), (Object)relationship.getTarget());
                for (FinancialAct source : acts) {
                    if (!source.getObjectReference().equals((Object)relationship.getSource())) continue;
                    matches.add(source);
                    break;
                }
            } else {
                Assert.assertEquals((Object)act.getObjectReference(), (Object)relationship.getSource());
                for (FinancialAct target : acts) {
                    if (!target.getObjectReference().equals((Object)relationship.getTarget())) continue;
                    matches.add(target);
                    break;
                }
            }
            IMObjectBean relBean = this.getBean((IMObject)relationship);
            BigDecimal allocation = relBean.getBigDecimal("allocatedAmount");
            total = total.add(allocation);
        }
        this.checkEquals(expectedAllocation, total);
        Assert.assertEquals((long)acts.length, (long)matches.size());
        return act;
    }

    private void checkReverseInvoice() {
        List<FinancialAct> invoice = this.createChargesInvoice(new BigDecimal(100));
        Act estimate = (Act)this.accountFactory.newEstimate().customer(this.getCustomer()).item().patient(this.getPatient()).product(this.getProduct()).highQuantity(1).highUnitPrice(10).add().build();
        IMObjectBean bean = this.getBean((IMObject)estimate);
        bean.addTarget("invoice", (IMObject)invoice.get(0), "estimates");
        ArrayList<FinancialAct> toSave = new ArrayList<FinancialAct>(invoice);
        toSave.add((FinancialAct)estimate);
        this.checkReverseCharge(invoice, toSave, "act.customerAccountChargesCredit", "act.customerAccountCreditItem");
    }

    private void checkReverse(FinancialAct act, String shortName) {
        this.checkReverse(act, shortName, null, false, null, null);
    }

    private void checkReverseCharge(List<FinancialAct> acts, String shortName, String itemShortName) {
        this.checkReverseCharge(acts, new ArrayList<FinancialAct>(acts), shortName, itemShortName);
    }

    private void checkReverseCharge(List<FinancialAct> acts, List<Act> toSave, String shortName, String itemShortName) {
        BigDecimal quantity = new BigDecimal("10");
        this.initStockQuantity(quantity);
        this.save(toSave);
        if (!acts.get(0).isCredit()) {
            this.checkStock(quantity.subtract(BigDecimal.ONE));
        } else {
            this.checkStock(quantity.add(BigDecimal.ONE));
        }
        this.checkReverse(acts.get(0), shortName, itemShortName, false, null, null);
        this.checkStock(quantity);
    }

    private void initStockQuantity(BigDecimal quantity) {
        ((AbstractTestIMObjectBuilder)this.productFactory.updateProduct(this.get(this.getProduct())).stockQuantity(this.getStockLocation(), quantity)).build();
    }

    private void checkStock(BigDecimal expected) {
        Product product = this.get(this.getProduct());
        BigDecimal stock = this.stockRules.getStock(product, this.getStockLocation());
        this.checkEquals(expected, stock);
    }

    private FinancialAct checkReverse(FinancialAct act, String shortName, String itemShortName, boolean hide, FinancialAct tillBalance, BigDecimal roundedAmount) {
        FinancialAct reversal = this.checkReverse(act, shortName, hide, tillBalance);
        IMObjectBean bean = this.getBean((IMObject)reversal);
        if (itemShortName != null) {
            List items = bean.getTargets("items", Act.class);
            Assert.assertEquals((long)1L, (long)items.size());
            Act item = (Act)items.get(0);
            Assert.assertTrue((boolean)item.isA(itemShortName));
            if (item.isA(new String[]{"act.customerAccountPaymentCash", "act.customerAccountRefundCash"})) {
                IMObjectBean itemBean = this.getBean((IMObject)item);
                this.checkEquals(roundedAmount, itemBean.getBigDecimal("roundedAmount"));
            }
            this.checkEquals(act.getTotal(), ((FinancialAct)item).getTotal());
        } else if (bean.hasNode("items")) {
            List items = bean.getTargets("items", Act.class);
            Assert.assertEquals((long)0L, (long)items.size());
        }
        return reversal;
    }

    private FinancialAct checkReverse(FinancialAct act, String archetype, boolean hide, FinancialAct tillBalance) {
        BigDecimal reverseBalance;
        BigDecimal preBalance;
        BigDecimal change;
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        BigDecimal currentBalance = rules.getBalance(customer);
        BigDecimal amount = act.getTotal();
        BigDecimal bigDecimal = change = act.isCredit() ? amount.negate() : amount;
        if (!act.isNew()) {
            preBalance = currentBalance;
            reverseBalance = currentBalance.subtract(change);
        } else {
            preBalance = currentBalance.add(change);
            reverseBalance = currentBalance;
            act.setStatus("POSTED");
            this.save((IMObject)act);
        }
        this.checkBalance(preBalance);
        Date now = new Date();
        FinancialAct reversal = rules.reverse(act, now, "Test reversal", null, hide, tillBalance);
        Assert.assertTrue((boolean)reversal.isA(archetype));
        IMObjectBean bean = this.getBean((IMObject)reversal);
        Assert.assertEquals((Object)customer, (Object)bean.getTarget("customer"));
        Assert.assertTrue((boolean)rules.isReversed(act));
        Assert.assertFalse((boolean)rules.isReversed(reversal));
        IMObjectBean original = this.getBean((IMObject)act);
        Assert.assertTrue((boolean)original.hasTarget("reversal", (IMObject)reversal));
        Assert.assertEquals((Object)"Test reversal", (Object)bean.getString("notes"));
        Assert.assertEquals((Object)Long.toString(act.getId()), (Object)bean.getString("reference"));
        Assert.assertEquals((Object)hide, (Object)original.getBoolean("hide"));
        Assert.assertEquals((Object)hide, (Object)bean.getBoolean("hide"));
        this.checkAllocation(act, act.getTotal().abs(), reversal);
        this.checkAllocation(reversal, act.getTotal().abs(), act);
        this.checkBalance(reverseBalance);
        return reversal;
    }

    private void checkReverseOther(FinancialAct act, String archetype, String itemArchetype, String paymentType) {
        FinancialAct reversal = this.checkReverse(act, archetype, itemArchetype, false, null, null);
        IMObjectBean bean = this.getBean((IMObject)this.getItem(reversal));
        Assert.assertEquals((Object)paymentType, (Object)bean.getString("paymentType"));
    }

    private void checkReversalDoesntAffectClaim(String status) {
        List<FinancialAct> invoiceActs = this.createChargesInvoice(BigDecimal.TEN, DateRules.getYesterday());
        this.save(invoiceActs);
        FinancialAct invoice = invoiceActs.get(0);
        FinancialAct item = invoiceActs.get(1);
        this.checkBalance(10);
        FinancialAct payment = this.createPayment(10);
        this.save((IMObject)payment);
        this.checkAllocation(invoice, 10, payment);
        this.checkAllocation(payment, 10, invoice);
        this.checkBalance(0);
        Act policy = this.insuranceFactory.createPolicy(this.getCustomer(), this.getPatient(), this.insuranceFactory.createInsurer(), "12345");
        User clinician = this.userFactory.createClinician();
        this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).item(item).status(status).build();
        FinancialAct refund = this.getRules().reverse(payment, new Date());
        this.checkAllocation(payment, 10, invoice);
        this.checkAllocation(invoice, 10, payment);
        this.checkBalance(10);
        this.checkAllocation(refund, 0, new FinancialAct[0]);
    }

    private void checkReversalCanAffectClaim(String status) {
        List<FinancialAct> invoiceActs = this.createChargesInvoice(BigDecimal.TEN, DateRules.getYesterday());
        this.save(invoiceActs);
        FinancialAct invoice = invoiceActs.get(0);
        FinancialAct item = invoiceActs.get(1);
        this.checkBalance(10);
        FinancialAct payment = this.createPayment(10);
        this.save((IMObject)payment);
        this.checkAllocation(invoice, 10, payment);
        this.checkAllocation(payment, 10, invoice);
        this.checkBalance(0);
        Act policy = this.insuranceFactory.createPolicy(this.getCustomer(), this.getPatient(), this.insuranceFactory.createInsurer(), "12345");
        User clinician = this.userFactory.createClinician();
        this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).item(item).status(status).build();
        FinancialAct refund = this.getRules().reverse(payment, new Date());
        this.checkAllocation(invoice, 0, new FinancialAct[0]);
        this.checkAllocation(payment, 10, refund);
        this.checkAllocation(refund, 10, payment);
        this.checkBalance(10);
    }

    private FinancialAct createInvoice(Date startTime, int amount) {
        return this.createInvoice(startTime, BigDecimal.valueOf(amount), "POSTED");
    }

    private FinancialAct createInvoice(Date startTime, BigDecimal amount, String status) {
        List<FinancialAct> invoices = this.createChargesInvoice(amount);
        FinancialAct invoice = invoices.get(0);
        invoice.setActivityStartTime(startTime);
        invoice.setStatus(status);
        this.save(invoices);
        return invoice;
    }

    private FinancialAct createCredit(Date startTime, String status) {
        List<FinancialAct> acts = this.createChargesCredit(BigDecimal.TEN);
        FinancialAct invoice = acts.get(0);
        invoice.setActivityStartTime(startTime);
        invoice.setStatus(status);
        this.save(acts);
        return invoice;
    }

    private void createCredit(BigDecimal amount, Date startTime) {
        List<FinancialAct> credits = this.createChargesCredit(amount);
        FinancialAct credit = credits.get(0);
        credit.setActivityStartTime(startTime);
        this.save(credits);
    }
}

