/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRuleException;

public class CustomerAccountRuleExceptionTestCase {
    @Test
    public void testMessages() {
        Locale.setDefault(Locale.US);
        Assert.assertEquals((String)"Need to update tests to incorporate new messages", (long)7L, (long)CustomerAccountRuleException.ErrorCode.values().length);
        this.checkException(CustomerAccountRuleException.ErrorCode.MissingCustomer, "No Customer specified in act foo", "foo");
        this.checkException(CustomerAccountRuleException.ErrorCode.InvalidBalance, "Invalid foo0 total. Expected $0.00 but got $1.00", "foo0", BigDecimal.ZERO, BigDecimal.ONE);
        this.checkException(CustomerAccountRuleException.ErrorCode.CannotCreateInitialBalance, "Cannot create Initial Balance. The customer has an existing balance.", new Object[0]);
        this.checkException(CustomerAccountRuleException.ErrorCode.AlreadyPosted, "foo has already been finalised", "foo");
        this.checkException(CustomerAccountRuleException.ErrorCode.CannotPostAct, "Cannot finalise foo", "foo");
        this.checkException(CustomerAccountRuleException.ErrorCode.CannotPostWithOutstandingEFT, "Cannot finalise Payment. It has an incomplete EFTPOS transaction.", "Payment");
        this.checkException(CustomerAccountRuleException.ErrorCode.CannotPostWithOutstandingPaymentProcessorItem, "Cannot finalise Payment. It has an incomplete Payment Processor Payment.", "Payment", "Payment Processor Payment");
    }

    private void checkException(CustomerAccountRuleException.ErrorCode code, String expected, Object ... args) {
        CustomerAccountRuleException exception = new CustomerAccountRuleException(code, args);
        Assert.assertEquals((Object)code, (Object)exception.getErrorCode());
        Assert.assertEquals((Object)expected, (Object)exception.getMessage());
    }
}

