/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.openvpms.archetype.rules.doc.AbstractImageService;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.DisposableBean;

public class TestImageService
extends AbstractImageService
implements DisposableBean {
    private final File dir;
    private final boolean delete;

    public TestImageService(DocumentHandlers handlers, ArchetypeService service) throws IOException {
        this(null, handlers, service);
    }

    public TestImageService(File dir, DocumentHandlers handlers, ArchetypeService service) throws IOException {
        super(handlers, service);
        if (dir == null) {
            dir = Files.createTempDirectory("TestImageCache", new FileAttribute[0]).toFile();
            this.delete = true;
        } else {
            this.delete = false;
        }
        this.dir = dir;
    }

    public void destroy() throws Exception {
        if (this.delete) {
            FileUtils.deleteDirectory((File)this.dir);
        }
    }

    protected File getDir() {
        return this.dir;
    }
}

