/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.doc.LogoCache;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestLogoBuilder;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class LogoCacheTestCase
extends ArchetypeServiceTest {
    @Autowired
    private DocumentRules documentRules;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    private LogoCache cache;

    @After
    public void tearDown() {
        this.cache.destroy();
    }

    @Test
    public void testUpdateLogo() {
        Party practice = (Party)this.practiceFactory.newPractice().build();
        this.removeLogos((Entity)practice);
        this.initCache();
        Assert.assertNull((Object)this.cache.getLogo((Entity)practice));
        Document image1 = this.documentFactory.createImage();
        ((TestPracticeBuilder)this.practiceFactory.updatePractice(practice).logo(image1)).build();
        DocumentAct logo1 = this.cache.getLogo((Entity)practice);
        Assert.assertNotNull((Object)logo1);
        Assert.assertEquals((Object)image1.getObjectReference(), (Object)logo1.getDocument());
        Document image2 = this.documentFactory.createImage();
        logo1.setDocument(image2.getObjectReference());
        this.save((IMObject)logo1);
        DocumentAct logo2 = this.cache.getLogo((Entity)practice);
        Assert.assertEquals((Object)logo1, (Object)logo2);
        Assert.assertEquals((Object)image2.getObjectReference(), (Object)logo2.getDocument());
        this.removeLogo(logo2);
        Assert.assertNull((Object)this.cache.getLogo((Entity)practice));
    }

    @Test
    public void testMultipleLogos() {
        this.initCache();
        Party location = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().logo(this.documentFactory.createImage())).build();
        DocumentAct logo1 = this.cache.getLogo((Entity)location);
        Assert.assertNotNull((Object)logo1);
        DocumentAct logo2 = (DocumentAct)new TestLogoBuilder(false, (ArchetypeService)this.getArchetypeService()).logo(this.documentFactory.createImage()).owner((Entity)location).build();
        Assert.assertEquals((Object)logo1, (Object)this.cache.getLogo((Entity)location));
        this.removeLogo(logo1);
        Assert.assertEquals((Object)logo2, (Object)this.cache.getLogo((Entity)location));
    }

    @Test
    public void testInactive() {
        TestLocationBuilder builder = this.practiceFactory.newLocation();
        Party location1 = (Party)((TestLocationBuilder)builder.logo(this.documentFactory.createImage())).build();
        DocumentAct logo1 = builder.getLogo();
        Party location2 = (Party)((TestLocationBuilder)((TestLocationBuilder)builder.logo(this.documentFactory.createImage())).active(false)).build();
        DocumentAct logo2 = builder.getLogo();
        this.initCache();
        Assert.assertTrue((boolean)this.cache.getObjects().contains(logo1));
        Assert.assertFalse((boolean)this.cache.getObjects().contains(logo2));
        Assert.assertEquals((Object)logo1, (Object)this.cache.getLogo((Entity)location1));
        Assert.assertEquals((Object)logo2, (Object)this.cache.getLogo((Entity)location2));
        Assert.assertTrue((boolean)this.cache.getObjects().contains(logo2));
    }

    private void initCache() {
        this.cache = new LogoCache(this.getArchetypeService(), this.documentRules, true);
    }

    private void removeLogos(Entity entity) {
        DocumentAct act;
        while ((act = this.documentRules.getLogo(entity)) != null) {
            this.removeLogo(act);
        }
    }

    private void removeLogo(DocumentAct act) {
        Reference document = act.getDocument();
        if (document != null) {
            act.setDocument(null);
            this.save((IMObject)act);
            this.getArchetypeService().remove(document);
        }
        this.remove((IMObject)act);
    }
}

