/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import javax.print.attribute.standard.MediaTray;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentTemplatePrinter;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentTemplatePrinterTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testDefaults() {
        EntityRelationship relationship = this.create("entityRelationship.documentTemplatePrinter", EntityRelationship.class);
        DocumentTemplatePrinter printer = new DocumentTemplatePrinter(relationship, (ArchetypeService)this.getArchetypeService());
        Assert.assertNull((Object)printer.getPrinter());
        Assert.assertNull((Object)printer.getPaperTray());
        Assert.assertTrue((boolean)printer.getInteractive());
        Assert.assertNull((Object)printer.getMediaTray());
        Assert.assertNull((Object)printer.getTemplate());
        Assert.assertNull((Object)printer.getTemplateRef());
        Assert.assertNull((Object)printer.getLocation());
        Assert.assertNull((Object)printer.getLocationRef());
    }

    @Test
    public void testAccessors() {
        Party location = TestHelper.createLocation();
        TestDocumentTemplateBuilder builder = this.documentFactory.newTemplate();
        Entity template = (Entity)builder.printer().location(location).printer(":printer").paperTray("TOP").interactive(false).add().build();
        IMObjectBean bean = this.getBean((IMObject)template);
        EntityRelationship relationship = (EntityRelationship)bean.getObject("printers", EntityRelationship.class);
        DocumentTemplatePrinter printer = new DocumentTemplatePrinter(relationship, (ArchetypeService)this.getArchetypeService());
        printer = new DocumentTemplatePrinter(this.get(printer.getRelationship()), (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)new PrinterReference(null, "printer"), (Object)printer.getPrinter());
        Assert.assertEquals((Object)"TOP", (Object)printer.getPaperTray());
        Assert.assertFalse((boolean)printer.getInteractive());
        Assert.assertEquals((Object)MediaTray.TOP, (Object)printer.getMediaTray());
        Assert.assertEquals((Object)template, (Object)printer.getTemplate());
        Assert.assertEquals((Object)template.getObjectReference(), (Object)printer.getTemplateRef());
        Assert.assertEquals((Object)location, (Object)printer.getLocation());
        Assert.assertEquals((Object)location.getObjectReference(), (Object)printer.getLocationRef());
    }
}

