/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.contact;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.contact.PracticeAddressFormatter;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;

public class PracticeAddressFormatterTestCase
extends ArchetypeServiceTest {
    @Test
    public void testFormat() {
        String singleLine = "concat($address, '|', $suburb, '|', $state, '|', $postcode)";
        String multiLine = "concat($address, $nl, $suburb, '|', $state.code, '|', $postcode)";
        PracticeService service = this.createPracticeService(singleLine, multiLine);
        PracticeAddressFormatter formatter = new PracticeAddressFormatter(service, this.getArchetypeService(), this.getLookupService());
        Contact contact = TestHelper.createLocationContact("123 Smith St", "RESEARCH", "VIC", "3095");
        Assert.assertEquals((Object)"123 Smith St|Research|Vic|3095", (Object)formatter.format(contact, true));
        Assert.assertEquals((Object)"123 Smith St\nResearch|VIC|3095", (Object)formatter.format(contact, false));
        IMObjectBean bean = this.getBean((IMObject)service.getPractice());
        bean.setValue("addressFormat", null);
        Assert.assertEquals((Object)"123 Smith St, Research Vic 3095", (Object)formatter.format(contact, true));
        Assert.assertEquals((Object)"123 Smith St\nResearch Vic 3095", (Object)formatter.format(contact, false));
    }

    private PracticeService createPracticeService(String singleLine, String multiLine) {
        Lookup lookup = this.createAddressFormat(singleLine, multiLine);
        Party practice = this.create("party.organisationPractice", Party.class);
        IMObjectBean practiceBean = this.getBean((IMObject)practice);
        practiceBean.setValue("addressFormat", (Object)lookup.getCode());
        PracticeService service = (PracticeService)Mockito.mock(PracticeService.class);
        Mockito.when((Object)service.getPractice()).thenReturn((Object)practice);
        return service;
    }

    private Lookup createAddressFormat(String singleLine, String multiLine) {
        Lookup lookup = TestHelper.getLookup("lookup.addressformat", "TEST_ADDRESS_FORMAT");
        IMObjectBean bean = this.getBean((IMObject)lookup);
        bean.setValue("singleLineFormat", (Object)singleLine);
        bean.setValue("multiLineFormat", (Object)multiLine);
        bean.save();
        return lookup;
    }

    @Test
    public void testNull() {
        String singleLine = "concat($address, '|', toUpperCase($suburb), '|', $state, '|', $postcode)";
        String multiLine = "concat($address, $nl, toUpperCase($suburb), '|', $state.code, '|', $postcode)";
        PracticeService service = this.createPracticeService(singleLine, multiLine);
        PracticeAddressFormatter formatter = new PracticeAddressFormatter(service, this.getArchetypeService(), this.getLookupService());
        Contact contact = TestHelper.createLocationContact("123 Smith St", "RESEARCH", "VIC", "3095");
        Assert.assertEquals((Object)"123 Smith St|RESEARCH|Vic|3095", (Object)formatter.format(contact, true));
        Assert.assertEquals((Object)"123 Smith St\nRESEARCH|VIC|3095", (Object)formatter.format(contact, false));
        IMObjectBean bean = this.getBean((IMObject)contact);
        bean.setValue("address", null);
        bean.setValue("suburb", null);
        bean.setValue("postcode", null);
        bean.setValue("state", null);
        Assert.assertEquals((Object)"|||", (Object)formatter.format(contact, true));
        Assert.assertEquals((Object)"\n||", (Object)formatter.format(contact, false));
    }
}

