/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.math;

import java.math.BigDecimal;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.math.MathFunctions;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;

public class MathFunctionsTestCase {
    private final MathFunctions math = new MathFunctions();
    private JXPathContext ctx;

    @Before
    public void setUp() {
        ObjectFunctions functions = new ObjectFunctions((Object)this.math, "math");
        this.ctx = JXPathHelper.newContext((Object)new Object(), (Functions)functions);
    }

    @Test
    public void testRoundAmount() {
        TestHelper.checkEquals(new BigDecimal("12.12"), this.math.roundAmount(new BigDecimal("12.123")));
        TestHelper.checkEquals(new BigDecimal("1.11"), this.math.roundAmount(new BigDecimal("1.105")));
        TestHelper.checkEquals(new BigDecimal("1.15"), this.math.roundAmount(new BigDecimal("1.145")));
        TestHelper.checkEquals(new BigDecimal("1.14"), this.math.roundAmount(new BigDecimal("1.144")));
        TestHelper.checkEquals(new BigDecimal("1.12"), (BigDecimal)this.ctx.getValue("math:roundAmount(1.124)"));
        TestHelper.checkEquals(new BigDecimal("1.13"), (BigDecimal)this.ctx.getValue("math:roundAmount(1.125)"));
    }

    @Test
    public void testRound() {
        TestHelper.checkEquals(new BigDecimal("12.12"), this.math.round(new BigDecimal("12.123"), 2));
        TestHelper.checkEquals(new BigDecimal("1.11"), this.math.round(new BigDecimal("1.105"), 2));
        TestHelper.checkEquals(new BigDecimal("1.15"), this.math.round(new BigDecimal("1.145"), 2));
        TestHelper.checkEquals(new BigDecimal("1.14"), this.math.round(new BigDecimal("1.144"), 2));
        TestHelper.checkEquals(new BigDecimal("1.12"), (BigDecimal)this.ctx.getValue("math:round(1.124, 2)"));
        TestHelper.checkEquals(new BigDecimal("1.13"), (BigDecimal)this.ctx.getValue("math:round(1.125, 2)"));
        TestHelper.checkEquals(new BigDecimal("3.143"), (BigDecimal)this.ctx.getValue("math:round(22 div 7, 3)"));
    }

    @Test
    public void testPow() {
        TestHelper.checkEquals(BigDecimal.valueOf(16L), this.math.pow(BigDecimal.valueOf(2L), 4));
        TestHelper.checkEquals(new BigDecimal("9.8596"), this.math.pow(BigDecimal.valueOf(3.14), 2));
        TestHelper.checkEquals(new BigDecimal("9.8596"), this.math.pow(BigDecimal.valueOf(3.14), 2));
        TestHelper.checkEquals(new BigDecimal("2"), this.math.pow(BigDecimal.valueOf(4L), new BigDecimal("0.5")));
        TestHelper.checkEquals(BigDecimal.valueOf(16L), (BigDecimal)this.ctx.getValue("math:pow(2, 4)"));
        TestHelper.checkEquals(new BigDecimal("9.8596"), (BigDecimal)this.ctx.getValue("math:pow(3.14, 2)"));
        TestHelper.checkEquals(new BigDecimal("2"), (BigDecimal)this.ctx.getValue("math:pow(4, 0.5)"));
    }
}

