/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.letterhead;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.openvpms.archetype.function.letterhead.LetterheadFunctions;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.doc.ImageService;
import org.openvpms.archetype.rules.doc.LogoService;
import org.openvpms.archetype.rules.doc.TestImageService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestLetterheadBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class LetterheadFunctionsTestCase
extends ArchetypeServiceTest {
    @Rule
    public TemporaryFolder dir = new TemporaryFolder();
    @Autowired
    private DocumentHandlers handlers;
    @Autowired
    private DocumentRules documentRules;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    private LogoService logoService;

    @Before
    public void setUp() throws Exception {
        TestImageService imageService = new TestImageService(this.dir.getRoot(), this.handlers, (ArchetypeService)this.getArchetypeService());
        this.logoService = new LogoService((ImageService)imageService, this.getArchetypeService(), this.documentRules);
    }

    @After
    public void tearDown() {
        this.logoService.destroy();
    }

    @Test
    public void testLogo() throws IOException {
        Entity letterhead1 = (Entity)this.documentFactory.newLetterhead().build();
        Party location1 = (Party)this.practiceFactory.newLocation().letterhead(letterhead1).build();
        this.checkLogo(location1, null);
        File logoFile = this.dir.newFile("logo.png");
        FileUtils.write((File)logoFile, (CharSequence)"some data", (Charset)StandardCharsets.UTF_8);
        Entity letterhead2 = (Entity)this.documentFactory.newLetterhead().logoFile(logoFile.getPath()).build();
        Party location2 = (Party)this.practiceFactory.newLocation().letterhead(letterhead2).build();
        this.checkLogo(location2, logoFile.toURI().toURL());
        TestLetterheadBuilder builder = this.documentFactory.newLetterhead();
        Entity letterhead3 = (Entity)builder.logo(this.documentFactory.createDocument(logoFile)).build();
        Party location3 = (Party)this.practiceFactory.newLocation().letterhead(letterhead3).build();
        DocumentAct logo = builder.getLogo();
        String url = this.dir.getRoot().toURI().toURL().toString();
        url = url + logo.getId() + "_" + logo.getVersion() + "_" + logoFile.getName();
        this.checkLogo(location3, new URL(url));
        Entity letterhead4 = (Entity)this.documentFactory.newLetterhead().logoFile(logoFile.getPath()).logo(this.documentFactory.createDocument(logoFile)).build();
        Party location4 = (Party)this.practiceFactory.newLocation().letterhead(letterhead4).build();
        this.checkLogo(location4, logoFile.toURI().toURL());
        Party location5 = this.practiceFactory.createLocation();
        this.checkLogo(location5, null);
        JXPathContext context6 = this.createContext(new Object());
        context6.getVariables().declareVariable("OpenVPMS.location", null);
        this.checkLogo(context6, "$OpenVPMS.location", null);
        JXPathContext context7 = this.createContext(new Object());
        this.checkLogo(context7, null, null);
    }

    private void checkLogo(Party location, URL expected) {
        this.checkLogo(this.createContext(location), ".", expected);
    }

    private void checkLogo(JXPathContext context, String parameter, URL expected) {
        URL actual = (URL)context.getValue("letterhead:logo(" + parameter + ")");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private JXPathContext createContext(Object object) {
        LetterheadFunctions letterhead = new LetterheadFunctions(this.logoService, (ArchetypeService)this.getArchetypeService());
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)letterhead);
        return JXPathHelper.newContext((Object)object, (Functions)library);
    }
}

