/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.insurance;

import java.util.Date;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.function.insurance.InsuranceFunctions;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.insurance.TestPolicyBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;
import org.springframework.beans.factory.annotation.Autowired;

public class InsuranceFunctionsTestCase
extends ArchetypeServiceTest {
    @Autowired
    private InsuranceRules insuranceRules;
    @Autowired
    private PatientRules patientRules;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testClaimed() {
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient();
        TestInvoiceBuilder invoiceBuilder = this.accountFactory.newInvoice();
        ((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)invoiceBuilder.customer(customer)).item().patient(patient)).product(this.productFactory.createService())).unitPrice(10)).add()).item().patient(patient)).product(this.productFactory.createService())).unitPrice(20)).add()).build();
        FinancialAct invoiceItem1 = invoiceBuilder.getItems().get(0);
        FinancialAct invoiceItem2 = invoiceBuilder.getItems().get(1);
        Party insurer = this.insuranceFactory.createInsurer();
        Act policy = this.insuranceFactory.createPolicy(customer, patient, insurer, "AB12345");
        FinancialAct claim = (FinancialAct)this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(this.userFactory.createClinician()).claimHandler(this.userFactory.createUser()).item().diagnosis("VENOM_328", "Abcess", "328").invoiceItems(invoiceItem1).add().build();
        JXPathContext context1 = this.createContext(invoiceItem1);
        context1.getVariables().declareVariable("claim", (Object)claim);
        JXPathContext context2 = this.createContext(invoiceItem2);
        context2.getVariables().declareVariable("claim", (Object)claim);
        Assert.assertEquals((Object)true, (Object)context1.getValue("insurance:claimed($claim, .)"));
        Assert.assertEquals((Object)false, (Object)context2.getValue("insurance:claimed($claim, .)"));
    }

    @Test
    public void testPolicy() {
        Party customer = this.customerFactory.createCustomer();
        Party patient1 = this.patientFactory.createPatient(customer);
        Party patient2 = this.patientFactory.createPatient(customer);
        Party insurer = this.insuranceFactory.createInsurer();
        JXPathContext context1 = this.createContext(patient1);
        Assert.assertNull((Object)context1.getValue("insurance:policy(.)"));
        Act policy1 = (Act)((TestPolicyBuilder)((TestPolicyBuilder)this.insuranceFactory.newPolicy().customer(customer).patient(patient1).insurer(insurer).policyNumber("AB12345").startTime("2023-01-01")).endTime("2024-01-01")).build();
        Assert.assertNull((Object)context1.getValue("insurance:policy(.)"));
        Assert.assertNull((Object)context1.getValue("insurance:policy(., false())"));
        Assert.assertEquals((Object)policy1, (Object)context1.getValue("insurance:policy(., true())"));
        Act policy2 = (Act)((TestPolicyBuilder)((TestPolicyBuilder)this.insuranceFactory.newPolicy().customer(customer).patient(patient1).insurer(insurer).policyNumber("AB98765").startTime(DateRules.getYesterday())).endTime(DateRules.getDate((Date)DateRules.getYesterday(), (int)1, (DateUnits)DateUnits.YEARS))).build();
        Assert.assertEquals((Object)policy2, (Object)context1.getValue("insurance:policy(.)"));
        Assert.assertEquals((Object)policy2, (Object)context1.getValue("insurance:policy(., false())"));
        Assert.assertEquals((Object)policy2, (Object)context1.getValue("insurance:policy(., true())"));
        JXPathContext context2 = this.createContext(patient2);
        Assert.assertNull((Object)context2.getValue("insurance:policy(.)"));
        Assert.assertNull((Object)context2.getValue("insurance:policy(., false())"));
        Assert.assertNull((Object)context2.getValue("insurance:policy(., true())"));
        Assert.assertNull((Object)context1.getValue("insurance:policy(null)"));
        Assert.assertNull((Object)context1.getValue("insurance:policy(null, false())"));
        Assert.assertNull((Object)context1.getValue("insurance:policy(null, true())"));
    }

    private JXPathContext createContext(Object object) {
        FunctionLibrary library = new FunctionLibrary();
        InsuranceFunctions functions = new InsuranceFunctions(this.insuranceRules, this.patientRules, this.getArchetypeService());
        library.addFunctions((Functions)new ObjectFunctions((Object)functions, "insurance"));
        return JXPathHelper.newContext((Object)object, (Functions)library);
    }
}

