/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.document;

import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.function.document.DocumentFunctions;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;

public class DocumentFunctionsTestCase
extends ArchetypeServiceTest {
    @Test
    public void testTextFromPatientNote() {
        this.checkTextFromNote("act.patientClinicalNote");
    }

    @Test
    public void testTextFromPatientAddendum() {
        this.checkTextFromNote("act.patientClinicalAddendum");
    }

    @Test
    public void testTextFromInvestigationResults() {
        Act results = this.create("act.patientInvestigationResults", Act.class);
        IMObjectBean bean = this.getBean((IMObject)results);
        bean.setValue("resultsId", (Object)"1");
        JXPathContext context = this.createContext((IMObject)results);
        Assert.assertNull((Object)context.getValue("document:text(., 'notes', 'longNotes')"));
        bean.setValue("notes", (Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)context.getValue("document:text(., 'notes', 'longNotes')"));
        bean.setValue("notes", null);
        DocumentAct text = this.create("act.patientInvestigationResultNote", DocumentAct.class);
        text.setDocument(this.createDocument());
        bean.addTarget("longNotes", (IMObject)text, "parent");
        bean.save(new IMObject[]{text});
        Assert.assertEquals((Object)"long content", (Object)context.getValue("document:text(., 'notes', 'longNotes')"));
    }

    private void checkTextFromNote(String archetype) {
        DocumentAct act1 = this.create(archetype, DocumentAct.class);
        JXPathContext context1 = this.createContext((IMObject)act1);
        Assert.assertNull((Object)context1.getValue("document:text(., 'note')"));
        IMObjectBean bean1 = this.getBean((IMObject)act1);
        bean1.setValue("note", (Object)"Some text");
        Assert.assertEquals((Object)"Some text", (Object)context1.getValue("document:text(., 'note')"));
        DocumentAct act2 = this.create(archetype, DocumentAct.class);
        act2.setDocument(this.createDocument());
        JXPathContext context2 = this.createContext((IMObject)act2);
        Assert.assertEquals((Object)"long content", (Object)context2.getValue("document:text(., 'note')"));
    }

    private Reference createDocument() {
        TextDocumentHandler handler = new TextDocumentHandler((ArchetypeService)this.getArchetypeService());
        Document document = handler.create("note", "long content");
        this.save((IMObject)document);
        return document.getObjectReference();
    }

    private JXPathContext createContext(IMObject object) {
        DocumentFunctions functions = new DocumentFunctions(this.getArchetypeService(), this.getLookupService());
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)new ObjectFunctions((Object)functions, "document"));
        return JXPathHelper.newContext((Object)object, (Functions)library);
    }
}

