/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.date;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.function.date.RelativeDateParser;
import org.openvpms.archetype.test.TestHelper;

public class RelativeDateParserTestCase {
    private final RelativeDateParser parser = new RelativeDateParser();

    @Test
    public void testParse() {
        this.checkEquals("1d", 1, 0, 0, 0);
        this.checkEquals("1w", 0, 1, 0, 0);
        this.checkEquals("1m", 0, 0, 1, 0);
        this.checkEquals("1y", 0, 0, 0, 1);
        this.checkEquals("1q", 0, 0, 3, 0);
        this.checkEquals("2D", 2, 0, 0, 0);
        this.checkEquals("3W", 0, 3, 0, 0);
        this.checkEquals("4M", 0, 0, 4, 0);
        this.checkEquals("5Y", 0, 0, 0, 5);
        this.checkEquals("3Q", 0, 0, 9, 0);
        this.checkEquals("-1d", -1, 0, 0, 0);
        this.checkEquals("-1w", 0, -1, 0, 0);
        this.checkEquals("-1m ", 0, 0, -1, 0);
        this.checkEquals(" -1y", 0, 0, 0, -1);
        this.checkEquals(" -1q", 0, 0, -3, 0);
        this.checkEquals("1d 2w 3m 4y ", 1, 2, 3, 4);
        this.checkEquals(" -30D-52W-12M-100Y", -30, -52, -12, -100);
        this.checkEquals(" -30D+52W-12M+100Y", -30, 52, -12, 100);
        this.checkEquals("-3y6m", 0, 0, -6, -3);
        this.checkEquals("-3y 6m", 0, 0, -6, -3);
        this.checkEquals("-3y-6m", 0, 0, -6, -3);
        this.checkEquals("-3y+6m", 0, 0, 6, -3);
    }

    @Test
    public void testLeapYear() {
        Date expected1 = TestHelper.getDate("2008-02-29");
        Date expected2 = TestHelper.getDate("2008-02-28");
        Date source = TestHelper.getDate("2011-08-30");
        RelativeDateParser parser = new RelativeDateParser();
        Assert.assertEquals((Object)expected1, (Object)parser.parse("-3y 6m", source));
        Assert.assertEquals((Object)expected2, (Object)parser.parse("-6m 3y", source));
    }

    @Test
    public void testStartEnd() {
        String[][] tests;
        Date date = TestHelper.getDate("2014-08-25");
        for (String[] test : tests = new String[][]{{"0ds", "2014-08-25"}, {"0de", "2014-08-25"}, {"0ws", "2014-08-25"}, {"0we", "2014-08-29"}, {"0ms", "2014-08-01"}, {"0me", "2014-08-31"}, {"0qs", "2014-07-01"}, {"0qe", "2014-09-30"}, {"0ys", "2014-01-01"}, {"0ye", "2014-12-31"}, {"-3ws", "2014-08-04"}, {"-3ms", "2014-05-01"}, {"-1qs", "2014-04-01"}, {"-2qs", "2014-01-01"}, {"-3qs", "2013-10-01"}, {"-4qs", "2013-07-01"}, {"-3ys", "2011-01-01"}, {"-4qs+2d", "2013-07-03"}, {"-3ys+4d", "2011-01-05"}, {"-3ys+4d+2m", "2011-03-05"}}) {
            this.checkParse(test[1], date, test[0]);
        }
    }

    @Test
    public void testQuarters() {
        this.checkParse("2014-07-01", "2014-07-01", "0q");
        this.checkParse("2014-08-25", "2014-08-25", "0q");
        this.checkParse("2014-09-30", "2014-09-30", "0q");
        this.checkParse("2014-04-01", "2014-07-01", "-1q");
        this.checkParse("2014-05-25", "2014-08-25", "-1q");
        this.checkParse("2014-06-30", "2014-09-30", "-1q");
        this.checkParse("2013-07-01", "2014-07-01", "-4q");
        this.checkParse("2013-08-25", "2014-08-25", "-4q");
        this.checkParse("2013-09-30", "2014-09-30", "-4q");
        this.checkParse("2014-10-01", "2014-07-01", "1q");
        this.checkParse("2014-11-25", "2014-08-25", "1q");
        this.checkParse("2014-12-30", "2014-09-30", "1q");
        this.checkParse("2015-07-01", "2014-07-01", "4q");
        this.checkParse("2015-08-25", "2014-08-25", "4q");
        this.checkParse("2015-09-30", "2014-09-30", "4q");
    }

    @Test
    public void testQuarterStart() {
        this.checkParse("2014-07-01", "2014-07-01", "0qs");
        this.checkParse("2014-07-01", "2014-08-25", "0qs");
        this.checkParse("2014-07-01", "2014-09-30", "0qs");
        this.checkParse("2014-04-01", "2014-07-01", "-1qs");
        this.checkParse("2014-04-01", "2014-08-25", "-1qs");
        this.checkParse("2014-04-01", "2014-09-30", "-1qs");
        this.checkParse("2013-07-01", "2014-07-01", "-4qs");
        this.checkParse("2013-07-01", "2014-08-25", "-4qs");
        this.checkParse("2013-07-01", "2014-09-30", "-4qs");
        this.checkParse("2014-10-01", "2014-07-01", "1qs");
        this.checkParse("2014-10-01", "2014-08-25", "1qs");
        this.checkParse("2014-10-01", "2014-09-30", "1qs");
        this.checkParse("2015-07-01", "2014-07-01", "4qs");
        this.checkParse("2015-07-01", "2014-08-25", "4qs");
        this.checkParse("2015-07-01", "2014-09-30", "4qs");
    }

    @Test
    public void testQuarterEnd() {
        this.checkParse("2014-09-30", "2014-07-01", "0qe");
        this.checkParse("2014-09-30", "2014-08-25", "0qe");
        this.checkParse("2014-09-30", "2014-09-30", "0qe");
        this.checkParse("2014-06-30", "2014-07-01", "-1qe");
        this.checkParse("2014-06-30", "2014-08-25", "-1qe");
        this.checkParse("2014-06-30", "2014-09-30", "-1qe");
        this.checkParse("2013-09-30", "2014-07-01", "-4qe");
        this.checkParse("2013-09-30", "2014-08-25", "-4qe");
        this.checkParse("2013-09-30", "2014-09-30", "-4qe");
        this.checkParse("2014-12-31", "2014-07-01", "1qe");
        this.checkParse("2014-12-31", "2014-08-25", "1qe");
        this.checkParse("2014-12-31", "2014-09-30", "1qe");
        this.checkParse("2015-09-30", "2014-07-01", "4qe");
        this.checkParse("2015-09-30", "2014-08-25", "4qe");
        this.checkParse("2015-09-30", "2014-09-30", "4qe");
    }

    @Test
    public void testInvalidParse() {
        Assert.assertNull((Object)this.parser.parse(null));
        Assert.assertNull((Object)this.parser.parse(""));
        Assert.assertNull((Object)this.parser.parse("  "));
        Assert.assertNull((Object)this.parser.parse("-"));
        Assert.assertNull((Object)this.parser.parse("-1"));
        Assert.assertNull((Object)this.parser.parse(" d"));
        Assert.assertNull((Object)this.parser.parse("-1dy"));
        Assert.assertNull((Object)this.parser.parse("-1z"));
        Assert.assertNull((Object)this.parser.parse("1d1z"));
        Assert.assertNull((Object)this.parser.parse("1qw"));
    }

    @Test
    public void testHours() {
        Date date = TestHelper.getDatetime("2016-07-01 10:30:05");
        this.checkEquals(date, "0h", "2016-07-01 10:30:05");
        this.checkEquals(date, "1h", "2016-07-01 11:30:05");
        this.checkEquals(date, "24h", "2016-07-02 10:30:05");
        this.checkEquals(date, "-24h", "2016-06-30 10:30:05");
    }

    private void checkParse(String expected, String date, String source) {
        this.checkParse(expected, TestHelper.getDate(date), source);
    }

    private void checkParse(String expected, Date date, String source) {
        Date value = this.parser.parse(source, date);
        Assert.assertEquals((String)("Failure for " + source), (Object)TestHelper.getDate(expected), (Object)value);
    }

    private void checkEquals(String source, int day, int week, int month, int year) {
        Date date = TestHelper.getDate("2011-04-10");
        Date relative = this.parser.parse(source, date);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, day);
        ((Calendar)calendar).add(3, week);
        ((Calendar)calendar).add(2, month);
        ((Calendar)calendar).add(1, year);
        Assert.assertEquals((Object)relative, (Object)calendar.getTime());
    }

    private void checkEquals(Date datetime, String source, String expected) {
        Date expectedDate = TestHelper.getDatetime(expected);
        Date relative = this.parser.parse(source, datetime);
        Assert.assertEquals((Object)expectedDate, (Object)relative);
    }
}

