/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.test.builder.paymentprocessor;

import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;

/**
 * Builder for <em>entity.paymentProcessor*</em> instances, for testing purposes.
 *
 * @author Tim Anderson
 */
public class TestPaymentProcessorBuilder extends AbstractTestEntityBuilder<Entity, TestPaymentProcessorBuilder> {

    /**
     * Constructs a {@link TestPaymentProcessorBuilder}.
     *
     * @param service the archetype service
     */
    public TestPaymentProcessorBuilder(ArchetypeService service) {
        this("entity.paymentProcessorTest", service);
    }

    /**
     * Constructs a {@link TestPaymentProcessorBuilder}.
     *
     * @param archetype the archetype to build. Must be an <em>entity.paymentProcessor*</em>
     * @param service   the archetype service
     */
    public TestPaymentProcessorBuilder(String archetype, ArchetypeService service) {
        super(archetype, Entity.class, service);
        name(ValueStrategy.random("zpaymentprocessor"));
    }
}