/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.test.builder.customer.account;

import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorTransactionBuilder;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorRefundBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.service.archetype.ArchetypeService;

/**
 * Builds <em>act.customerAccountRefundPP</em> instances, for testing purposes.
 *
 * @author Tim Anderson
 */
public class TestPaymentProcessorRefundItemBuilder
        extends TestPaymentProcessorItemBuilder<TestRefundBuilder, TestPaymentProcessorRefundItemBuilder> {

    /**
     * Constructs a {@link TestPaymentProcessorRefundItemBuilder}.
     *
     * @param parent  the parent builder
     * @param service the archetype service
     */
    public TestPaymentProcessorRefundItemBuilder(TestRefundBuilder parent, ArchetypeService service) {
        super(parent, CustomerAccountArchetypes.REFUND_PP, service);
    }

    /**
     * Constructs a {@link TestPaymentProcessorRefundItemBuilder}.
     *
     * @param object  the object to update
     * @param parent  the parent builder
     * @param service the archetype service
     */
    public TestPaymentProcessorRefundItemBuilder(FinancialAct object, TestRefundBuilder parent,
                                                 ArchetypeService service) {
        super(object, parent, service);
    }

    /**
     * Returns a builder to create a payment processor transaction.
     *
     * @return a new builder
     */
    @Override
    protected TestPaymentProcessorTransactionBuilder<?> createTransactionBuilder() {
        return new TestPaymentProcessorRefundBuilder(getService());
    }
}
