/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.maven.archetype;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openvpms.maven.archetype.AbstractArchetypeLoadMojo;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Mojo(name="load", requiresDependencyResolution=ResolutionScope.TEST)
public class ArchetypeLoadMojo
extends AbstractArchetypeLoadMojo {
    @Parameter
    private boolean skip;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            super.execute();
        } else {
            this.getLog().info((CharSequence)"Archetype load is skipped");
        }
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        PlatformTransactionManager mgr = (PlatformTransactionManager)this.getContext().getBean(PlatformTransactionManager.class);
        TransactionStatus status = mgr.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            this.loadArchetypes();
            mgr.commit(status);
        }
        catch (Exception throwable) {
            mgr.rollback(status);
            throw new MojoExecutionException("Failed to load archetypes", throwable);
        }
    }
}

