/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.maven.archetype;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class AbstractHibernateMojo
extends AbstractMojo {
    protected static final String APPLICATION_CONTEXT = "mavenPluginApplicationContext.xml";
    @Parameter(required=true)
    private String driver;
    @Parameter(required=true)
    private String url;
    @Parameter(required=true)
    private String username;
    @Parameter(required=true)
    private String password;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    private Properties properties;

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.properties = new Properties();
        this.properties.setProperty("jdbc.driverClassName", this.driver);
        this.properties.setProperty("jdbc.url", this.url);
        this.properties.setProperty("jdbc.username", this.username);
        this.properties.setProperty("jdbc.password", this.password);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            this.doExecute();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected ApplicationContext getContext() throws BeansException {
        return new Context();
    }

    protected String[] getContextPaths() {
        return new String[]{APPLICATION_CONTEXT};
    }

    private ClassLoader getClassLoader() {
        try {
            List classpathElements = this.project.getTestClasspathElements();
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Couldn't get the classloader.", (Throwable)e);
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
    }

    private class Context
    extends ClassPathXmlApplicationContext {
        public Context() throws BeansException {
            super(AbstractHibernateMojo.this.getContextPaths());
        }

        protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            PropertyResourceConfigurer props = (PropertyResourceConfigurer)beanFactory.getBean("props");
            props.setProperties(AbstractHibernateMojo.this.properties);
        }
    }
}

