/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.maven.archetype;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.maven.archetype.AbstractHibernateMojo;
import org.openvpms.tools.archetype.loader.ArchetypeLoader;
import org.springframework.context.ApplicationContext;

public abstract class AbstractArchetypeLoadMojo
extends AbstractHibernateMojo {
    @Parameter(required=true)
    private File dir;
    @Parameter
    private File assertionTypes;
    @Parameter
    private boolean verbose;

    protected void loadArchetypes() throws MojoExecutionException {
        if (this.dir == null || !this.dir.exists()) {
            throw new MojoExecutionException("Directory not found: " + this.dir);
        }
        if (!this.dir.isDirectory()) {
            throw new MojoExecutionException("Not a directory: " + this.dir);
        }
        ApplicationContext context = this.getContext();
        IArchetypeService service = (IArchetypeService)context.getBean("archetypeService", IArchetypeService.class);
        ArchetypeLoader loader = ArchetypeLoader.newBootstrapLoader((IArchetypeService)service);
        loader.setVerbose(this.verbose);
        File mappingFile = this.assertionTypes != null ? this.assertionTypes : new File(this.dir, "assertionTypes.xml");
        try {
            if (mappingFile.exists()) {
                loader.loadAssertions(mappingFile.getPath());
            }
            loader.loadArchetypes(this.dir.getPath(), true);
        }
        catch (Exception throwable) {
            throw new MojoExecutionException("Failed to load archetypes", throwable);
        }
    }
}

