/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.maven.archetype;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.openvpms.component.model.archetype.ActionTypeDescriptor;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.AssertionProperty;
import org.openvpms.component.model.archetype.AssertionTypeDescriptor;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.archetype.PropertyList;
import org.openvpms.component.model.archetype.PropertyMap;
import org.openvpms.component.model.object.IMObject;

public class ArchetypeChecksumGenerator {
    public int generate(List<AssertionTypeDescriptor> assertionTypes, List<ArchetypeDescriptor> archetypes) {
        CRC32 checksum = new CRC32();
        for (AssertionTypeDescriptor assertionType : this.sort(assertionTypes)) {
            this.generate(assertionType, (Checksum)checksum);
        }
        for (ArchetypeDescriptor archetype : this.sort(archetypes)) {
            this.generate(archetype, (Checksum)checksum);
        }
        return (int)checksum.getValue();
    }

    private void generate(AssertionTypeDescriptor assertionType, Checksum checksum) {
        this.add(assertionType.getName(), checksum);
        this.add(assertionType.getPropertyArchetype(), checksum);
        for (ActionTypeDescriptor actionType : this.sort(assertionType.getActionTypes())) {
            this.add(actionType.getName(), checksum);
            this.add(actionType.getClassName(), checksum);
            this.add(actionType.getMethodName(), checksum);
        }
    }

    private void generate(ArchetypeDescriptor archetype, Checksum checksum) {
        this.add(archetype.getName(), checksum);
        this.add(archetype.getArchetypeType(), checksum);
        this.add(archetype.getDisplayName(), checksum);
        this.add(archetype.getDescription(), checksum);
        this.add(archetype.getClassName(), checksum);
        this.add(archetype.isLatest(), checksum);
        this.add(archetype.isPrimary(), checksum);
        this.add(archetype.isSingleton(), checksum);
        for (NodeDescriptor node : this.sort(archetype.getNodeDescriptors())) {
            this.generate(node, checksum);
        }
    }

    private void generate(NodeDescriptor node, Checksum checksum) {
        this.add(node.getName(), checksum);
        this.add(node.getDescription(), checksum);
        this.add(node.getDefaultValue(), checksum);
        this.add(node.isDerived(), checksum);
        this.add(node.getDerivedValue(), checksum);
        this.add(node.getDisplayName(), checksum);
        this.add(node.getFilter(), checksum);
        this.add(node.getIndex(), checksum);
        this.add(node.getMaxCardinality(), checksum);
        this.add(node.getMinCardinality(), checksum);
        this.add(node.getMaxLength(), checksum);
        this.add(node.getMinLength(), checksum);
        this.add(node.getPath(), checksum);
        this.add(node.getType(), checksum);
        this.add(node.isHidden(), checksum);
        this.add(node.isReadOnly(), checksum);
        this.add(node.getBaseName(), checksum);
        this.add(node.isParentChild(), checksum);
        for (AssertionDescriptor descriptor : this.sort(node.getAssertionDescriptors().values())) {
            this.add(descriptor.getName(), checksum);
            this.add(descriptor.getDescription(), checksum);
            this.add(descriptor.getErrorMessage(), checksum);
            this.add(descriptor.getIndex(), checksum);
            for (NamedProperty property : this.sort(descriptor.getPropertyMap().getProperties().values())) {
                this.generate(property, checksum);
            }
        }
    }

    private void generate(NamedProperty property, Checksum checksum) {
        block3: {
            block4: {
                block2: {
                    this.add(property.getName(), checksum);
                    this.add(property.getDescription(), checksum);
                    if (!(property instanceof AssertionProperty)) break block2;
                    AssertionProperty assertionProperty = (AssertionProperty)property;
                    this.add(assertionProperty.getType(), checksum);
                    this.add(assertionProperty.getValue(), checksum);
                    break block3;
                }
                if (!(property instanceof PropertyList)) break block4;
                PropertyList list = (PropertyList)property;
                for (NamedProperty child : this.sort(list.getProperties())) {
                    this.generate(child, checksum);
                }
                break block3;
            }
            if (!(property instanceof PropertyMap)) break block3;
            PropertyMap map = (PropertyMap)property;
            for (NamedProperty child : this.sort(map.getProperties().values())) {
                this.generate(child, checksum);
            }
        }
    }

    private <T extends IMObject> List<T> sort(Collection<T> objects) {
        ArrayList<T> result = new ArrayList<T>(objects);
        result.sort(Comparator.comparing(IMObject::getName));
        return result;
    }

    private void add(String value, Checksum checksum) {
        if (value != null) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            checksum.update(bytes, 0, bytes.length);
        }
    }

    private void add(boolean value, Checksum checksum) {
        checksum.update(value ? 1 : 0);
    }

    private void add(int value, Checksum checksum) {
        checksum.update(value);
    }

    private void add(Object value, Checksum checksum) {
        if (value != null) {
            this.add(value.toString(), checksum);
        }
    }
}

