/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.maven.archetype;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptors;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptors;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.archetype.AssertionTypeDescriptor;
import org.openvpms.maven.archetype.ArchetypeChecksumGenerator;
import org.openvpms.tools.archetype.io.ArchetypeIOHelper;

@Mojo(name="checksum")
public class ArchetypeChecksumMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File dir;
    @Parameter
    private File assertionTypes;
    @Parameter
    private boolean override;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (this.dir == null || !this.dir.exists()) {
            throw new MojoExecutionException("Directory not found: " + this.dir);
        }
        if (!this.dir.isDirectory()) {
            throw new MojoExecutionException("Not a directory: " + this.dir);
        }
        ArchetypeChecksumGenerator generator = new ArchetypeChecksumGenerator();
        try {
            List<AssertionTypeDescriptor> assertionTypeDescriptors = this.getAssertionTypeDescriptors();
            List<ArchetypeDescriptor> archetypes = this.getArchetypeDescriptors();
            int checksum = generator.generate(assertionTypeDescriptors, archetypes);
            Properties properties = new Properties();
            String key = this.override ? "checksum.override" : "checksum.default";
            properties.put(key, Integer.toHexString(checksum));
            File metaInf = new File(this.project.getBuild().getOutputDirectory(), "META-INF");
            if (!metaInf.exists() && !metaInf.mkdirs()) {
                throw new MojoExecutionException("Failed to create " + metaInf);
            }
            File file = new File(metaInf, "openvpms-archetypes.properties");
            try (FileOutputStream out = new FileOutputStream(file);){
                properties.store(out, "");
            }
        }
        catch (MojoExecutionException exception) {
            throw exception;
        }
        catch (Exception throwable) {
            throw new MojoExecutionException("Failed to calculate archetype checksum", throwable);
        }
    }

    private List<AssertionTypeDescriptor> getAssertionTypeDescriptors() throws FileNotFoundException {
        File file = this.assertionTypes != null ? this.assertionTypes : new File(this.dir, "assertionTypes.xml");
        AssertionTypeDescriptors descriptors = AssertionTypeDescriptors.read((InputStream)new FileInputStream(file));
        return new ArrayList<AssertionTypeDescriptor>(descriptors.getAssertionTypeDescriptors().values());
    }

    private List<ArchetypeDescriptor> getArchetypeDescriptors() throws IOException, MojoExecutionException {
        ArrayList<ArchetypeDescriptor> result = new ArrayList<ArchetypeDescriptor>();
        Collection files = ArchetypeIOHelper.getArchetypeFiles((File)this.dir, (boolean)true);
        if (files.isEmpty()) {
            throw new MojoExecutionException("No archetypes found");
        }
        for (File file : files) {
            ArchetypeDescriptors descriptors = ArchetypeDescriptors.read((InputStream)new FileInputStream(file));
            result.addAll(descriptors.getArchetypeDescriptors().values());
        }
        return result;
    }
}

