/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.ws.util.filter;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.message.MessageUtils;
import org.openvpms.ws.util.filter.ErrorMessageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractErrorMessageReader
implements ErrorMessageReader {
    private static final Logger log = LoggerFactory.getLogger(AbstractErrorMessageReader.class);

    @Override
    public String read(ClientResponseContext response) {
        String message = null;
        try {
            message = this.readProtected(response);
        }
        catch (Throwable exception) {
            log.error("Failed to read error from response: " + exception.getMessage(), exception);
        }
        return message;
    }

    protected String readProtected(ClientResponseContext response) throws Throwable {
        return this.getString(response);
    }

    protected String getString(ClientResponseContext response) throws IOException {
        Charset charset = MessageUtils.getCharset(this.getMediaType(response));
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        InputStreamReader reader = new InputStreamReader(response.getEntityStream(), charset);
        return IOUtils.toString((Reader)reader);
    }

    protected MediaType getMediaType(ClientResponseContext response) {
        try {
            return response.getMediaType();
        }
        catch (Throwable exception) {
            return null;
        }
    }
}

